/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Node;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.setup.xml.I_CmsSetupXmlUpdate;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;

public abstract class A_CmsSetupXmlUpdate
implements I_CmsSetupXmlUpdate {
    public void execute(CmsSetupBean setupBean) throws Exception {
        Document doc = setupBean.getXmlHelper().getDocument(this.getXmlFilename());
        Iterator itRemove = this.getXPathsToRemove().iterator();
        while (itRemove.hasNext()) {
            String xpath = (String)itRemove.next();
            CmsSetupXmlHelper.setValue(doc, xpath, null);
        }
        Iterator itUpdate = this.getXPathsToUpdate().iterator();
        while (itUpdate.hasNext()) {
            String xpath = (String)itUpdate.next();
            this.executeUpdate(doc, xpath);
        }
    }

    public String getCodeToChange(CmsSetupBean setupBean) throws Exception {
        Node node;
        String ret = "";
        Document doc = setupBean.getXmlHelper().getDocument(this.getXmlFilename());
        Iterator itRemove = this.getXPathsToRemove().iterator();
        while (itRemove.hasNext()) {
            String xpath = (String)itRemove.next();
            Iterator it = doc.selectNodes(xpath).iterator();
            while (it.hasNext()) {
                Node node2 = (Node)it.next();
                if (node2 == null) continue;
                ret = ret + CmsXmlUtils.marshal((Node)node2, (String)"UTF-8");
            }
        }
        String parentPath = this.getCommonPath();
        Document newDoc = this.prepareDoc(doc);
        boolean modified = false;
        Iterator itUpdate = this.getXPathsToUpdate().iterator();
        while (itUpdate.hasNext()) {
            Node node3;
            String xpath = (String)itUpdate.next();
            this.updateDoc(doc, newDoc, xpath);
            boolean exe = this.executeUpdate(newDoc, xpath);
            boolean bl = modified = modified || exe;
            if (parentPath != null || !exe || (node3 = newDoc.selectSingleNode(xpath)) == null) continue;
            ret = ret + CmsXmlUtils.marshal((Node)node3, (String)"UTF-8");
        }
        if (parentPath != null && modified && (node = newDoc.selectSingleNode(parentPath)) != null) {
            ret = ret + CmsXmlUtils.marshal((Node)node, (String)"UTF-8");
        }
        return ret.trim();
    }

    protected void updateDoc(Document document, Document newDoc, String xpath) {
        Node node = document.selectSingleNode(xpath);
        if (node != null) {
            CmsSetupXmlHelper.setValue(newDoc, CmsXmlUtils.removeLastComplexXpathElement((String)xpath), " ");
            node = (Node)node.clone();
            node.setParent(null);
            ((Branch)newDoc.selectSingleNode(CmsXmlUtils.removeLastComplexXpathElement((String)xpath))).add(node);
        }
    }

    protected String getCommonPath() {
        return null;
    }

    public boolean validate(CmsSetupBean setupBean) throws Exception {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCodeToChange(setupBean));
    }

    protected boolean executeUpdate(Document document, String xpath) {
        return document == xpath;
    }

    protected List getXPathsToRemove() {
        return Collections.EMPTY_LIST;
    }

    protected List getXPathsToUpdate() {
        return Collections.EMPTY_LIST;
    }

    protected Document prepareDoc(Document doc) {
        Document newDoc = new DocumentFactory().createDocument();
        newDoc.addElement("opencms");
        newDoc.setName(doc.getName());
        return newDoc;
    }
}

