/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.i18n.CmsEncoder;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.xml.CmsXmlAddAutoSetFeatures;
import org.opencms.setup.xml.CmsXmlAddAvailabilityContextMenu;
import org.opencms.setup.xml.CmsXmlAddContentNotification;
import org.opencms.setup.xml.CmsXmlAddDEHelpSearchIndex;
import org.opencms.setup.xml.CmsXmlAddImageLoader;
import org.opencms.setup.xml.CmsXmlAddImgGalleryContextMenues;
import org.opencms.setup.xml.CmsXmlAddImgGalleryParam;
import org.opencms.setup.xml.CmsXmlAddImmutables;
import org.opencms.setup.xml.CmsXmlAddImportVersions;
import org.opencms.setup.xml.CmsXmlAddMimeTypes;
import org.opencms.setup.xml.CmsXmlAddMultiContextMenu;
import org.opencms.setup.xml.CmsXmlAddPublishButtonAppearance;
import org.opencms.setup.xml.CmsXmlAddResourceHandlers;
import org.opencms.setup.xml.CmsXmlAddResourceTypes;
import org.opencms.setup.xml.CmsXmlAddXmlContentWidgets;
import org.opencms.setup.xml.CmsXmlAddXmlSchemaTypes;
import org.opencms.setup.xml.CmsXmlRemoveImmutables;
import org.opencms.setup.xml.CmsXmlRemoveImportHandlers;
import org.opencms.setup.xml.CmsXmlRemoveImportVersions;
import org.opencms.setup.xml.CmsXmlRemovePageSearchIndexSource1;
import org.opencms.setup.xml.CmsXmlRemoveResourceHandlers;
import org.opencms.setup.xml.CmsXmlRemoveResourceLoaders;
import org.opencms.setup.xml.CmsXmlRemoveResourceTypes;
import org.opencms.setup.xml.CmsXmlRemoveSysSearchIndex;
import org.opencms.setup.xml.CmsXmlReplaceHtmlAreaWidgets;
import org.opencms.setup.xml.CmsXmlUpdateDefaultPermissions;
import org.opencms.setup.xml.CmsXmlUpdateDefaultProperties;
import org.opencms.setup.xml.CmsXmlUpdateDirectEditProvider;
import org.opencms.setup.xml.CmsXmlUpdateHistoryContextMenu;
import org.opencms.setup.xml.CmsXmlUpdateLocalizationKeys;
import org.opencms.setup.xml.I_CmsSetupXmlUpdate;
import org.opencms.util.CmsStringUtil;

public class CmsSetupXmlManager {
    private List m_plugins;
    private List m_selectedPlugins;
    private Map m_sortedPlugins;

    public void initialize(boolean fromV6) {
        this.m_selectedPlugins = new ArrayList();
        this.m_plugins = new ArrayList();
        this.m_plugins.add(new CmsXmlRemoveImmutables());
        this.m_plugins.add(new CmsXmlRemoveImportVersions());
        this.m_plugins.add(new CmsXmlRemoveImportHandlers());
        this.m_plugins.add(new CmsXmlAddImportVersions());
        this.m_plugins.add(new CmsXmlAddImmutables());
        this.m_plugins.add(new CmsXmlRemovePageSearchIndexSource1());
        this.m_plugins.add(new CmsXmlRemoveSysSearchIndex());
        this.m_plugins.add(new CmsXmlAddDEHelpSearchIndex());
        this.m_plugins.add(new CmsXmlRemoveResourceHandlers());
        this.m_plugins.add(new CmsXmlAddContentNotification());
        this.m_plugins.add(new CmsXmlAddResourceHandlers());
        this.m_plugins.add(new CmsXmlRemoveResourceLoaders());
        this.m_plugins.add(new CmsXmlRemoveResourceTypes());
        this.m_plugins.add(new CmsXmlReplaceHtmlAreaWidgets());
        this.m_plugins.add(new CmsXmlAddImageLoader());
        this.m_plugins.add(new CmsXmlAddImgGalleryParam());
        this.m_plugins.add(new CmsXmlAddXmlContentWidgets());
        this.m_plugins.add(new CmsXmlAddXmlSchemaTypes());
        this.m_plugins.add(new CmsXmlAddMimeTypes());
        this.m_plugins.add(new CmsXmlAddResourceTypes());
        if (fromV6) {
            this.m_plugins.add(new CmsXmlUpdateDefaultProperties());
            this.m_plugins.add(new CmsXmlAddAvailabilityContextMenu());
            this.m_plugins.add(new CmsXmlAddMultiContextMenu());
            this.m_plugins.add(new CmsXmlUpdateHistoryContextMenu());
            this.m_plugins.add(new CmsXmlAddImgGalleryContextMenues());
            this.m_plugins.add(new CmsXmlAddPublishButtonAppearance());
            this.m_plugins.add(new CmsXmlUpdateDefaultPermissions());
            this.m_plugins.add(new CmsXmlAddAutoSetFeatures());
            this.m_plugins.add(new CmsXmlUpdateLocalizationKeys());
        }
        this.m_plugins.add(new CmsXmlUpdateDirectEditProvider());
        this.setup();
    }

    public void execute(CmsSetupBean setupBean) throws Exception {
        Iterator it = this.m_selectedPlugins.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            int d = id.lastIndexOf(".xml") + ".xml".length();
            String fileName = id.substring(0, d);
            int pos = Integer.parseInt(id.substring(d));
            List plugins = (List)this.m_sortedPlugins.get(fileName);
            I_CmsSetupXmlUpdate plugin = (I_CmsSetupXmlUpdate)plugins.get(pos);
            plugin.execute(setupBean);
        }
        setupBean.getXmlHelper().writeAll();
    }

    public Map getPlugins() {
        return Collections.unmodifiableMap(this.m_sortedPlugins);
    }

    public String htmlAvailablePlugins(CmsSetupBean setupBean) throws Exception {
        StringBuffer html = new StringBuffer(1024);
        Iterator itFiles = this.m_sortedPlugins.keySet().iterator();
        while (itFiles.hasNext()) {
            String fileName = (String)itFiles.next();
            Iterator itPlugins = ((List)this.m_sortedPlugins.get(fileName)).iterator();
            StringBuffer code = new StringBuffer(256);
            int i = 0;
            while (itPlugins.hasNext()) {
                I_CmsSetupXmlUpdate plugin = (I_CmsSetupXmlUpdate)itPlugins.next();
                if (plugin.validate(setupBean)) {
                    code.append(this.htmlPlugin(setupBean, plugin, i));
                }
                ++i;
            }
            if (code.length() <= 0) continue;
            html.append("<tr><th colspan='2' align='left'>");
            html.append(fileName);
            html.append("</th></tr>\n");
            html.append(code.toString());
        }
        return html.toString();
    }

    public void setSelectedPlugins(String value) {
        this.m_selectedPlugins = CmsStringUtil.splitAsList((String)value, (String)"|", (boolean)true);
    }

    private String htmlPlugin(CmsSetupBean setupBean, I_CmsSetupXmlUpdate plugin, int pos) throws Exception {
        StringBuffer html = new StringBuffer(256);
        String id = plugin.getXmlFilename() + pos;
        html.append("\t<tr>\n");
        html.append("\t\t<td style='vertical-align: top;' nowrap>\n");
        html.append("\t\t\t<input type='checkbox' name='availablePlugins' value='");
        html.append(id);
        html.append("' checked='checked'>\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td style='vertical-align: top; width: 100%; padding-top: 4px;'>\n\t\t\t");
        html.append("<a href=\"javascript:switchview('").append(id).append("');\">");
        html.append(plugin.getName()).append("</a><br>\n");
        html.append("\t<div id='").append(id).append("' style='display: none;'>\n");
        String codeToChange = plugin.getCodeToChange(setupBean);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)codeToChange)) {
            html.append("<pre class='code'>");
            html.append(CmsEncoder.escapeXml((String)codeToChange));
            html.append("</pre>\n");
        }
        html.append("\t</div>\n");
        html.append("\n\t\t</td>\n");
        html.append("\t</tr>\n");
        return html.toString();
    }

    private void setup() {
        this.m_sortedPlugins = new HashMap();
        Iterator it = this.m_plugins.iterator();
        while (it.hasNext()) {
            I_CmsSetupXmlUpdate plugin = (I_CmsSetupXmlUpdate)it.next();
            ArrayList<I_CmsSetupXmlUpdate> list = (ArrayList<I_CmsSetupXmlUpdate>)this.m_sortedPlugins.get(plugin.getXmlFilename());
            if (list == null) {
                list = new ArrayList<I_CmsSetupXmlUpdate>();
                this.m_sortedPlugins.put(plugin.getXmlFilename(), list);
            }
            list.add(plugin);
        }
    }
}

