/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.setup.xml.A_CmsSetupXmlUpdate;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.xml.types.CmsXmlVarLinkValue;

public class CmsXmlAddXmlSchemaTypes
extends A_CmsSetupXmlUpdate {
    private Map m_schemaData;
    private List m_xpaths;

    public String getName() {
        return "Add new Xml schema types";
    }

    public String getXmlFilename() {
        return "opencms-vfs.xml";
    }

    protected boolean executeUpdate(Document document, String xpath) {
        Node node = document.selectSingleNode(xpath);
        if (node == null && this.getXPathsToUpdate().contains(xpath)) {
            Iterator it = this.getSchemaData().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String className = (String)entry.getKey();
                String widgetName = (String)entry.getValue();
                if (xpath.indexOf(className) <= 0) continue;
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "class", className);
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "defaultwidget", widgetName);
                break;
            }
            return true;
        }
        return false;
    }

    protected String getCommonPath() {
        StringBuffer xp = new StringBuffer(256);
        xp.append("/").append("opencms");
        xp.append("/").append("vfs");
        xp.append("/").append("xmlcontent");
        xp.append("/").append("schematypes");
        return xp.toString();
    }

    protected List getXPathsToUpdate() {
        if (this.m_xpaths == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("vfs");
            xp.append("/").append("xmlcontent");
            xp.append("/").append("schematypes");
            xp.append("/").append("schematype");
            xp.append("[@").append("class");
            xp.append("='");
            this.m_xpaths = new ArrayList();
            Iterator it = this.getSchemaData().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String className = (String)entry.getKey();
                this.m_xpaths.add(xp.toString() + className + "']");
            }
        }
        return this.m_xpaths;
    }

    private Map getSchemaData() {
        if (this.m_schemaData == null) {
            this.m_schemaData = new HashMap();
            this.m_schemaData.put(CmsXmlVarLinkValue.class.getName(), CmsVfsFileWidget.class.getName());
        }
        return this.m_schemaData;
    }
}

