/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListItem;

public class CmsProjectFilesCollector
extends A_CmsListResourceCollector {
    public static final String COLLECTOR_NAME = "projectresources";
    public static final String PARAM_PROJECT = "project";
    public static final String PARAM_STATE = "state";
    private static final Log LOG = CmsLog.getLog((Object)CmsProjectFilesCollector.class);

    public CmsProjectFilesCollector(A_CmsListExplorerDialog wp, CmsUUID projectId, CmsResourceState state) {
        super(wp);
        this.m_collectorParameter = this.m_collectorParameter + "|state:" + state;
        this.m_collectorParameter = this.m_collectorParameter + "|project:" + projectId;
    }

    public List getCollectorNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(COLLECTOR_NAME);
        return names;
    }

    public List getResources(CmsObject cms, Map params) throws CmsException {
        CmsResourceState state;
        CmsUUID projectId;
        block6: {
            block5: {
                projectId = CmsProject.ONLINE_PROJECT_ID;
                try {
                    projectId = new CmsUUID((String)params.get(PARAM_PROJECT));
                }
                catch (Throwable e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)e);
                }
            }
            state = CmsResource.STATE_KEEP;
            try {
                state = CmsResourceState.valueOf((int)Integer.parseInt((String)params.get(PARAM_STATE)));
            }
            catch (Throwable e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)e);
            }
        }
        List resources = cms.readProjectView(projectId, state);
        Iterator itRes = resources.iterator();
        String siteRoot = cms.getRequestContext().getSiteRoot();
        siteRoot = siteRoot + "/";
        while (itRes.hasNext()) {
            CmsResource resource = (CmsResource)itRes.next();
            if (resource.getRootPath().startsWith(siteRoot) || resource.getRootPath().startsWith("/system/")) continue;
            itRes.remove();
        }
        return resources;
    }

    protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
    }
}

