/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListDropdownAction;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.tools.projects.CmsProjectFilesCollector;
import org.opencms.workplace.tools.projects.CmsProjectResourcesDisplayMode;
import org.opencms.workplace.tools.projects.Messages;

public class CmsProjectFilesDialog
extends A_CmsListExplorerDialog {
    public static final String LIST_IACTION_FILTER = "iaf";
    public static final String LIST_ID = "lpr";
    private I_CmsListResourceCollector m_collector;
    private String m_filter;
    private String m_paramProjectid;

    public CmsProjectFilesDialog(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_PROJECT_FILES_LIST_NAME_0"));
    }

    public CmsProjectFilesDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListIndepActions() {
        if (this.getParamListAction().equals(LIST_IACTION_FILTER)) {
            this.getList().setCurrentPage(1);
            this.m_collector = null;
            this.refreshList();
        } else {
            super.executeListIndepActions();
        }
    }

    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            CmsUUID projectId = this.getProject().getUuid();
            CmsResourceState state = CmsResource.STATE_KEEP;
            CmsHtmlList list = this.getList();
            if (list != null && this.getSettings().getCollector() != null) {
                this.getSettings().setCollector(null);
            }
            if (this.m_filter.equals("new")) {
                state = CmsResource.STATE_NEW;
            } else if (this.m_filter.equals("changed")) {
                state = CmsResource.STATE_CHANGED;
            } else if (this.m_filter.equals("deleted")) {
                state = CmsResource.STATE_DELETED;
            }
            this.m_collector = new CmsProjectFilesCollector(this, projectId, state);
        }
        return this.m_collector;
    }

    public CmsHtmlList getList() {
        CmsHtmlList list = super.getList();
        this.m_filter = this.getJsp().getRequest().getParameter("iaf-sel");
        CmsListDropdownAction listAction = null;
        if (list != null) {
            listAction = (CmsListDropdownAction)list.getMetadata().getIndependentAction(LIST_IACTION_FILTER);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_filter)) {
                this.m_filter = listAction.getSelection();
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_filter)) {
            this.m_filter = CmsProjectResourcesDisplayMode.ALL_CHANGES.getMode();
        }
        if (listAction != null) {
            listAction.setSelection(this.m_filter);
        }
        return list;
    }

    public String getParamProjectid() {
        return this.m_paramProjectid;
    }

    public synchronized void refreshList() {
        if (LIST_IACTION_FILTER.equals(this.getParamListAction()) && this.m_collector != null) {
            return;
        }
        super.refreshList();
    }

    public void setParamProjectid(String projectId) {
        this.m_paramProjectid = projectId;
    }

    protected void fillDetails(String detailId) {
    }

    protected CmsProject getProject() {
        CmsUUID projectId = new CmsUUID(this.getParamProjectid());
        try {
            return this.getCms().readProject(projectId);
        }
        catch (CmsException e) {
            return super.getProject();
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListDropdownAction filterAction = new CmsListDropdownAction(LIST_IACTION_FILTER);
        filterAction.setName(Messages.get().container("GUI_PROJECT_FILES_FILTER_ACTION_NAME_0"));
        filterAction.setHelpText(Messages.get().container("GUI_PROJECT_FILES_FILTER_ACTION_HELP_0"));
        Iterator it = CmsProjectResourcesDisplayMode.VALUES.iterator();
        while (it.hasNext()) {
            CmsProjectResourcesDisplayMode mode = (CmsProjectResourcesDisplayMode)it.next();
            filterAction.addItem(mode.getMode(), Messages.get().container("label." + mode.getMode()));
        }
        metadata.addIndependentAction((I_CmsListAction)filterAction);
        super.setIndependentActions(metadata);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void validateParamaters() throws Exception {
        try {
            this.getCms().readProject(new CmsUUID(this.getParamProjectid()));
        }
        catch (Exception e) {
            if (!this.getCms().getRequestContext().currentProject().isOnlineProject()) {
                this.m_paramProjectid = this.getCms().getRequestContext().currentProject().getUuid().toString();
            }
            throw e;
        }
    }
}

