/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.projects.Messages;

public class CmsProjectHistoryList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_CREATION = "cc";
    public static final String LIST_COLUMN_DESCRIPTION = "cd";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_MANAGER = "cm";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_OWNER = "co";
    public static final String LIST_COLUMN_PUBLISHED_BY = "cb";
    public static final String LIST_COLUMN_PUBLISHED_DATE = "cp";
    public static final String LIST_COLUMN_USER = "cu";
    public static final String LIST_DETAIL_RESOURCES = "dr";
    public static final String LIST_ID = "lph";

    public CmsProjectHistoryList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_PROJECTHISTORY_LIST_NAME_0"), LIST_COLUMN_PUBLISHED_DATE, CmsListOrderEnum.ORDER_DESCENDING, null);
    }

    public CmsProjectHistoryList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    protected void fillDetails(String detailId) {
        List projects = this.getList().getAllContent();
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsListItem item = (CmsListItem)itProjects.next();
            try {
                if (!detailId.equals(LIST_DETAIL_RESOURCES)) continue;
                CmsHistoryProject project = this.getCms().readHistoryProject(new Integer(item.getId()).intValue());
                StringBuffer html = new StringBuffer(512);
                Iterator resources = project.getProjectResources().iterator();
                while (resources.hasNext()) {
                    html.append(resources.next().toString());
                    html.append("<br>");
                }
                item.set(LIST_DETAIL_RESOURCES, (Object)html.toString());
            }
            catch (Exception e) {}
        }
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List projects = this.getCms().getAllHistoricalProjects();
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsHistoryProject project = (CmsHistoryProject)itProjects.next();
            CmsListItem item = this.getList().newItem(new Integer(project.getPublishTag()).toString());
            item.set(LIST_COLUMN_NAME, (Object)project.getName());
            item.set(LIST_COLUMN_DESCRIPTION, (Object)project.getDescription());
            try {
                item.set(LIST_COLUMN_OWNER, (Object)project.getOwnerName(this.getCms()));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                item.set(LIST_COLUMN_MANAGER, (Object)project.getGroupManagersName(this.getCms()));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                item.set(LIST_COLUMN_USER, (Object)project.getGroupUsersName(this.getCms()));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                item.set(LIST_COLUMN_PUBLISHED_DATE, (Object)new Date(project.getPublishingDate()));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                item.set(LIST_COLUMN_PUBLISHED_BY, (Object)project.getPublishedByName(this.getCms()));
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(LIST_COLUMN_CREATION, (Object)new Date(project.getDateCreated()));
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_ICON_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_ICON_HELP_0"));
        iconAction.setIconPath("tools/projects/buttons/project.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_NAME_0"));
        nameCol.setWidth("10%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition descriptionCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descriptionCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_DESCRIPTION_0"));
        descriptionCol.setWidth("30%");
        descriptionCol.setTextWrapping(true);
        metadata.addColumn(descriptionCol);
        CmsListColumnDefinition publishingDateCol = new CmsListColumnDefinition(LIST_COLUMN_PUBLISHED_DATE);
        publishingDateCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_PUBLISHED_DATE_0"));
        publishingDateCol.setWidth("10%");
        publishingDateCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(publishingDateCol);
        CmsListColumnDefinition publishedByCol = new CmsListColumnDefinition(LIST_COLUMN_PUBLISHED_BY);
        publishedByCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_PUBLISHED_BY_0"));
        publishedByCol.setWidth("10%");
        metadata.addColumn(publishedByCol);
        CmsListColumnDefinition ownerCol = new CmsListColumnDefinition(LIST_COLUMN_OWNER);
        ownerCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_OWNER_0"));
        ownerCol.setWidth("10%");
        metadata.addColumn(ownerCol);
        CmsListColumnDefinition managerCol = new CmsListColumnDefinition(LIST_COLUMN_MANAGER);
        managerCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_MANAGER_0"));
        managerCol.setWidth("10%");
        metadata.addColumn(managerCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_USER_0"));
        userCol.setWidth("10%");
        metadata.addColumn(userCol);
        CmsListColumnDefinition creationCol = new CmsListColumnDefinition(LIST_COLUMN_CREATION);
        creationCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_CREATION_0"));
        creationCol.setWidth("10%");
        creationCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(creationCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails resourcesDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourcesDetails.setAtColumn(LIST_COLUMN_NAME);
        resourcesDetails.setVisible(false);
        resourcesDetails.setShowActionName(Messages.get().container("GUI_PROJECTS_DETAIL_SHOW_RESOURCES_NAME_0"));
        resourcesDetails.setShowActionHelpText(Messages.get().container("GUI_PROJECTS_DETAIL_SHOW_RESOURCES_HELP_0"));
        resourcesDetails.setHideActionName(Messages.get().container("GUI_PROJECTS_DETAIL_HIDE_RESOURCES_NAME_0"));
        resourcesDetails.setHideActionHelpText(Messages.get().container("GUI_PROJECTS_DETAIL_HIDE_RESOURCES_HELP_0"));
        resourcesDetails.setName(Messages.get().container("GUI_PROJECTS_DETAIL_RESOURCES_NAME_0"));
        resourcesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_PROJECTS_DETAIL_RESOURCES_NAME_0")));
        metadata.addItemDetails(resourcesDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_NAME));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_DESCRIPTION));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

