/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.db.Messages;
import org.opencms.main.CmsIllegalArgumentException;

public final class CmsProjectResourcesDisplayMode
implements Serializable {
    private static final long serialVersionUID = 923124162399716633L;
    public static final CmsProjectResourcesDisplayMode ALL_CHANGES = new CmsProjectResourcesDisplayMode("all");
    public static final CmsProjectResourcesDisplayMode DELETED_FILES = new CmsProjectResourcesDisplayMode("deleted");
    public static final CmsProjectResourcesDisplayMode MODIFIED_FILES = new CmsProjectResourcesDisplayMode("changed");
    public static final CmsProjectResourcesDisplayMode NEW_FILES = new CmsProjectResourcesDisplayMode("new");
    private static final CmsProjectResourcesDisplayMode[] VALUE_ARRAY = new CmsProjectResourcesDisplayMode[]{ALL_CHANGES, NEW_FILES, DELETED_FILES, MODIFIED_FILES};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUE_ARRAY));
    private final String m_mode;

    private CmsProjectResourcesDisplayMode(String mode) {
        this.m_mode = mode;
    }

    public static CmsProjectResourcesDisplayMode valueOf(String value) throws CmsIllegalArgumentException {
        Iterator iter = VALUES.iterator();
        while (iter.hasNext()) {
            CmsProjectResourcesDisplayMode target = (CmsProjectResourcesDisplayMode)iter.next();
            if (!value.equals(target.getMode())) continue;
            return target;
        }
        throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODE_ENUM_PARSE_2", (Object)value, (Object)CmsProjectResourcesDisplayMode.class.getName()));
    }

    public String getMode() {
        return this.m_mode;
    }

    public String toString() {
        return this.m_mode;
    }
}

