/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.util.HashMap;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.administration.CmsAdminDialog;
import org.opencms.workplace.tools.A_CmsToolHandler;
import org.opencms.workplace.tools.projects.CmsProjectFilesDialog;

public class CmsProjectsToolHandler
extends A_CmsToolHandler {
    private static final String PROJECT_ID = "projectid";
    private static final String PROJECT_NAME = "projectname";
    private static final String PROJECT_OVERVIEW_FILE = "/system/workplace/admin/projects/project_overview.jsp";

    public Map getParameters(CmsWorkplace wp) {
        if (OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.PROJECT_MANAGER)) {
            return super.getParameters(wp);
        }
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put(PROJECT_ID, wp.getCms().getRequestContext().currentProject().getUuid().toString());
        argMap.put(PROJECT_NAME, wp.getCms().getRequestContext().currentProject().getName());
        if (wp instanceof CmsProjectFilesDialog) {
            argMap.put("showexplorer", "false");
        }
        if (wp instanceof CmsAdminDialog) {
            argMap.put("showexplorer", "true");
        }
        return argMap;
    }

    public boolean isEnabled(CmsObject cms) {
        return true;
    }

    public boolean isVisible(CmsObject cms) {
        if (OpenCms.getRoleManager().hasRole(cms, CmsRole.PROJECT_MANAGER)) {
            return !this.getLink().equals(PROJECT_OVERVIEW_FILE);
        }
        return this.getLink().equals(PROJECT_OVERVIEW_FILE);
    }
}

