/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsProject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsHtmlReport;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsReport;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.threads.CmsRelationsValidatorThread;

public class CmsPublishProjectReport
extends CmsReport {
    public static final String PARAM_PROJECTID = "projectid";
    private String m_paramProjectid;

    public CmsPublishProjectReport(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPublishProjectReport(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void displayReport() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        switch (this.getAction()) {
            case 92: {
                this.actionCloseDialog();
                break;
            }
            case 4: {
                this.actionCloseDialog();
                break;
            }
            case 91: {
                this.setParamAction("reportupdate");
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
                break;
            }
            default: {
                try {
                    if (this.getCms().readProject(new CmsUUID(this.getParamProjectid())).getType() == CmsProject.PROJECT_TYPE_TEMPORARY) {
                        this.setParamRefreshWorkplace(CmsStringUtil.TRUE);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.getParamProjectid() == null) {
                    return;
                }
                CmsPublishList list = null;
                try {
                    CmsProject currentProject = this.getCms().getRequestContext().currentProject();
                    this.getCms().getRequestContext().setCurrentProject(this.getCms().readProject(new CmsUUID(this.getParamProjectid())));
                    list = OpenCms.getPublishManager().getPublishList(this.getCms());
                    this.getCms().getRequestContext().setCurrentProject(currentProject);
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
                }
                this.startValidationThread(list);
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
            }
        }
    }

    public String getParamProjectid() {
        return this.m_paramProjectid;
    }

    public void setParamProjectid(String projectId) {
        this.m_paramProjectid = projectId;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if ("reportupdate".equals(this.getParamAction())) {
            this.setAction(91);
        } else if ("reportbegin".equals(this.getParamAction())) {
            this.setAction(90);
        } else if ("reportend".equals(this.getParamAction())) {
            if (Boolean.valueOf(this.getParamThreadHasNext()).booleanValue()) {
                this.startPublishThread();
            } else {
                this.setAction(92);
            }
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
        }
    }

    private void startPublishThread() {
        CmsPublishList publishList = this.getSettings().getPublishList();
        try {
            OpenCms.getPublishManager().publishProject(this.getCms(), (I_CmsReport)new CmsHtmlReport(this.getLocale(), this.getCms().getRequestContext().getSiteRoot()), publishList);
        }
        catch (CmsException e) {
            throw new CmsRuntimeException(e.getMessageContainer());
        }
        this.setParamAction("reportend");
        this.setAction(92);
        this.setParamThreadHasNext(CmsStringUtil.FALSE);
    }

    private void startValidationThread(CmsPublishList publishList) throws JspException {
        try {
            CmsRelationsValidatorThread thread = new CmsRelationsValidatorThread(this.getCms(), publishList, this.getSettings());
            thread.start();
            this.setParamThread(thread.getUUID().toString());
            this.setParamThreadHasNext(CmsStringUtil.TRUE);
            this.setParamAction("reportbegin");
            this.setParamReportContinueKey("GUI_PUBLISH_CONTINUE_BROKEN_LINKS_0");
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }
}

