/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.history;

import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.tools.history.CmsHistoryClear;
import org.opencms.workplace.tools.history.Messages;

public class CmsHistoryClearThread
extends A_CmsReportThread {
    private CmsHistoryClear m_historyClear;

    public CmsHistoryClearThread(CmsObject cms, CmsHistoryClear historyClear) {
        super(cms, Messages.get().getBundle().key("GUI_HISTORY_CLEAR_THREAD_NAME_1", (Object)cms.getRequestContext().currentProject().getName()));
        this.m_historyClear = historyClear;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        this.getReport().println(Messages.get().container("RPT_DELETE_HISTORY_BEGIN_0"), 2);
        int versions = this.m_historyClear.getKeepVersions();
        int versionsDeleted = this.m_historyClear.getKeepVersions();
        long timeDeleted = this.m_historyClear.getClearOlderThan();
        String folderName = "/";
        if (timeDeleted == 0L) {
            timeDeleted = -1L;
        }
        if (!this.m_historyClear.isClearDeleted()) {
            versionsDeleted = -1;
        }
        try {
            this.getCms().deleteHistoricalVersions(folderName, versions, versionsDeleted, timeDeleted, this.getReport());
        }
        catch (CmsException e) {
            this.getReport().println((Throwable)e);
        }
        this.getReport().println(Messages.get().container("RPT_DELETE_HISTORY_END_0"), 2);
    }
}

