/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.searchindex.Messages;

public abstract class A_CmsEditSearchIndexDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "searchindex";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_INDEXNAME = "indexname";
    protected CmsSearchIndex m_index;
    protected CmsSearchManager m_searchManager;
    private String m_paramIndexName;

    public A_CmsEditSearchIndexDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsEditSearchIndexDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected static void writeConfiguration() {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (!this.m_searchManager.getSearchIndexes().contains(this.m_index)) {
                this.m_searchManager.addSearchIndex(this.m_index);
            }
            if (!this.m_index.getFieldConfigurationName().equals(this.m_index.getFieldConfiguration().getName())) {
                this.m_index.setFieldConfiguration(this.m_searchManager.getFieldConfiguration(this.m_index.getFieldConfigurationName()));
            }
            A_CmsEditSearchIndexDialog.writeConfiguration();
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getParamIndexName() {
        return this.m_paramIndexName;
    }

    public void setParamIndexName(String paramSearchIndex) {
        this.m_paramIndexName = paramSearchIndex;
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix(KEY_PREFIX);
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected String getToolPath() {
        return "/searchindex";
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initUserObject() {
        try {
            this.m_index = this.m_searchManager.getIndex(this.getParamIndexName());
            if (this.m_index == null) {
                this.m_index = this.createDummySearchIndex();
            }
        }
        catch (Exception e) {
            this.m_index = this.createDummySearchIndex();
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        this.m_searchManager = OpenCms.getSearchManager();
        super.initWorkplaceMembers(jsp);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, CmsSearchIndex> dialogObject = (HashMap<String, CmsSearchIndex>)this.getDialogObject();
        if (dialogObject == null) {
            dialogObject = new HashMap<String, CmsSearchIndex>();
            dialogObject.put(PARAM_INDEXNAME, this.m_index);
            this.setDialogObject(dialogObject);
        }
    }

    protected boolean isNewSearchIndex() {
        return "initial".equals(this.getParamAction());
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewSearchIndex() && this.getParamIndexName() == null && this.getJsp().getRequest().getParameter("name.0") == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)PARAM_INDEXNAME));
        }
    }

    private CmsSearchIndexSource createDummyIndexSource() {
        CmsSearchIndexSource result = new CmsSearchIndexSource();
        result.setName("default");
        result.setIndexerClassName("org.opencms.search.CmsVfsIndexer");
        result.addDocumentType("html");
        result.addDocumentType("generic");
        result.addDocumentType("pdf");
        this.m_searchManager.addSearchIndexSource(result);
        return result;
    }

    private CmsSearchIndex createDummySearchIndex() {
        CmsSearchIndex result = new CmsSearchIndex();
        result.setLocale(Locale.ENGLISH);
        result.setProjectName("Online");
        result.setRebuildMode("auto");
        Map sources = this.m_searchManager.getSearchIndexSources();
        if (sources.isEmpty()) {
            CmsSearchIndexSource source = this.createDummyIndexSource();
            sources.put(source.getName(), source);
        }
        result.addSourceName((String)sources.keySet().iterator().next());
        return result;
    }
}

