/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.searchindex.Messages;

public class A_CmsFieldDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "fieldconfiguration.field";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_FIELD = "field";
    public static final String PARAM_FIELDCONFIGURATION = "fieldconfiguration";
    protected CmsSearchField m_field;
    protected CmsSearchFieldConfiguration m_fieldconfiguration;
    protected CmsSearchManager m_searchManager;
    private String m_paramField;
    private String m_paramFieldConfiguration;

    public A_CmsFieldDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsFieldDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected static void writeConfiguration() {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            boolean found = false;
            Iterator itFields = this.m_fieldconfiguration.getFields().iterator();
            while (itFields.hasNext()) {
                if (!((CmsSearchField)itFields.next()).getName().equals(this.m_field.getName())) continue;
                found = true;
            }
            if (!found) {
                this.m_fieldconfiguration.addField(this.m_field);
            }
            if (this.checkWriteConfiguration()) {
                A_CmsFieldDialog.writeConfiguration();
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getParamField() {
        return this.m_paramField;
    }

    public String getParamFieldconfiguration() {
        return this.m_paramFieldConfiguration;
    }

    public void setParamField(String field) {
        this.m_paramField = field;
    }

    public void setParamFieldconfiguration(String fieldconfiguration) {
        this.m_paramFieldConfiguration = fieldconfiguration;
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix(KEY_PREFIX);
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initUserObject() {
        if (this.m_fieldconfiguration == null) {
            try {
                this.m_fieldconfiguration = this.m_searchManager.getFieldConfiguration(this.getParamFieldconfiguration());
                if (this.m_fieldconfiguration == null) {
                    this.m_fieldconfiguration = new CmsSearchFieldConfiguration();
                }
            }
            catch (Exception e) {
                this.m_fieldconfiguration = new CmsSearchFieldConfiguration();
            }
        }
        if (this.m_field == null) {
            try {
                Iterator itFields = this.m_fieldconfiguration.getFields().iterator();
                while (itFields.hasNext()) {
                    CmsSearchField curField = (CmsSearchField)itFields.next();
                    if (!curField.getName().equals(this.getParamField())) continue;
                    this.m_field = curField;
                    break;
                }
                if (this.m_field == null) {
                    this.m_field = new CmsSearchField();
                }
            }
            catch (Exception e) {
                this.m_field = new CmsSearchField();
            }
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        this.m_searchManager = OpenCms.getSearchManager();
        super.initWorkplaceMembers(jsp);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, Object> dialogObject = (HashMap<String, Object>)this.getDialogObject();
        if (dialogObject == null) {
            dialogObject = new HashMap<String, Object>();
            dialogObject.put(PARAM_FIELDCONFIGURATION, this.m_fieldconfiguration);
            dialogObject.put(PARAM_FIELD, this.m_field);
            this.setDialogObject(dialogObject);
        }
    }

    protected boolean isNewField() {
        return "initial".equals(this.getParamAction());
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewField() && this.getParamField() == null && this.getJsp().getRequest().getParameter("name.0") == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)PARAM_FIELD));
        }
    }

    private boolean checkWriteConfiguration() {
        return !this.m_field.getMappings().isEmpty();
    }
}

