/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.searchindex.A_CmsEmbeddedListDialog;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsDocumentTypeList
extends A_CmsEmbeddedListDialog {
    public static final String LIST_ACTION_NONE = "an";
    public static final String LIST_COLUMN_DOCCLASS = "cdc";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_DETAIL_MIMETYPES = "dmt";
    public static final String LIST_DETAIL_RESOURCETYPES = "drt";
    public static final String LIST_ID = "lssisdt";
    protected static final String ICON_DOCTYPE = "tools/searchindex/icons/small/indexsource-doctype.png";
    private static final Log LOG = CmsLog.getLog((Object)CmsDocumentTypeList.class);
    private String m_paramIndexsource;

    public CmsDocumentTypeList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_DOCUMENTTYPES_NAME_0"));
    }

    public CmsDocumentTypeList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsDocumentTypeList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public CmsDocumentTypeList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
    }

    public void executeListSingleActions() {
    }

    public String getParamIndexsource() {
        return this.m_paramIndexsource;
    }

    public void setParamIndexsource(String indexsource) {
        this.m_paramIndexsource = indexsource;
    }

    protected void fillDetails(String detailId) {
        CmsListItem item;
        List items = this.getList().getAllContent();
        Iterator itItems = items.iterator();
        if (detailId.equals(LIST_DETAIL_MIMETYPES)) {
            while (itItems.hasNext()) {
                item = (CmsListItem)itItems.next();
                this.fillDetailMimetypes(item, detailId);
            }
        }
        if (detailId.equals(LIST_DETAIL_RESOURCETYPES)) {
            while (itItems.hasNext()) {
                item = (CmsListItem)itItems.next();
                this.fillDetailResourceTypes(item, detailId);
            }
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List doctypes = this.documentTypes();
        Iterator itDoctypes = doctypes.iterator();
        while (itDoctypes.hasNext()) {
            CmsSearchDocumentType doctype = (CmsSearchDocumentType)itDoctypes.next();
            CmsListItem item = this.getList().newItem(doctype.getName());
            item.set(LIST_COLUMN_NAME, (Object)doctype.getName());
            item.set(LIST_COLUMN_DOCCLASS, (Object)doctype.getClassName());
            result.add(item);
        }
        return result;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition dummyCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        dummyCol.setName(Messages.get().container("GUI_LIST_DOCUMENTTYPE_NAME_0"));
        dummyCol.setHelpText(Messages.get().container("GUI_LIST_DOCUMENTTYPE_NAME_HELP_0"));
        dummyCol.setWidth("20");
        dummyCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        dummyCol.setSorteable(false);
        CmsListDirectAction dummyAction = new CmsListDirectAction(LIST_ACTION_NONE);
        dummyAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_0"));
        dummyAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_HELP_0"));
        dummyAction.setIconPath(ICON_DOCTYPE);
        dummyAction.setEnabled(false);
        dummyCol.addDirectAction((I_CmsListDirectAction)dummyAction);
        metadata.addColumn(dummyCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        nameCol.setWidth("50%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition docclassCol = new CmsListColumnDefinition(LIST_COLUMN_DOCCLASS);
        docclassCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        docclassCol.setName(Messages.get().container("GUI_LIST_DOCTYPE_COL_DOCCLASS_0"));
        docclassCol.setWidth("50%");
        metadata.addColumn(docclassCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails mimetypeDetails = new CmsListItemDetails(LIST_DETAIL_MIMETYPES);
        mimetypeDetails.setAtColumn(LIST_COLUMN_NAME);
        mimetypeDetails.setVisible(false);
        mimetypeDetails.setShowActionName(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_SHOW_0"));
        mimetypeDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_SHOW_HELP_0"));
        mimetypeDetails.setHideActionName(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_HIDE_0"));
        mimetypeDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_HIDE_HELP_0"));
        mimetypeDetails.setName(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_NAME_0"));
        mimetypeDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_NAME_0")));
        metadata.addItemDetails(mimetypeDetails);
        CmsListItemDetails resourceDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCETYPES);
        resourceDetails.setAtColumn(LIST_COLUMN_NAME);
        resourceDetails.setVisible(false);
        resourceDetails.setShowActionName(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_SHOW_0"));
        resourceDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_SHOW_HELP_0"));
        resourceDetails.setHideActionName(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_HIDE_0"));
        resourceDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_HIDE_HELP_0"));
        resourceDetails.setName(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_NAME_0"));
        resourceDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_NAME_0")));
        metadata.addItemDetails(resourceDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void validateParamaters() throws Exception {
        if (this.getParamIndexsource() == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"indexsource"));
        }
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private List documentTypes() {
        ArrayList<CmsSearchDocumentType> result;
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsSearchIndexSource indexsource = manager.getIndexSource(this.getParamIndexsource());
        if (indexsource != null) {
            List doctypes = indexsource.getDocumentTypes();
            result = new ArrayList(doctypes.size());
            Iterator it = doctypes.iterator();
            String doctypename = "";
            while (it.hasNext()) {
                CmsSearchDocumentType doctype;
                doctypename = (String)it.next();
                if (doctypename == null || (doctype = manager.getDocumentTypeConfig(doctypename)) == null) continue;
                result.add(doctype);
            }
        } else {
            result = new ArrayList<CmsSearchDocumentType>(0);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"indexsource"));
            }
        }
        return result;
    }

    private void fillDetailMimetypes(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String doctypeName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchDocumentType docType = searchManager.getDocumentTypeConfig(doctypeName);
        Iterator itMimetypes = docType.getMimeTypes().iterator();
        html.append("<ul>\n");
        while (itMimetypes.hasNext()) {
            html.append("  <li>\n").append("  ").append(itMimetypes.next()).append("\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private void fillDetailResourceTypes(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String doctypeName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchDocumentType docType = searchManager.getDocumentTypeConfig(doctypeName);
        Iterator itResourcetypes = docType.getResourceTypes().iterator();
        html.append("<ul>\n");
        while (itResourcetypes.hasNext()) {
            html.append("  <li>\n").append("  ").append(itResourcetypes.next()).append("\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }
}

