/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.searchindex.A_CmsEmbeddedListDialog;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsFieldsList
extends A_CmsEmbeddedListDialog {
    public static final String ICON_FALSE = "list/multi_deactivate.png";
    public static final String ICON_TRUE = "list/multi_activate.png";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_EXCERPT_FALSE = "aef";
    public static final String LIST_ACTION_EXCERPT_TRUE = "aet";
    public static final String LIST_ACTION_INDEX_FALSE = "aif";
    public static final String LIST_ACTION_INDEX_TRUE = "ait";
    public static final String LIST_ACTION_MAPPING = "am";
    public static final String LIST_ACTION_OVERVIEW_FIELD = "aof";
    public static final String LIST_ACTION_STORE_FALSE = "asf";
    public static final String LIST_ACTION_STORE_TRUE = "ast";
    public static final String LIST_COLUMN_BOOST = "cb";
    public static final String LIST_COLUMN_DEFAULT = "cd";
    public static final String LIST_COLUMN_DISPLAY = "cdi";
    public static final String LIST_COLUMN_EDIT = "ced";
    public static final String LIST_COLUMN_EXCERPT = "ce";
    public static final String LIST_COLUMN_EXCERPT_HIDE = "ceh";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_INDEX = "cx";
    public static final String LIST_COLUMN_MAPPING = "cm";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_STORE = "cs";
    public static final String LIST_COLUMN_STORE_HIDE = "csh";
    public static final String LIST_DETAIL_FIELD = "df";
    public static final String LIST_ID = "lsfcf";
    public static final String LIST_MACTION_DELETEFIELD = "mad";
    protected static final String LIST_ICON_FIELD_EDIT = "tools/searchindex/icons/small/fieldconfiguration-editfield.png";
    private static final Log LOG = CmsLog.getLog((Object)CmsFieldsList.class);
    private String m_paramFieldconfiguration;

    public CmsFieldsList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_FIELDS_NAME_0"));
    }

    public CmsFieldsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsFieldsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public void executeListMultiActions() {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        if (this.getParamListAction().equals(LIST_MACTION_DELETEFIELD)) {
            Iterator itFields;
            Iterator itItems = this.getSelectedItems().iterator();
            ArrayList<CmsSearchField> deleteFields = new ArrayList<CmsSearchField>();
            List fields = searchManager.getFieldConfiguration(this.m_paramFieldconfiguration).getFields();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                itFields = fields.iterator();
                while (itFields.hasNext()) {
                    CmsSearchField curField;
                    String fieldName;
                    String item = (String)listItem.get(LIST_COLUMN_NAME);
                    if (!item.equals(fieldName = (curField = (CmsSearchField)itFields.next()).getName())) continue;
                    deleteFields.add(curField);
                }
            }
            itFields = deleteFields.iterator();
            while (itFields.hasNext()) {
                CmsSearchField field = (CmsSearchField)itFields.next();
                searchManager.removeSearchFieldConfigurationField(searchManager.getFieldConfiguration(this.m_paramFieldconfiguration), field);
            }
            this.refreshList();
            if (this.checkWriteConfiguration(fields)) {
                this.writeConfiguration(false);
            }
        }
        this.listSave();
    }

    public void executeListSingleActions() throws ServletException, IOException {
        String field = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        String action = this.getParamListAction();
        CmsSearchFieldConfiguration fieldConfig = OpenCms.getSearchManager().getFieldConfiguration(this.m_paramFieldconfiguration);
        Iterator itFields = fieldConfig.getFields().iterator();
        CmsSearchField fieldObject = null;
        while (itFields.hasNext()) {
            CmsSearchField curField = (CmsSearchField)itFields.next();
            if (!curField.getName().equals(field)) continue;
            fieldObject = curField;
        }
        params.put("field", field);
        params.put("fieldconfiguration", this.m_paramFieldconfiguration);
        params.put("action", "initial");
        params.put("style", "new");
        if (action.equals(LIST_ACTION_EDIT)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/field/edit", params);
        } else if (action.equals(LIST_ACTION_MAPPING)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/field/newmapping", params);
        } else if (action.equals(LIST_ACTION_OVERVIEW_FIELD)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/field", params);
        } else if (action.equals(LIST_ACTION_EXCERPT_FALSE)) {
            if (fieldObject != null) {
                fieldObject.setInExcerpt(true);
                this.writeConfiguration(true);
            }
        } else if (action.equals(LIST_ACTION_INDEX_FALSE)) {
            if (fieldObject != null) {
                fieldObject.setIndexed(true);
                this.writeConfiguration(true);
            }
        } else if (action.equals(LIST_ACTION_STORE_FALSE)) {
            if (fieldObject != null) {
                fieldObject.setStored(true);
                this.writeConfiguration(true);
            }
        } else if (action.equals(LIST_ACTION_EXCERPT_TRUE)) {
            if (fieldObject != null) {
                fieldObject.setInExcerpt(false);
                this.writeConfiguration(true);
            }
        } else if (action.equals(LIST_ACTION_INDEX_TRUE)) {
            if (fieldObject != null) {
                fieldObject.setIndexed(false);
                this.writeConfiguration(true);
            }
        } else if (action.equals(LIST_ACTION_STORE_TRUE) && fieldObject != null) {
            fieldObject.setStored(false);
            this.writeConfiguration(true);
        }
        this.listSave();
    }

    public String getParamFieldconfiguration() {
        return this.m_paramFieldconfiguration;
    }

    public void setParamFieldconfiguration(String fieldconfiguration) {
        this.m_paramFieldconfiguration = fieldconfiguration;
    }

    protected void fillDetails(String detailId) {
        List items = this.getList().getAllContent();
        Iterator itItems = items.iterator();
        while (itItems.hasNext()) {
            CmsListItem item = (CmsListItem)itItems.next();
            if (!detailId.equals(LIST_DETAIL_FIELD)) continue;
            this.fillDetailField(item, detailId);
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List fields = this.getFields();
        Iterator itFields = fields.iterator();
        while (itFields.hasNext()) {
            CmsSearchField field = (CmsSearchField)itFields.next();
            CmsListItem item = this.getList().newItem(field.getName());
            String defaultValue = field.getDefaultValue();
            if (defaultValue == null) {
                defaultValue = "-";
            }
            item.set(LIST_COLUMN_NAME, (Object)field.getName());
            item.set(LIST_COLUMN_DISPLAY, (Object)field.getDisplayName());
            item.set(LIST_COLUMN_BOOST, (Object)new Float(field.getBoost()).toString());
            item.set(LIST_COLUMN_INDEX, (Object)field.getIndexed());
            item.set(LIST_COLUMN_EXCERPT_HIDE, (Object)field.isInExcerpt());
            item.set(LIST_COLUMN_STORE_HIDE, (Object)field.isStored());
            item.set(LIST_COLUMN_DEFAULT, (Object)defaultValue);
            result.add(item);
        }
        return result;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_EDIT_NAME_0"));
        editCol.setHelpText(Messages.get().container("GUI_LIST_FIELD_COL_EDIT_NAME_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editAction.setName(Messages.get().container("GUI_LIST_FIELD_ACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_COL_EDIT_NAME_HELP_0"));
        editAction.setIconPath(LIST_ICON_FIELD_EDIT);
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition mappingCol = new CmsListColumnDefinition(LIST_COLUMN_MAPPING);
        mappingCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_MAPPING_0"));
        mappingCol.setHelpText(Messages.get().container("GUI_LIST_FIELD_COL_MAPPING_HELP_0"));
        mappingCol.setWidth("20");
        mappingCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        mappingCol.setSorteable(false);
        CmsListDirectAction mappingAction = new CmsListDirectAction(LIST_ACTION_MAPPING);
        mappingAction.setName(Messages.get().container("GUI_LIST_FIELD_ACTION_MAPPING_0"));
        mappingAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_COL_MAPPING_HELP_0"));
        mappingAction.setIconPath("list/add.png");
        mappingCol.addDirectAction((I_CmsListDirectAction)mappingAction);
        metadata.addColumn(mappingCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        nameCol.setSorteable(true);
        nameCol.setWidth("45%");
        CmsListDefaultAction overviewAction = new CmsListDefaultAction(LIST_ACTION_OVERVIEW_FIELD);
        overviewAction.setName(Messages.get().container("GUI_LIST_FIELD_COL_OVERVIEW_NAME_0"));
        overviewAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_COL_OVERVIEW_NAME_HELP_0"));
        nameCol.addDefaultAction(overviewAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition displayCol = new CmsListColumnDefinition(LIST_COLUMN_DISPLAY);
        displayCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        displayCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_DISPLAY_0"));
        displayCol.setWidth("35%");
        metadata.addColumn(displayCol);
        CmsListColumnDefinition storeHideCol = new CmsListColumnDefinition(LIST_COLUMN_STORE_HIDE);
        storeHideCol.setVisible(false);
        metadata.addColumn(storeHideCol);
        CmsListColumnDefinition excerptHideCol = new CmsListColumnDefinition(LIST_COLUMN_EXCERPT_HIDE);
        excerptHideCol.setVisible(false);
        metadata.addColumn(excerptHideCol);
        CmsListColumnDefinition storeCol = new CmsListColumnDefinition(LIST_COLUMN_STORE);
        storeCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        storeCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_STORE_0"));
        CmsListDirectAction storeTrueAction = new CmsListDirectAction(LIST_ACTION_STORE_TRUE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(CmsFieldsList.LIST_COLUMN_STORE_HIDE);
                }
                return super.isVisible();
            }
        };
        storeTrueAction.setName(Messages.get().container("GUI_LIST_FIELD_ACTION_TRUE_NAME_0"));
        storeTrueAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_ACTION_TRUE_HELP_0"));
        storeTrueAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELD_ACTION_TRUE_CONF_0"));
        storeTrueAction.setIconPath(ICON_TRUE);
        CmsListDirectAction storeFalseAction = new CmsListDirectAction(LIST_ACTION_STORE_FALSE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(CmsFieldsList.LIST_COLUMN_STORE_HIDE) == false;
                }
                return super.isVisible();
            }
        };
        storeFalseAction.setName(Messages.get().container("GUI_LIST_FIELD_ACTION_FALSE_NAME_0"));
        storeFalseAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_ACTION_FALSE_HELP_0"));
        storeFalseAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELD_ACTION_FALSE_CONF_0"));
        storeFalseAction.setIconPath(ICON_FALSE);
        storeCol.addDirectAction((I_CmsListDirectAction)storeTrueAction);
        storeCol.addDirectAction((I_CmsListDirectAction)storeFalseAction);
        metadata.addColumn(storeCol);
        CmsListColumnDefinition excerptCol = new CmsListColumnDefinition(LIST_COLUMN_EXCERPT);
        excerptCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        excerptCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_EXCERPT_0"));
        CmsListDirectAction excerptTrueAction = new CmsListDirectAction(LIST_ACTION_EXCERPT_TRUE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(CmsFieldsList.LIST_COLUMN_EXCERPT_HIDE);
                }
                return super.isVisible();
            }
        };
        excerptTrueAction.setName(Messages.get().container("GUI_LIST_FIELD_ACTION_TRUE_NAME_0"));
        excerptTrueAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_ACTION_TRUE_HELP_0"));
        excerptTrueAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELD_ACTION_TRUE_CONF_0"));
        excerptTrueAction.setIconPath(ICON_TRUE);
        CmsListDirectAction excerptFalseAction = new CmsListDirectAction(LIST_ACTION_EXCERPT_FALSE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(CmsFieldsList.LIST_COLUMN_EXCERPT_HIDE) == false;
                }
                return super.isVisible();
            }
        };
        excerptFalseAction.setName(Messages.get().container("GUI_LIST_FIELD_ACTION_FALSE_NAME_0"));
        excerptFalseAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_ACTION_FALSE_HELP_0"));
        excerptFalseAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELD_ACTION_FALSE_CONF_0"));
        excerptFalseAction.setIconPath(ICON_FALSE);
        excerptCol.addDirectAction((I_CmsListDirectAction)excerptTrueAction);
        excerptCol.addDirectAction((I_CmsListDirectAction)excerptFalseAction);
        metadata.addColumn(excerptCol);
        CmsListColumnDefinition indexCol = new CmsListColumnDefinition(LIST_COLUMN_INDEX);
        indexCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        indexCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_INDEX_0"));
        indexCol.setWidth("10%");
        metadata.addColumn(indexCol);
        CmsListColumnDefinition boostCol = new CmsListColumnDefinition(LIST_COLUMN_BOOST);
        boostCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        boostCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_BOOST_0"));
        boostCol.setWidth("5%");
        metadata.addColumn(boostCol);
        CmsListColumnDefinition defaultCol = new CmsListColumnDefinition(LIST_COLUMN_DEFAULT);
        defaultCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        defaultCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_DEFAULT_0"));
        defaultCol.setWidth("5%");
        metadata.addColumn(defaultCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails configDetails = new CmsListItemDetails(LIST_DETAIL_FIELD);
        configDetails.setAtColumn(LIST_COLUMN_NAME);
        configDetails.setVisible(false);
        configDetails.setShowActionName(Messages.get().container("GUI_LIST_FIELD_DETAIL_MAPPINGS_SHOW_0"));
        configDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_FIELD_DETAIL_MAPPINGS_SHOW_HELP_0"));
        configDetails.setHideActionName(Messages.get().container("GUI_LIST_FIELD_DETAIL_MAPPINGS_HIDE_0"));
        configDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_FIELD_DETAIL_MAPPINGS_HIDE_HELP_0"));
        configDetails.setName(Messages.get().container("GUI_LIST_FIELD_DETAIL_MAPPINGS_NAME_0"));
        configDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_FIELD_DETAIL_MAPPINGS_NAME_0")));
        metadata.addItemDetails(configDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETEFIELD);
        deleteMultiAction.setName(Messages.get().container("GUI_LIST_FIELD_MACTION_DELETEFIELD_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_MACTION_DELETEFIELD_NAME_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELD_MACTION_DELETEFIELD_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getSearchManager().getFieldConfiguration(this.getParamFieldconfiguration()).getFields();
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private boolean checkWriteConfiguration(List fields) {
        if (fields == null) {
            return false;
        }
        Iterator itFields = fields.iterator();
        while (itFields.hasNext()) {
            CmsSearchField curField = (CmsSearchField)itFields.next();
            if (!curField.getMappings().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void fillDetailField(CmsListItem item, String detailId) {
        StringBuffer html = new StringBuffer();
        String idxFieldName = (String)item.get(LIST_COLUMN_NAME);
        List fields = OpenCms.getSearchManager().getFieldConfiguration(this.m_paramFieldconfiguration).getFields();
        Iterator itFields = fields.iterator();
        CmsSearchField idxField = null;
        while (itFields.hasNext()) {
            CmsSearchField curField = (CmsSearchField)itFields.next();
            if (!curField.getName().equals(idxFieldName)) continue;
            idxField = curField;
        }
        if (idxField != null) {
            html.append("<ul>\n");
            Iterator itMappings = idxField.getMappings().iterator();
            while (itMappings.hasNext()) {
                CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)itMappings.next();
                html.append("  <li>\n").append("    ");
                html.append(mapping.getType().toString());
                if (CmsStringUtil.isNotEmpty((String)mapping.getParam())) {
                    html.append("=").append(mapping.getParam()).append("\n");
                }
                html.append("  </li>");
            }
            html.append("</ul>\n");
        }
        item.set(detailId, (Object)html.toString());
    }

    private List getFields() {
        ArrayList result;
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsSearchFieldConfiguration fieldConfig = manager.getFieldConfiguration(this.getParamFieldconfiguration());
        if (fieldConfig != null) {
            result = fieldConfig.getFields();
        } else {
            result = new ArrayList(0);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"fieldconfiguration"));
            }
        }
        return result;
    }
}

