/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsSearchFieldConfigurationList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DELETE = "ade";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_FIELD = "af";
    public static final String LIST_ACTION_OVERVIEW_FIELDCONFIGURATION = "aofc";
    public static final String LIST_COLUMN_DELETE = "cde";
    public static final String LIST_COLUMN_DESCRIPTION = "cd";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_FIELD = "cf";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_DETAIL_FIELDCONFIGURATION = "df";
    public static final String LIST_ID = "lsfc";
    public static final String LIST_MACTION_DELETECONFIGURATION = "mad";
    protected static final String LIST_ICON_FIELDCONFIGURATION_EDIT = "tools/searchindex/icons/small/fieldconfiguration-edit.png";
    private static final Log LOG = CmsLog.getLog((Object)CmsSearchFieldConfigurationList.class);

    public CmsSearchFieldConfigurationList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_FIELDCONFIGURATIONS_NAME_0"));
    }

    public CmsSearchFieldConfigurationList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsSearchFieldConfigurationList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public CmsSearchFieldConfigurationList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        if (this.getParamListAction().equals(LIST_MACTION_DELETECONFIGURATION)) {
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                CmsSearchFieldConfiguration fieldconfig = searchManager.getFieldConfiguration((String)listItem.get(LIST_COLUMN_NAME));
                searchManager.removeSearchFieldConfiguration(fieldconfig);
            }
            this.refreshList();
            this.writeConfiguration(false);
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        String fieldConfiguration = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        String action = this.getParamListAction();
        params.put("fieldconfiguration", fieldConfiguration);
        params.put("action", "initial");
        params.put("style", "new");
        if (action.equals(LIST_ACTION_EDIT)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/edit", params);
        } else if (action.equals(LIST_ACTION_FIELD)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/newfield", params);
        } else if (action.equals(LIST_ACTION_DELETE)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/delete", params);
        } else if (action.equals(LIST_ACTION_OVERVIEW_FIELDCONFIGURATION)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration", params);
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        List items = this.getList().getAllContent();
        Iterator itItems = items.iterator();
        while (itItems.hasNext()) {
            CmsListItem item = (CmsListItem)itItems.next();
            if (!detailId.equals(LIST_DETAIL_FIELDCONFIGURATION)) continue;
            this.fillDetailFieldConfiguration(item, detailId);
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        CmsSearchManager manager = OpenCms.getSearchManager();
        LinkedList configs = new LinkedList(manager.getFieldConfigurations());
        Iterator itConfigs = configs.iterator();
        while (itConfigs.hasNext()) {
            try {
                CmsSearchFieldConfiguration config = (CmsSearchFieldConfiguration)itConfigs.next();
                CmsListItem item = this.getList().newItem(config.getName());
                item.set(LIST_COLUMN_NAME, (Object)config.getName());
                item.set(LIST_COLUMN_DESCRIPTION, (Object)config.getDescription());
                result.add(item);
            }
            catch (Throwable g) {
                CmsMessageContainer msg = Messages.get().container("LOG_ERR_LIST_ITEM_SKIPPED_2", (Object)this.getList().getName().key(this.getLocale()), (Object)"Name");
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)msg.key(this.getLocale()));
            }
        }
        return result;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_0"));
        editCol.setHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_HELP_0"));
        editCol.setWidth("5");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editAction.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_ACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_HELP_0"));
        editAction.setIconPath(LIST_ICON_FIELDCONFIGURATION_EDIT);
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition fieldCol = new CmsListColumnDefinition(LIST_COLUMN_FIELD);
        fieldCol.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_0"));
        fieldCol.setHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_HELP_0"));
        fieldCol.setWidth("5");
        fieldCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        fieldCol.setSorteable(false);
        CmsListDirectAction fieldAction = new CmsListDirectAction(LIST_ACTION_FIELD);
        fieldAction.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_ACTION_FIELD_NAME_0"));
        fieldAction.setHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_HELP_0"));
        fieldAction.setIconPath("list/add.png");
        fieldCol.addDirectAction((I_CmsListDirectAction)fieldAction);
        metadata.addColumn(fieldCol);
        CmsListColumnDefinition deleteCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        deleteCol.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_DELETE_NAME_0"));
        deleteCol.setHelpText(Messages.get().container("GUI_GROUPS_FIELDCONFIGURATION_TOOL_DELETE_HELP_0"));
        deleteCol.setWidth("10");
        deleteCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        deleteCol.setSorteable(false);
        CmsListDirectAction deleteAction = new CmsListDirectAction(LIST_ACTION_DELETE);
        deleteAction.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_ACTION_DELETE_NAME_0"));
        deleteAction.setHelpText(Messages.get().container("GUI_GROUPS_FIELDCONFIGURATION_TOOL_DELETE_HELP_0"));
        deleteAction.setIconPath("list/delete.png");
        deleteCol.addDirectAction((I_CmsListDirectAction)deleteAction);
        metadata.addColumn(deleteCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        nameCol.setWidth("50%");
        CmsListDefaultAction defEditAction = new CmsListDefaultAction(LIST_ACTION_OVERVIEW_FIELDCONFIGURATION);
        defEditAction.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_OVERVIEW_NAME_0"));
        defEditAction.setHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_OVERVIEW_NAME_HELP_0"));
        nameCol.addDefaultAction(defEditAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition descriptionCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descriptionCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        descriptionCol.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_COL_DESCRIPTION_0"));
        descriptionCol.setWidth("50%");
        metadata.addColumn(descriptionCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails configDetails = new CmsListItemDetails(LIST_DETAIL_FIELDCONFIGURATION);
        configDetails.setAtColumn(LIST_COLUMN_NAME);
        configDetails.setVisible(false);
        configDetails.setShowActionName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_SHOW_0"));
        configDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_SHOW_HELP_0"));
        configDetails.setHideActionName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_HIDE_0"));
        configDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_HIDE_HELP_0"));
        configDetails.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_NAME_0"));
        configDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_NAME_0")));
        metadata.addItemDetails(configDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETECONFIGURATION);
        deleteMultiAction.setName(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_NAME_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private void fillDetailFieldConfiguration(CmsListItem item, String detailId) {
        StringBuffer html = new StringBuffer();
        String idxConfigName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchFieldConfiguration idxFieldConfiguration = OpenCms.getSearchManager().getFieldConfiguration(idxConfigName);
        List fields = idxFieldConfiguration.getFields();
        html.append("<ul>\n");
        Iterator itFields = fields.iterator();
        while (itFields.hasNext()) {
            CmsSearchField field = (CmsSearchField)itFields.next();
            String fieldName = field.getName();
            boolean fieldStore = field.isStored();
            String fieldIndex = field.getIndexed();
            boolean fieldExcerpt = field.isInExcerpt();
            float fieldBoost = field.getBoost();
            String fieldDefault = field.getDefaultValue();
            html.append("  <li>\n").append("    ");
            html.append("name=").append(fieldName);
            if (fieldStore) {
                html.append(", ").append("store=").append(fieldStore);
            }
            if (!fieldIndex.equals("false")) {
                html.append(", ").append("index=").append(fieldIndex);
            }
            if (fieldExcerpt) {
                html.append(", ").append("excerpt=").append(fieldExcerpt);
            }
            if (fieldBoost != 1.0f) {
                html.append(", ").append("boost=").append(fieldBoost);
            }
            if (fieldDefault != null) {
                html.append(", ").append("default=").append(field.getDefaultValue());
            }
            html.append("\n").append("    <ul>\n");
            Iterator itMappings = field.getMappings().iterator();
            while (itMappings.hasNext()) {
                CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)itMappings.next();
                html.append("  <li>\n").append("    ");
                html.append(mapping.getType().toString());
                if (CmsStringUtil.isNotEmpty((String)mapping.getParam())) {
                    html.append("=").append(mapping.getParam()).append("\n");
                }
                html.append("  </li>");
            }
            html.append("    </ul>\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }
}

