/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsSearchIndexList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_INDEXSOURCES = "ais";
    public static final String LIST_ACTION_REBUILD = "ar";
    public static final String LIST_ACTION_SEARCH = "as";
    public static final String LIST_ACTION_SEARCHINDEX_OVERVIEW = "asio";
    public static final String LIST_COLUMN_CONFIGURATION = "cc";
    public static final String LIST_COLUMN_DELETE = "cad";
    public static final String LIST_COLUMN_EDIT = "cae";
    public static final String LIST_COLUMN_INDEXSOURCES = "cis";
    public static final String LIST_COLUMN_LOCALE = "cl";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_PROJECT = "cp";
    public static final String LIST_COLUMN_REBUILD = "car";
    public static final String LIST_COLUMN_REBUILDMODE = "cr";
    public static final String LIST_COLUMN_SEARCH = "cas";
    public static final String LIST_DETAIL_FIELDCONFIGURATION = "df";
    public static final String LIST_DETAIL_INDEXSOURCE = "di";
    public static final String LIST_ID = "lssi";
    public static final String LIST_MACTION_DELETE = "mad";
    public static final String LIST_MACTION_REBUILD = "mar";
    protected static final String LIST_ICON_INDEX = "tools/searchindex/icons/small/searchindex.png";
    protected static final String LIST_ICON_INDEXSOURCE = "tools/searchindex/icons/small/indexsource.png";
    protected static final String LIST_ICON_REBUILD_MULTI = "tools/searchindex/icons/small/multi-rebuild.png";
    protected static final String LIST_ICON_REBUILD_SINGLE = "tools/searchindex/icons/small/rebuild.png";
    protected static final String LIST_ICON_SEARCH = "buttons/preview.png";

    public CmsSearchIndexList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_SEARCHINDEX_NAME_0"));
    }

    public CmsSearchIndexList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsSearchIndexList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public CmsSearchIndexList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() throws IOException, ServletException, CmsRuntimeException {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            ArrayList<String> removedItems = new ArrayList<String>();
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                searchManager.removeSearchIndex(searchManager.getIndex((String)listItem.get(LIST_COLUMN_NAME)));
                removedItems.add(listItem.getId());
            }
            this.writeConfiguration(false);
        } else if (this.getParamListAction().equals(LIST_MACTION_REBUILD)) {
            StringBuffer items = new StringBuffer();
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                items.append(listItem.getId());
                if (!itItems.hasNext()) continue;
                items.append(',');
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("indexes", items.toString());
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/singleindex/rebuildreport", params);
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        String index = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        String action = this.getParamListAction();
        if (action.equals(LIST_ACTION_DELETE)) {
            searchManager.removeSearchIndex(searchManager.getIndex(index));
            this.writeConfiguration(false);
        } else if (action.equals(LIST_ACTION_REBUILD)) {
            params.put("indexes", index);
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/singleindex/rebuildreport", params);
        } else if (action.equals(LIST_ACTION_SEARCH)) {
            params.put("action", "initial");
            params.put("indexes", index);
            params.put("style", "new");
            params.put("indexname", index);
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/singleindex/search", params);
        } else if (action.equals(LIST_ACTION_EDIT)) {
            params.put("style", "new");
            params.put("indexname", index);
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/singleindex/edit", params);
        } else if (action.equals(LIST_ACTION_SEARCHINDEX_OVERVIEW)) {
            params.put("action", "initial");
            params.put("style", "new");
            params.put("indexname", index);
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/singleindex", params);
        } else if (action.equals(LIST_ACTION_INDEXSOURCES)) {
            params.put("action", "initial");
            params.put("style", "new");
            params.put("indexname", index);
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/singleindex/indexsources", params);
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        List items = this.getList().getAllContent();
        Iterator itItems = items.iterator();
        while (itItems.hasNext()) {
            CmsListItem item = (CmsListItem)itItems.next();
            if (detailId.equals(LIST_DETAIL_INDEXSOURCE)) {
                this.fillDetailIndexSource(item, detailId);
                continue;
            }
            if (!detailId.equals(LIST_DETAIL_FIELDCONFIGURATION)) continue;
            this.fillDetailFieldConfiguration(item, detailId);
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List indexes = this.searchIndexes();
        Iterator itIndexes = indexes.iterator();
        while (itIndexes.hasNext()) {
            CmsSearchIndex index = (CmsSearchIndex)itIndexes.next();
            CmsListItem item = this.getList().newItem(index.getName());
            item.set(LIST_COLUMN_NAME, (Object)index.getName());
            item.set(LIST_COLUMN_CONFIGURATION, (Object)index.getFieldConfiguration().getName());
            item.set(LIST_COLUMN_REBUILDMODE, (Object)index.getRebuildMode());
            item.set(LIST_COLUMN_PROJECT, (Object)index.getProject());
            item.set(LIST_COLUMN_LOCALE, (Object)index.getLocale().toString());
            result.add(item);
        }
        return result;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_EDIT_NAME_0"));
        editCol.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_EDIT_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_EDIT_HELP_0"));
        editAction.setIconPath(LIST_ICON_INDEX);
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition sourceCol = new CmsListColumnDefinition(LIST_COLUMN_INDEXSOURCES);
        sourceCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_0"));
        sourceCol.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_HELP_0"));
        sourceCol.setWidth("20");
        sourceCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        sourceCol.setSorteable(false);
        CmsListDirectAction sourceAction = new CmsListDirectAction(LIST_ACTION_INDEXSOURCES);
        sourceAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_INDEXSOURCES_NAME_0"));
        sourceAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_HELP_0"));
        sourceAction.setIconPath(LIST_ICON_INDEXSOURCE);
        sourceCol.addDirectAction((I_CmsListDirectAction)sourceAction);
        metadata.addColumn(sourceCol);
        CmsListColumnDefinition deleteCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        deleteCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_DELETE_NAME_0"));
        deleteCol.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_DELETE_HELP_0"));
        deleteCol.setWidth("20");
        deleteCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        deleteCol.setSorteable(false);
        CmsListDirectAction deleteAction = new CmsListDirectAction(LIST_ACTION_DELETE);
        deleteAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_DELETE_NAME_0"));
        deleteAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_DELETE_HELP_0"));
        deleteAction.setConfirmationMessage(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_DELETE_CONF_0"));
        deleteAction.setIconPath("list/delete.png");
        deleteCol.addDirectAction((I_CmsListDirectAction)deleteAction);
        metadata.addColumn(deleteCol);
        CmsListColumnDefinition rebuildCol = new CmsListColumnDefinition(LIST_COLUMN_REBUILD);
        rebuildCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_REBUILD_NAME_0"));
        rebuildCol.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_REBUILD_HELP_0"));
        rebuildCol.setWidth("20");
        rebuildCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        rebuildCol.setSorteable(false);
        CmsListDirectAction rebuildAction = new CmsListDirectAction(LIST_ACTION_REBUILD);
        rebuildAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_REBUILD_NAME_0"));
        rebuildAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_REBUILD_HELP_0"));
        rebuildAction.setConfirmationMessage(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_REBUILD_CONF_0"));
        rebuildAction.setIconPath(LIST_ICON_REBUILD_SINGLE);
        rebuildCol.addDirectAction((I_CmsListDirectAction)rebuildAction);
        metadata.addColumn(rebuildCol);
        CmsListColumnDefinition searchCol = new CmsListColumnDefinition(LIST_COLUMN_SEARCH);
        searchCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_SEARCH_NAME_0"));
        searchCol.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_SEARCH_HELP_0"));
        searchCol.setWidth("20");
        searchCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        searchCol.setSorteable(false);
        CmsListDirectAction searchAction = new CmsListDirectAction(LIST_ACTION_SEARCH);
        searchAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_SEARCH_NAME_0"));
        searchAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_SEARCH_HELP_0"));
        searchAction.setIconPath(LIST_ICON_SEARCH);
        searchCol.addDirectAction((I_CmsListDirectAction)searchAction);
        metadata.addColumn(searchCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        nameCol.setWidth("35%");
        CmsListDefaultAction defEditAction = new CmsListDefaultAction(LIST_ACTION_SEARCHINDEX_OVERVIEW);
        defEditAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_OVERVIEW_NAME_0"));
        defEditAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_OVERVIEW_HELP_0"));
        nameCol.addDefaultAction(defEditAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition configCol = new CmsListColumnDefinition(LIST_COLUMN_CONFIGURATION);
        configCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        configCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_CONFIGURATION_0"));
        configCol.setWidth("15%");
        metadata.addColumn(configCol);
        CmsListColumnDefinition rebuildModeCol = new CmsListColumnDefinition(LIST_COLUMN_REBUILDMODE);
        rebuildModeCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        rebuildModeCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_REBUILDMODE_0"));
        rebuildModeCol.setWidth("5%");
        metadata.addColumn(rebuildModeCol);
        CmsListColumnDefinition projectCol = new CmsListColumnDefinition(LIST_COLUMN_PROJECT);
        projectCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        projectCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_PROJECT_0"));
        projectCol.setWidth("30%");
        metadata.addColumn(projectCol);
        CmsListColumnDefinition localeCol = new CmsListColumnDefinition(LIST_COLUMN_LOCALE);
        localeCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        localeCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_LOCALE_0"));
        localeCol.setWidth("10%");
        metadata.addColumn(localeCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails indexDetails = new CmsListItemDetails(LIST_DETAIL_INDEXSOURCE);
        indexDetails.setAtColumn(LIST_COLUMN_NAME);
        indexDetails.setVisible(false);
        indexDetails.setShowActionName(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_SHOW_0"));
        indexDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_SHOW_HELP_0"));
        indexDetails.setHideActionName(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_HIDE_0"));
        indexDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_HIDE_HELP_0"));
        indexDetails.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_NAME_0"));
        indexDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_NAME_0")));
        metadata.addItemDetails(indexDetails);
        CmsListItemDetails configDetails = new CmsListItemDetails(LIST_DETAIL_FIELDCONFIGURATION);
        configDetails.setAtColumn(LIST_COLUMN_NAME);
        configDetails.setVisible(false);
        configDetails.setShowActionName(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_SHOW_0"));
        configDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_SHOW_HELP_0"));
        configDetails.setHideActionName(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_HIDE_0"));
        configDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_HIDE_HELP_0"));
        configDetails.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_NAME_0"));
        configDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_NAME_0")));
        metadata.addItemDetails(configDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteMultiAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_DELETE_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_DELETE_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_DELETE_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
        CmsListMultiAction rebuildMultiAction = new CmsListMultiAction(LIST_MACTION_REBUILD);
        rebuildMultiAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_REBUILD_NAME_0"));
        rebuildMultiAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_REBUILD_HELP_0"));
        rebuildMultiAction.setConfirmationMessage(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_REBUILD_CONF_0"));
        rebuildMultiAction.setIconPath(LIST_ICON_REBUILD_MULTI);
        metadata.addMultiAction(rebuildMultiAction);
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private void fillDetailFieldConfiguration(CmsListItem item, String detailId) {
        StringBuffer html = new StringBuffer();
        String idxName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchIndex idx = OpenCms.getSearchManager().getIndex(idxName);
        CmsSearchFieldConfiguration idxFieldConfiguration = idx.getFieldConfiguration();
        List fields = idxFieldConfiguration.getFields();
        html.append("<ul>\n");
        html.append("  <li>\n").append("    ").append("name      : ").append(idxFieldConfiguration.getName()).append("\n");
        html.append("  </li>");
        html.append("  <li>\n").append("    ").append("fields : ").append("\n");
        html.append("    <ul>\n");
        Iterator itFields = fields.iterator();
        while (itFields.hasNext()) {
            CmsSearchField field = (CmsSearchField)itFields.next();
            String fieldName = field.getName();
            boolean fieldStore = field.isStored();
            String fieldIndex = field.getIndexed();
            boolean fieldExcerpt = field.isInExcerpt();
            float fieldBoost = field.getBoost();
            String fieldDefault = field.getDefaultValue();
            html.append("  <li>\n").append("    ");
            html.append("name=").append(fieldName);
            if (fieldStore) {
                html.append(", ").append("store=").append(fieldStore);
            }
            if (!fieldIndex.equals("false")) {
                html.append(", ").append("index=").append(fieldIndex);
            }
            if (fieldExcerpt) {
                html.append(", ").append("excerpt=").append(fieldExcerpt);
            }
            if (fieldBoost != 1.0f) {
                html.append(", ").append("boost=").append(fieldBoost);
            }
            if (fieldDefault != null) {
                html.append(", ").append("default=").append(field.getDefaultValue());
            }
            html.append("\n").append("    <ul>\n");
            Iterator itMappings = field.getMappings().iterator();
            while (itMappings.hasNext()) {
                CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)itMappings.next();
                html.append("  <li>\n").append("    ");
                html.append(mapping.getType().toString());
                if (CmsStringUtil.isNotEmpty((String)mapping.getParam())) {
                    html.append("=").append(mapping.getParam()).append("\n");
                }
                html.append("  </li>");
            }
            html.append("    </ul>\n");
            html.append("  </li>");
        }
        html.append("    </ul>\n");
        html.append("  </li>");
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private void fillDetailIndexSource(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String idxName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchIndex idx = OpenCms.getSearchManager().getIndex(idxName);
        LinkedList<CmsSearchIndexSource> idxSources = new LinkedList<CmsSearchIndexSource>();
        Iterator itIdxSrcNames = idx.getSourceNames().iterator();
        while (itIdxSrcNames.hasNext()) {
            idxSources.add(searchManager.getIndexSource((String)itIdxSrcNames.next()));
        }
        Iterator itIdxSources = idxSources.iterator();
        html.append("<ul>\n");
        while (itIdxSources.hasNext()) {
            CmsSearchIndexSource idxSource = (CmsSearchIndexSource)itIdxSources.next();
            html.append("  <li>\n").append("    ").append("name      : ").append(idxSource.getName()).append("\n");
            html.append("  </li>");
            html.append("  <li>\n").append("    ").append("indexer   : ").append(idxSource.getIndexerClassName()).append("\n");
            html.append("  </li>");
            html.append("  <li>\n").append("    ").append("resources : ").append("\n");
            html.append("    <ul>\n");
            List resources = idxSource.getResourcesNames();
            Iterator itResources = resources.iterator();
            while (itResources.hasNext()) {
                html.append("    <li>\n").append("      ").append((String)itResources.next()).append("\n");
                html.append("    </li>\n");
            }
            html.append("    </ul>\n");
            html.append("  </li>");
            html.append("  <li>\n").append("    ").append("doctypes : ").append("\n");
            html.append("    <ul>\n");
            resources = idxSource.getDocumentTypes();
            itResources = resources.iterator();
            while (itResources.hasNext()) {
                html.append("    <li>\n").append("      ").append((String)itResources.next()).append("\n");
                html.append("    </li>\n");
            }
            html.append("    </ul>\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private List searchIndexes() {
        CmsSearchManager manager = OpenCms.getSearchManager();
        return manager.getSearchIndexes();
    }
}

