/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.searchindex.A_CmsEmbeddedListDialog;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsSearchIndexSourceAddList
extends A_CmsEmbeddedListDialog {
    public static final String LIST_ACTION_ADDSOURCE = "a";
    public static final String LIST_ACTION_NONE = "n";
    public static final String LIST_COLUMN_ADDSOURCE = "cas";
    public static final String LIST_COLUMN_ADDSOURCE2 = "cas2";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_INDEXER = "ca";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_DETAIL_DOCTYPES = "dd";
    public static final String LIST_DETAIL_RESOURCES = "dr";
    public static final String LIST_ID = "lssisa";
    public static final String LIST_MACTION_ADDSOURCE = "maa";
    private static final Log LOG = CmsLog.getLog((Object)CmsSearchIndexSourceAddList.class);
    private String m_paramIndexName;

    public CmsSearchIndexSourceAddList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_INDEXSOURCES_AVAIL_NAME_0"));
    }

    public CmsSearchIndexSourceAddList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsSearchIndexSourceAddList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public CmsSearchIndexSourceAddList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        CmsListItem item = this.getSelectedItem();
        if (this.getParamListAction().equals(LIST_MACTION_ADDSOURCE)) {
            block4: {
                Iterator itItems = this.getSelectedItems().iterator();
                CmsSearchIndex idx = searchManager.getIndex(this.getParamIndexName());
                while (itItems.hasNext()) {
                    item = (CmsListItem)itItems.next();
                    String indexSource = (String)item.get(LIST_COLUMN_NAME);
                    idx.addSourceName(indexSource);
                }
                try {
                    idx.initialize();
                }
                catch (CmsSearchException e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.writeConfiguration(false);
            this.refreshList();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        CmsListItem item = this.getSelectedItem();
        String indexsourceName = (String)item.get(LIST_COLUMN_NAME);
        String action = this.getParamListAction();
        if (action.equals(LIST_ACTION_ADDSOURCE) || action.equals(LIST_COLUMN_ADDSOURCE2)) {
            block5: {
                CmsSearchIndex idx = searchManager.getIndex(this.getParamIndexName());
                idx.addSourceName(indexsourceName);
                try {
                    idx.initialize();
                }
                catch (CmsSearchException e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.refreshList();
            this.writeConfiguration(false);
        } else if (action.equals("aois")) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("indexsource", indexsourceName);
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/indexsources/indexsource", params);
        }
    }

    public String getParamIndexName() {
        return this.m_paramIndexName;
    }

    public void setParamIndexName(String paramSearchIndex) {
        this.m_paramIndexName = paramSearchIndex;
    }

    protected void fillDetails(String detailId) {
        CmsListItem item;
        List items = this.getList().getAllContent();
        Iterator itItems = items.iterator();
        if (detailId.equals(LIST_DETAIL_DOCTYPES)) {
            while (itItems.hasNext()) {
                item = (CmsListItem)itItems.next();
                this.fillDetailDocTypes(item, detailId);
            }
        }
        if (detailId.equals(LIST_DETAIL_RESOURCES)) {
            while (itItems.hasNext()) {
                item = (CmsListItem)itItems.next();
                this.fillDetailResources(item, detailId);
            }
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        LinkedList allSources = new LinkedList(OpenCms.getSearchManager().getSearchIndexSources().values());
        allSources.removeAll(this.searchIndexSources());
        Iterator itSources = allSources.iterator();
        while (itSources.hasNext()) {
            CmsSearchIndexSource source = (CmsSearchIndexSource)itSources.next();
            CmsListItem item = this.getList().newItem(source.getName());
            item.set(LIST_COLUMN_NAME, (Object)source.getName());
            item.set(LIST_COLUMN_INDEXER, (Object)source.getIndexer().getClass().getName());
            result.add(item);
        }
        return result;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        editCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_0"));
        editCol.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_HELP_0"));
        editCol.setWidth("5");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_NONE);
        editAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_HELP_0"));
        editAction.setIconPath("tools/searchindex/icons/small/indexsource.png");
        editAction.setEnabled(false);
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition addCol = new CmsListColumnDefinition(LIST_COLUMN_ADDSOURCE);
        addCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_0"));
        addCol.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_HELP_0"));
        addCol.setWidth("5");
        addCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        addCol.setSorteable(false);
        CmsListDirectAction addAction = new CmsListDirectAction(LIST_ACTION_ADDSOURCE);
        addAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_0"));
        addAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_ADDSOURCE_NAME_0"));
        addAction.setIconPath("list/add.png");
        addCol.addDirectAction((I_CmsListDirectAction)addAction);
        metadata.addColumn(addCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        nameCol.setWidth("55%");
        CmsListDefaultAction addAction2 = new CmsListDefaultAction(LIST_COLUMN_ADDSOURCE2);
        addAction2.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_0"));
        addAction2.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_ADDSOURCE_NAME_0"));
        nameCol.addDefaultAction(addAction2);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition analyzerCol = new CmsListColumnDefinition(LIST_COLUMN_INDEXER);
        analyzerCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        analyzerCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_INDEXER_0"));
        analyzerCol.setWidth("30%");
        metadata.addColumn(analyzerCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails doctypeDetails = new CmsListItemDetails(LIST_DETAIL_DOCTYPES);
        doctypeDetails.setAtColumn(LIST_COLUMN_NAME);
        doctypeDetails.setVisible(false);
        doctypeDetails.setShowActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0"));
        doctypeDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_HELP_0"));
        doctypeDetails.setHideActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0"));
        doctypeDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_HELP_0"));
        doctypeDetails.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0"));
        doctypeDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0")));
        metadata.addItemDetails(doctypeDetails);
        CmsListItemDetails resourceDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourceDetails.setAtColumn(LIST_COLUMN_NAME);
        resourceDetails.setVisible(false);
        resourceDetails.setShowActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0"));
        resourceDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_HELP_0"));
        resourceDetails.setHideActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0"));
        resourceDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_HELP_0"));
        resourceDetails.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0"));
        resourceDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0")));
        metadata.addItemDetails(resourceDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction addMultiAction = new CmsListMultiAction(LIST_MACTION_ADDSOURCE);
        addMultiAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_ADDSOURCE_NAME_0"));
        addMultiAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_MACTION_ADDSOURCE_NAME_HELP_0"));
        addMultiAction.setIconPath("list/multi_add.png");
        metadata.addMultiAction(addMultiAction);
    }

    protected void validateParamaters() throws Exception {
        if (this.getParamIndexName() == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"indexname"));
        }
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private void fillDetailDocTypes(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String idxSourceName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchIndexSource idxSource = searchManager.getIndexSource(idxSourceName);
        List docTypes = idxSource.getDocumentTypes();
        Iterator itDocTypes = docTypes.iterator();
        html.append("<ul>\n");
        while (itDocTypes.hasNext()) {
            CmsSearchDocumentType docType = searchManager.getDocumentTypeConfig(itDocTypes.next().toString());
            if (docType == null) continue;
            html.append("  <li>\n").append("  ").append(docType.getName()).append("\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private void fillDetailResources(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String idxSourceName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchIndexSource idxSource = searchManager.getIndexSource(idxSourceName);
        List resources = idxSource.getResourcesNames();
        Iterator itResources = resources.iterator();
        html.append("<ul>\n");
        while (itResources.hasNext()) {
            html.append("  <li>\n").append("  ").append(itResources.next().toString()).append("\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private List searchIndexSources() {
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsSearchIndex index = manager.getIndex(this.getParamIndexName());
        List sources = index.getSources();
        return sources;
    }
}

