/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearch;
import org.opencms.search.CmsSearchResult;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSearchResultView {
    private boolean m_exportLinks = false;
    private SortedMap m_formCache;
    private CmsJspActionElement m_jsp;
    protected CmsProject m_offlineProject;
    protected CmsProject m_onlineProject;
    private String m_searchRessourceUrl;

    public CmsSearchResultView(CmsJspActionElement action) {
        this.m_jsp = action;
        this.m_formCache = new TreeMap();
        try {
            this.m_onlineProject = this.m_jsp.getCmsObject().readProject(CmsProject.ONLINE_PROJECT_ID);
            this.m_offlineProject = this.m_jsp.getRequestContext().currentProject();
        }
        catch (CmsException e) {
            this.m_onlineProject = this.m_offlineProject;
        }
    }

    public CmsSearchResultView(PageContext pageContext, HttpServletRequest request, HttpServletResponse response) {
        this(new CmsJspActionElement(pageContext, request, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displaySearchResult(CmsSearch search) {
        ArrayList searchResult;
        StringBuffer result = new StringBuffer(800);
        Locale locale = this.m_jsp.getRequestContext().getLocale();
        CmsMessages messages = Messages.get().getBundle(locale);
        result.append("<h3>\n");
        result.append(messages.key("GUI_HELP_SEARCH_RESULT_TITLE_0"));
        result.append("\n</h1>\n");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)search.getQuery())) {
            search.setQuery("");
            searchResult = new ArrayList();
        } else {
            search.setMatchesPerPage(5);
            searchResult = search.getSearchResult();
        }
        HttpServletRequest request = this.m_jsp.getRequest();
        String action = request.getParameter("action");
        if (action != null && searchResult == null) {
            result.append("<p class=\"formerror\">\n");
            if (search.getLastException() != null) {
                result.append(messages.key("GUI_HELP_SEARCH_UNAVAILABLE_0"));
                result.append("\n<!-- ").append(search.getLastException().toString());
                result.append(" //-->\n");
            } else {
                result.append(messages.key("GUI_HELP_SEARCH_NOMATCH_1", (Object)search.getQuery()));
                result.append("\n");
            }
            result.append("</p>\n");
        } else if (action != null && searchResult.size() <= 0) {
            result.append("<p class=\"formerror\">\n");
            result.append(messages.key("GUI_HELP_SEARCH_NOMATCH_1", (Object)search.getQuery()));
            result.append("\n");
            result.append("</p>\n");
        } else if (action != null && searchResult.size() > 0) {
            result.append("<p>\n");
            result.append(messages.key("GUI_HELP_SEARCH_RESULT_START_0"));
            result.append("\n");
            result.append("</p>\n<p>\n");
            Iterator iterator = searchResult.iterator();
            try {
                if (this.m_exportLinks) {
                    this.m_jsp.getRequestContext().setCurrentProject(this.m_onlineProject);
                }
                while (iterator.hasNext()) {
                    CmsSearchResult entry = (CmsSearchResult)iterator.next();
                    result.append("\n<div class=\"searchResult\">");
                    result.append("<a class=\"navhelp\" href=\"#\" onclick=\"javascript:window.open('");
                    String path = CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_jsp.getRequestContext().getSiteRoot()) ? this.m_jsp.link(OpenCms.getSiteManager().getDefaultSite().getSiteRoot() + "/") + entry.getPath().substring(1) : this.m_jsp.link(entry.getPath());
                    result.append(path);
                    result.append("', '_blank', 'width='+screen.availWidth+', height='+ screen.availHeight+', scrollbars=yes, menubar=yes, toolbar=yes')\"");
                    result.append("\">\n");
                    String name = entry.getField("title-key");
                    if (name == null) {
                        name = entry.getPath();
                    }
                    result.append(name);
                    result.append("</a>");
                    result.append("&nbsp;(").append(entry.getScore()).append("&nbsp;%)\n");
                    result.append("<span class=\"searchExcerpt\">\n");
                    String excerptString = entry.getExcerpt();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)excerptString)) {
                        result.append(messages.key("GUI_HELP_SEARCH_EXCERPT_UNAVAILABLE_0"));
                    } else {
                        result.append(excerptString).append('\n');
                    }
                    result.append("</span>\n");
                    result.append("</div>\n");
                }
            }
            finally {
                this.m_jsp.getRequestContext().setCurrentProject(this.m_offlineProject);
            }
            result.append("</p>\n");
            if (search.getPreviousUrl() != null || search.getNextUrl() != null) {
                result.append("<p>");
                if (search.getPreviousUrl() != null) {
                    result.append("<a class=\"searchlink\" href=\"");
                    result.append(this.getSearchPageLink(this.m_jsp.link(search.getPreviousUrl() + '&' + "__locale" + "=" + this.m_jsp.getRequestContext().getLocale()), search));
                    result.append("\">");
                    result.append(messages.key("GUI_HELP_BUTTON_BACK_0"));
                    result.append(" &lt;&lt;</a>&nbsp;&nbsp;\n");
                }
                Map pageLinks = search.getPageLinks();
                Iterator i = pageLinks.keySet().iterator();
                while (i.hasNext()) {
                    int pageNumber = (Integer)i.next();
                    result.append(" ");
                    if (pageNumber != search.getSearchPage()) {
                        result.append("<a class=\"searchlink\" href=\"").append(this.getSearchPageLink(this.m_jsp.link((String)pageLinks.get(new Integer(pageNumber)) + '&' + "__locale" + "=" + this.m_jsp.getRequestContext().getLocale()), search));
                        result.append("\" target=\"_self\">").append(pageNumber).append("</a>\n");
                        continue;
                    }
                    result.append(pageNumber);
                }
                if (search.getNextUrl() != null) {
                    result.append("&nbsp;&nbsp;&nbsp;<a class=\"searchlink\" href=\"");
                    result.append(this.getSearchPageLink(this.m_jsp.link(search.getNextUrl()) + '&' + "__locale" + "=" + this.m_jsp.getRequestContext().getLocale(), search));
                    result.append("\">&gt;&gt;");
                    result.append(messages.key("GUI_HELP_BUTTON_NEXT_0"));
                    result.append("</a>\n");
                }
                result.append("</p>\n");
            }
        }
        Iterator values = this.m_formCache.values().iterator();
        while (values.hasNext()) {
            result.append(values.next());
        }
        return result.toString();
    }

    private String getSearchPageLink(String link, CmsSearch search) {
        if (this.m_searchRessourceUrl != null) {
            String pageParams = "";
            int paramIndex = link.indexOf(63);
            if (paramIndex > 0) {
                pageParams = link.substring(paramIndex);
            }
            StringBuffer formurl = new StringBuffer(this.m_searchRessourceUrl);
            if (this.m_searchRessourceUrl.indexOf(63) != -1) {
                pageParams = "&" + pageParams.substring(1);
            }
            formurl.append(pageParams).toString();
            String formname = this.toPostParameters(formurl.toString(), search);
            link = "javascript:document.forms['" + formname + "'].submit()";
        }
        return link;
    }

    public boolean isExportLinks() {
        return this.m_exportLinks;
    }

    public void setExportLinks(boolean exportLinks) {
        this.m_exportLinks = exportLinks;
    }

    public void setSearchRessourceUrl(String uri) {
        this.m_searchRessourceUrl = uri;
    }

    private String toPostParameters(String getRequestUri, CmsSearch search) {
        final class HTMLForm {
            String m_formHtml;
            String m_formName;

            HTMLForm(String formName, String formHtml) {
                this.m_formName = formName;
                this.m_formHtml = formHtml;
            }

            public String toString() {
                return this.m_formHtml;
            }
        }
        String formname = "";
        if (!this.m_formCache.containsKey(getRequestUri)) {
            StringBuffer result = new StringBuffer();
            int index = getRequestUri.indexOf(63);
            String query = "";
            String path = "";
            if (index > 0) {
                query = getRequestUri.substring(index + 1);
                path = getRequestUri.substring(0, index);
                formname = "searchform" + this.m_formCache.size();
                result.append("\n<form method=\"post\" name=\"").append(formname).append("\" action=\"");
                result.append(path).append("\">\n");
                StringTokenizer entryTokens = new StringTokenizer(query, "&", false);
                while (entryTokens.hasMoreTokens()) {
                    StringTokenizer keyValueToken = new StringTokenizer(entryTokens.nextToken(), "=", false);
                    if (keyValueToken.countTokens() != 2) continue;
                    String key = CmsEncoder.decode((String)keyValueToken.nextToken());
                    String value = CmsEncoder.decode((String)keyValueToken.nextToken());
                    if ("action".equals(key)) {
                        value = "save";
                    }
                    result.append("  <input type=\"hidden\" name=\"");
                    result.append(key).append("\" value=\"");
                    result.append(value).append("\" />\n");
                }
                List categories = search.getParameters().getCategories();
                Iterator it = categories.iterator();
                int count = 0;
                while (it.hasNext()) {
                    result.append("  <input type=\"hidden\" name=\"");
                    result.append("categories.").append(count).append("\" value=\"");
                    result.append(it.next()).append("\" />\n");
                    ++count;
                }
                List roots = search.getParameters().getRoots();
                it = roots.iterator();
                count = 0;
                while (it.hasNext()) {
                    result.append("  <input type=\"hidden\" name=\"");
                    result.append("roots.").append(count).append("\" value=\"");
                    result.append(it.next()).append("\" />\n");
                    ++count;
                }
                result.append("  <input type=\"hidden\" name=\"");
                result.append("fields").append("\" value=\"");
                result.append(CmsStringUtil.collectionAsString((Collection)search.getParameters().getFields(), (String)","));
                result.append("\" />\n");
                result.append("  <input type=\"hidden\" name=\"");
                result.append("sortfields.").append(0).append("\" value=\"");
                result.append(search.getParameters().getSortName()).append("\" />\n");
                result.append("</form>\n");
                HTMLForm form = new HTMLForm(formname, result.toString());
                this.m_formCache.put(getRequestUri, form);
                return formname;
            }
            return formname;
        }
        HTMLForm form = (HTMLForm)this.m_formCache.get(getRequestUri);
        return form.m_formName;
    }
}

