/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearch;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsMultiSelectWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.searchindex.A_CmsEditSearchIndexDialog;
import org.opencms.workplace.tools.searchindex.CmsHookListSearchCategory;
import org.opencms.workplace.tools.searchindex.CmsSearchResultView;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsSearchWidgetDialog
extends A_CmsEditSearchIndexDialog {
    public static final String PARAM_SEARCH_OBJECT = "searchobject";
    public static final String PARAM_SEARCH_PARAMS = "searchparams";
    protected CmsSearch m_search;
    protected CmsSearchParameters m_searchParams;

    public CmsSearchWidgetDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSearchWidgetDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionToggleElement() {
        super.actionToggleElement();
        this.commitWidgetValues();
    }

    public String dialogScriptSubmit() {
        StringBuffer html = new StringBuffer(512);
        html.append(this.submitJS());
        html.append("function submitAction(actionValue, theForm, formName) {\n");
        html.append("\tif (theForm == null) {\n");
        html.append("\t\ttheForm = document.forms[formName];\n");
        html.append("\t}\n");
        html.append("\tvar queryOK = validateQuery();\n");
        html.append("\ttheForm.framename.value = window.name;\n");
        html.append("\tif (queryOK) {\n");
        html.append("\t\tif (actionValue == 'ok') {\n");
        html.append("\t\t\tloadingOn();\n");
        html.append("\t\t\treturn queryOK;\n");
        html.append("\t\t}\n");
        html.append("\t\ttheForm.action.value = actionValue;\n");
        html.append("\t\tsubmitForm(theForm);\n");
        html.append("\t}\n");
        html.append("\treturn queryOK;\n");
        html.append("}\n");
        return html.toString();
    }

    public String getFields() {
        return CmsStringUtil.collectionAsString((Collection)this.m_searchParams.getFields(), (String)",");
    }

    public String getMaxDateCreated() {
        if (this.m_searchParams.getMaxDateCreated() == Long.MAX_VALUE) {
            return "";
        }
        return Long.toString(this.m_searchParams.getMaxDateCreated());
    }

    public String getMaxDateLastModified() {
        if (this.m_searchParams.getMaxDateLastModified() == Long.MAX_VALUE) {
            return "";
        }
        return Long.toString(this.m_searchParams.getMaxDateLastModified());
    }

    public String getMinDateCreated() {
        if (this.m_searchParams.getMinDateCreated() == Long.MIN_VALUE) {
            return "";
        }
        return Long.toString(this.m_searchParams.getMinDateCreated());
    }

    public String getMinDateLastModified() {
        if (this.m_searchParams.getMinDateLastModified() == Long.MIN_VALUE) {
            return "";
        }
        return Long.toString(this.m_searchParams.getMinDateLastModified());
    }

    public List getSearchFields() {
        CmsSearchIndex index = OpenCms.getSearchManager().getIndex(this.getParamIndexName());
        ArrayList<CmsSearchField> result = new ArrayList<CmsSearchField>();
        Iterator i = index.getFieldConfiguration().getFields().iterator();
        while (i.hasNext()) {
            CmsSearchField field = (CmsSearchField)i.next();
            if (!field.isIndexed() || !field.isDisplayed()) continue;
            result.add(field);
        }
        return result;
    }

    public void setFields(String fields) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)fields)) {
            throw new CmsIllegalStateException(org.opencms.workplace.search.Messages.get().container("ERR_VALIDATE_SEARCH_PARAMS_0"));
        }
        this.m_searchParams.setFields(CmsStringUtil.splitAsList((String)fields, (String)","));
    }

    public void setMaxDateCreated(String maxCreationDate) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)maxCreationDate) && !maxCreationDate.equals("0")) {
            this.m_searchParams.setMaxDateCreated(Long.parseLong(maxCreationDate));
        } else {
            this.m_searchParams.setMaxDateCreated(Long.MAX_VALUE);
        }
    }

    public void setMaxDateLastModified(String maxDateLastModified) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)maxDateLastModified) && !maxDateLastModified.equals("0")) {
            this.m_searchParams.setMaxDateLastModified(Long.parseLong(maxDateLastModified));
        } else {
            this.m_searchParams.setMaxDateLastModified(Long.MAX_VALUE);
        }
    }

    public void setMinDateCreated(String minCreationDate) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)minCreationDate) && !minCreationDate.equals("0")) {
            this.m_searchParams.setMinDateCreated(Long.parseLong(minCreationDate));
        } else {
            this.m_searchParams.setMinDateCreated(Long.MIN_VALUE);
        }
    }

    public void setMinDateLastModified(String minDateLastModified) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)minDateLastModified) && !minDateLastModified.equals("0")) {
            this.m_searchParams.setMinDateLastModified(Long.parseLong(minDateLastModified));
        } else {
            this.m_searchParams.setMinDateLastModified(Long.MIN_VALUE);
        }
    }

    protected boolean closeDialogOnCommit() {
        return false;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_QUERY_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 5));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_TIME_RANGES_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(6, 9));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_FIELDS_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(10, 10));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<form name=\"EDITOR\" id=\"EDITOR\" method=\"post\" action=\"").append(this.getDialogUri());
        result.append("\" class=\"nomargin\" onsubmit=\"return submitAction('").append("ok").append("', null, 'EDITOR');\">\n");
        result.append(this.dialogContentStart(null));
        result.append(this.buildDialogForm());
        result.append(this.dialogContentEnd());
        result.append(this.dialogButtonsCustom());
        result.append(this.paramsAsHidden());
        if (this.getParamFramename() == null) {
            result.append("\n<input type=\"hidden\" name=\"").append("framename").append("\" value=\"\">\n");
        }
        result.append(this.filterCategoryJS());
        result.append("</form>\n");
        String searchResults = this.createSearchResults();
        result.append(this.createCategorySearchResultHtml());
        result.append(searchResults);
        result.append(this.getWidgetHtmlEnd());
        result.append(this.normalizePreviousQueryJS());
        return result.toString();
    }

    protected void defineWidgets() {
        super.defineWidgets();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_searchParams, "index", "", PAGES[0], (I_CmsWidget)new CmsDisplayWidget(), 1, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_searchParams, "query", "", PAGES[0], (I_CmsWidget)new CmsInputWidget(), 1, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_searchParams, "sortName", "", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getSortWidgetConfiguration()), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_searchParams.getRoots(), "roots", "/", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(), 1, 10));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_searchParams.getCategories(), "categories", "", PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 6));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_searchParams, "calculateCategories", (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "minDateCreated", PAGES[0], (I_CmsWidget)new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "maxDateCreated", PAGES[0], (I_CmsWidget)new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "minDateLastModified", PAGES[0], (I_CmsWidget)new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "maxDateLastModified", PAGES[0], (I_CmsWidget)new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "fields", PAGES[0], (I_CmsWidget)new CmsMultiSelectWidget(this.getFieldList(), true)));
    }

    protected void initUserObject() {
        super.initUserObject();
        Object o = this.getDialogObject();
        if (o == null) {
            this.m_searchParams = new CmsSearchParameters();
            this.m_searchParams.setCategories((List)new CmsHookListSearchCategory(this.m_searchParams, (Collection)this.m_searchParams.getCategories()));
            this.m_search = new CmsSearch();
        } else {
            Map dialogObject = (Map)o;
            this.m_searchParams = (CmsSearchParameters)dialogObject.get(PARAM_SEARCH_PARAMS);
            if (this.m_searchParams == null) {
                this.m_searchParams = new CmsSearchParameters();
            }
            this.m_search = (CmsSearch)dialogObject.get(PARAM_SEARCH_OBJECT);
            if (this.m_search == null) {
                this.m_search = new CmsSearch();
            }
        }
        this.m_searchParams.setSearchIndex(this.m_index);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        Map dialogMap = (Map)this.getDialogObject();
        if (dialogMap != null) {
            dialogMap.put(PARAM_SEARCH_PARAMS, this.m_searchParams);
            dialogMap.put(PARAM_SEARCH_OBJECT, this.m_search);
        }
    }

    private String createCategorySearchResultHtml() {
        Map categoryMap;
        StringBuffer result = new StringBuffer();
        if (this.m_searchParams.isCalculateCategories() && (categoryMap = this.m_search.getSearchResultCategories()) != null) {
            result.append(this.dialogContentStart(null));
            result.append(result.append(this.createWidgetTableStart()));
            result.append(this.dialogBlockStart(this.key("GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_CATEGORIES_1", new Object[]{this.m_searchParams.getQuery()})));
            result.append(this.createWidgetTableStart());
            result.append("\n<p>\n");
            Iterator it = categoryMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                result.append("  ").append("<a class=\"searchcategory\" href=\"#\" onClick=\"filterCategory('");
                result.append(entry.getKey()).append("')\")>");
                result.append(entry.getKey());
                result.append("</a> : ");
                result.append(entry.getValue()).append("<br>\n");
            }
            result.append("</p>\n");
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogContentEnd());
        }
        return result.toString();
    }

    private String createSearchResults() {
        String query = this.m_searchParams.getQuery();
        StringBuffer result = new StringBuffer();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)query) && query.length() > 3) {
            String searchRoots;
            String categories;
            CmsSearchResultView resultView = new CmsSearchResultView(this.getJsp());
            resultView.setSearchRessourceUrl(this.getJsp().link("/system/workplace/views/admin/admin-main.jsp?path=/searchindex/singleindex/search&indexname=" + this.m_index.getName()));
            this.m_search.init(this.getCms());
            String page = this.getJsp().getRequest().getParameter("searchPage");
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)page)) {
                this.m_searchParams.setSearchPage(Integer.parseInt(page));
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)(categories = this.getJsp().getRequest().getParameter("searchCategories")))) {
                this.m_searchParams.setCategories(CmsStringUtil.splitAsList((String)categories, (char)','));
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)(searchRoots = this.getJsp().getRequest().getParameter("searchRoots")))) {
                this.m_searchParams.setSearchRoots(searchRoots);
            }
            this.m_search.setParameters(this.m_searchParams);
            result.append("<div style=\"padding:12px;\">\n").append(resultView.displaySearchResult(this.m_search)).append("\n</div>\n");
        }
        return result.toString();
    }

    private String filterCategoryJS() {
        StringBuffer result = new StringBuffer();
        result.append("<input name=\"dummysearchcategory\" id=\"dummysearchcategory\" type=\"hidden\" value=\"\">\n");
        result.append("<input name=\"dummysearchpage\" id=\"dummysearchpage\" type=\"hidden\" value=\"\">\n");
        result.append("<script type=\"text/javascript\">\n");
        result.append("  function filterCategory(category) {\n");
        result.append("    var searchform = document.forms['EDITOR'];\n");
        result.append("    var inputFields = searchform.elements;\n");
        result.append("    for (var i=0; i<inputFields.length; i++) {\n");
        result.append("      if(inputFields[i].name != null && inputFields[i].name.indexOf('categories') != -1) {\n");
        result.append("        inputFields[i].value='';\n");
        result.append("        inputFields[i].name='invalidsearchcategory';\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("    var categoryField = inputFields['dummysearchcategory'];\n");
        result.append("    categoryField.name = 'categories.0';\n");
        result.append("    categoryField.value = category;\n");
        result.append("    inputFields['dummysearchpage'].value = '0';\n");
        result.append("    inputFields['dummysearchpage'].name = 'searchpage.0';\n");
        result.append("    validateQuery();\n");
        result.append("    searchform.submit();\n");
        result.append("  }\n");
        result.append("</script>\n");
        return result.toString();
    }

    private List getFieldList() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            Iterator i = this.getSearchFields().iterator();
            while (i.hasNext()) {
                CmsSearchField field = (CmsSearchField)i.next();
                retVal.add(new CmsSelectWidgetOption(field.getName(), true, this.getMacroResolver().resolveMacros(field.getDisplayName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private List getSortWidgetConfiguration() {
        LinkedList<CmsSelectWidgetOption> result = new LinkedList<CmsSelectWidgetOption>();
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        result.add(new CmsSelectWidgetOption(CmsSearchParameters.SORT_NAMES[0], true, messages.key("GUI_SELECT_LABEL_SEARCH_SORT_SCORE_0")));
        result.add(new CmsSelectWidgetOption(CmsSearchParameters.SORT_NAMES[1], false, messages.key("GUI_SELECT_LABEL_SEARCH_SORT_DATE_CREATED_0")));
        result.add(new CmsSelectWidgetOption(CmsSearchParameters.SORT_NAMES[2], false, messages.key("GUI_SELECT_LABEL_SEARCH_SORT_DATE_LAST_MODIFIED_0")));
        result.add(new CmsSelectWidgetOption(CmsSearchParameters.SORT_NAMES[3], false, messages.key("GUI_SELECT_LABEL_SEARCH_SORT_TITLE_0")));
        return result;
    }

    private String normalizePreviousQueryJS() {
        StringBuffer result = new StringBuffer();
        result.append("<script type=\"text/javascript\">\n");
        result.append("  function normalizeQueryValue() {\n");
        result.append("    var searchform = document.forms['EDITOR'];\n");
        result.append("    var query = searchform.elements['query.0'].value;\n");
        result.append("    query = decodeURI(query);\n");
        result.append("    searchform.elements['query.0'].value = query;\n");
        result.append("    return true;\n");
        result.append("  }\n");
        result.append("  normalizeQueryValue();\n");
        result.append("</script>\n");
        return result.toString();
    }

    private String submitJS() {
        StringBuffer result = new StringBuffer();
        result.append("  function validateQuery() {\n");
        result.append("    var searchform = document.getElementById(\"EDITOR\");\n");
        result.append("    var query = searchform.elements['query.0'].value;\n");
        result.append("    searchform.elements['query.0'].value = query;\n");
        result.append("    return true;\n");
        result.append("  }\n");
        return result.toString();
    }
}

