/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.frontend.templateone.Messages;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.commons.CmsPropertyCustom;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsPropertyTemplateOne
extends CmsPropertyCustom
implements I_CmsDialogHandler {
    private static final String[] ALL_PROPERTIES = new String[]{"style_head_nav_showitem", "style_show_head_img", "style_head_img_uri", "style_head_img_link", "style_head_elementuri", "style_show_head_nav", "style_show_navleft", "style_navleft_element_uri", "style_side_uri", "style_main_configpath", "layout.center", "layout.right"};
    private static final String[] DEFAULT_PROPERTIES = new String[]{"Title", "Description"};
    private static final String ENABLE = "enable";
    private static final String INDIVIDUAL = "individual";
    private static final String KEY_PREFIX = "templateonedialog.";
    private static final Log LOG = CmsLog.getLog((Object)CmsPropertyTemplateOne.class);
    private static final String MODULE_PATH = "/system/modules/org.opencms.frontend.templateone/";
    private static final String PARAM_DEFAULT = "";
    private static final String PARAM_FALSE = CmsStringUtil.FALSE;
    private static final String PARAM_TRUE = CmsStringUtil.TRUE;
    private static final String TEMPLATE_ONE = "/system/modules/org.opencms.frontend.templateone/templates/main";
    private static final String VFS_PATH_CONFIGFILES = "/system/shared/templateone/";
    private static final String VFS_PATH_CONFIGFILES_CENTER = "/system/shared/templateone/center/";
    private static final String VFS_PATH_CONFIGFILES_RIGHT = "/system/shared/templateone/right/";

    public CmsPropertyTemplateOne() {
        super(null);
    }

    public CmsPropertyTemplateOne(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPropertyTemplateOne(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(new CmsJspActionElement(context, req, res));
    }

    public void actionEdit(HttpServletRequest request) throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.isEditable()) {
                this.performEditOperation(request);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String buildCheckBox(String propertyName, String propertyValue, String propertyText) {
        StringBuffer checkbox = new StringBuffer();
        checkbox.append(this.buildTableRowStart(this.key(propertyText)));
        String checked = PARAM_DEFAULT;
        if (this.getActiveProperties().containsKey(propertyName)) {
            CmsProperty currentProperty = (CmsProperty)this.getActiveProperties().get(propertyName);
            String propValue = currentProperty.getValue();
            if (propValue != null) {
                propValue = propValue.trim();
            }
            if (propertyValue.equals(propValue = CmsEncoder.escapeXml((String)propValue))) {
                checked = " checked=\"checked\"";
            }
        } else if (propertyValue.equals(PARAM_DEFAULT)) {
            checked = " checked=\"checked\"";
        }
        checkbox.append("<input type=\"checkbox\" name=\"");
        checkbox.append("valprop");
        checkbox.append(propertyName);
        checkbox.append("\" value=\"");
        checkbox.append(propertyValue);
        checkbox.append("\"");
        checkbox.append(checked);
        checkbox.append(">");
        checkbox.append(this.buildTableRowEnd());
        return checkbox.toString();
    }

    public String buildEditForm() {
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        StringBuffer result = new StringBuffer();
        boolean editable = this.isEditable();
        result.append("<table border=\"0\">\n");
        result.append("<tr>\n");
        result.append("\t<td class=\"textbold\">");
        result.append(messages.key("GUI_INPUT_PROPERTY_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold maxwidth\">");
        result.append(messages.key("GUI_LABEL_VALUE_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\" style=\"white-space: nowrap;\">");
        result.append(messages.key("GUI_USED_PROPERTY_0"));
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr><td colspan=\"3\"><span style=\"height: 6px;\"></span></td></tr>\n");
        for (int i = 0; i < DEFAULT_PROPERTIES.length; ++i) {
            result.append(this.buildPropertyEntry(DEFAULT_PROPERTIES[i], this.key(KEY_PREFIX + DEFAULT_PROPERTIES[i]), editable));
        }
        result.append(this.buildNavigationProperties(editable));
        result.append(this.buildCheckBox("style_head_nav_showitem", PARAM_TRUE, "templateonedialog.style_head_nav_showitem"));
        result.append(this.buildRadioButtons("style_show_head_img", INDIVIDUAL, "toggleHeadImageProperties", editable));
        result.append(this.buildPropertySearchEntry("style_head_img_uri", "templateonedialog.style_head_img_uri", editable, messages));
        result.append(this.buildPropertySearchEntry("style_head_img_link", "templateonedialog.style_head_img_link", editable, messages));
        result.append(this.buildPropertySearchEntry("style_head_elementuri", "templateonedialog.style_head_elementuri", editable, messages));
        result.append(this.buildRadioButtons("style_show_head_nav", ENABLE, null, editable));
        result.append(this.buildRadioButtons("style_show_navleft", ENABLE, null, editable));
        result.append(this.buildPropertySearchEntry("style_navleft_element_uri", "templateonedialog.style_navleft_element_uri", editable, messages));
        result.append(this.buildPropertySearchEntry("style_side_uri", "templateonedialog.style_side_uri", editable, messages));
        result.append(this.buildPropertySelectbox("center", "layout.center", "templateonedialog.layout.center", editable));
        result.append(this.buildPropertySelectbox("right", "layout.right", "templateonedialog.layout.right", editable));
        result.append(this.buildPropertySearchEntry("style_main_configpath", "templateonedialog.style_main_configpath", editable, messages));
        result.append("</table>");
        return result.toString();
    }

    public String buildSetFormValues() {
        StringBuffer result = new StringBuffer(1024);
        for (int i = 0; i < DEFAULT_PROPERTIES.length; ++i) {
            String curProperty = DEFAULT_PROPERTIES[i];
            String shownValue = PARAM_DEFAULT;
            try {
                shownValue = this.getCms().readPropertyObject(this.getParamResource(), curProperty, false).getValue();
            }
            catch (CmsException e) {
                e.printStackTrace();
            }
            if (CmsStringUtil.isEmpty((String)shownValue)) continue;
            result.append("\tdocument.getElementById(\"");
            result.append("valprop");
            result.append(curProperty);
            result.append("\").value = \"");
            result.append(CmsStringUtil.escapeJavaScript((String)shownValue));
            result.append("\";\n");
        }
        return result.toString();
    }

    public String getDefault(String propertydef) {
        block3: {
            try {
                String parentFolder = CmsResource.getParentFolder((String)this.getParamResource());
                CmsProperty property = this.getCms().readPropertyObject(parentFolder, propertydef, true);
                String propertyValue = property.getValue();
                if (!CmsStringUtil.isEmpty((String)propertyValue)) {
                    return property.getValue();
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return PARAM_DEFAULT;
    }

    public String getDialogHandler() {
        return "class_dialog_property";
    }

    public String getDialogUri(String resource, CmsJspActionElement jsp) {
        block7: {
            try {
                String templateOneDialog = "/system/modules/org.opencms.frontend.templateone/dialogs/property.jsp";
                boolean dialogPresent = jsp.getCmsObject().existsResource(templateOneDialog);
                CmsResource res = jsp.getCmsObject().readResource(resource, CmsResourceFilter.ALL);
                String template = jsp.getCmsObject().readPropertyObject(res, "template", true).getValue(PARAM_DEFAULT);
                if (!res.isFolder() && res.getTypeId() != CmsResourceTypeBinary.getStaticTypeId() && res.getTypeId() != CmsResourceTypePlain.getStaticTypeId() && res.getTypeId() != CmsResourceTypeImage.getStaticTypeId()) {
                    if (dialogPresent && TEMPLATE_ONE.equals(template)) {
                        return templateOneDialog;
                    }
                    if (CmsResourceTypeXmlPage.isXmlPage((CmsResource)res)) {
                        return "/system/workplace/editors/dialogs/property.jsp";
                    }
                }
                if (dialogPresent && res.isFolder() && TEMPLATE_ONE.equals(template) && !res.getRootPath().startsWith("/system")) {
                    return templateOneDialog;
                }
                String resTypeName = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
                CmsExplorerTypeSettings settings = this.getSettingsForType(resTypeName);
                if (settings.isPropertiesEnabled()) {
                    return "/system/workplace/commons/property_custom.jsp";
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return "/system/workplace/commons/property_advanced.jsp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performEditOperation(HttpServletRequest request) throws CmsException {
        boolean useTempfileProject = Boolean.valueOf(this.getParamUsetempfileproject());
        try {
            String oldValue;
            String paramValue;
            String curProperty;
            int i;
            if (useTempfileProject) {
                this.switchToTempProject();
            }
            for (i = 0; i < DEFAULT_PROPERTIES.length; ++i) {
                curProperty = DEFAULT_PROPERTIES[i];
                paramValue = request.getParameter("valprop" + curProperty);
                oldValue = request.getParameter("valhidden" + curProperty);
                this.writeProperty(curProperty, paramValue, oldValue);
            }
            for (i = 0; i < ALL_PROPERTIES.length; ++i) {
                curProperty = ALL_PROPERTIES[i];
                paramValue = request.getParameter("valprop" + curProperty);
                oldValue = request.getParameter("valhidden" + curProperty);
                this.writeProperty(curProperty, paramValue, oldValue);
            }
            String paramValue2 = request.getParameter("enablenav");
            String oldValue2 = null;
            if (Boolean.valueOf(paramValue2).booleanValue()) {
                paramValue2 = request.getParameter("navpos");
                if (!"-1".equals(paramValue2)) {
                    oldValue2 = request.getParameter("valhiddenNavPos");
                    this.writeProperty("NavPos", paramValue2, oldValue2);
                }
                paramValue2 = request.getParameter("valpropNavText");
                oldValue2 = request.getParameter("valhiddenNavText");
                this.writeProperty("NavText", paramValue2, oldValue2);
            } else {
                this.writeProperty("NavPos", null, null);
                this.writeProperty("NavText", null, null);
            }
        }
        finally {
            if (useTempfileProject) {
                this.switchToCurrentProject();
            }
        }
        return true;
    }

    private StringBuffer buildPropertyRadioEntry(String propertyName, String propertyValue, String propertyText, String JSToggleFunction, boolean editable) {
        String disabled = PARAM_DEFAULT;
        if (!editable) {
            disabled = " disabled=\"disabled\"";
        }
        StringBuffer result = new StringBuffer(256);
        String checked = PARAM_DEFAULT;
        if (this.getActiveProperties().containsKey(propertyName)) {
            CmsProperty currentProperty = (CmsProperty)this.getActiveProperties().get(propertyName);
            String propValue = currentProperty.getValue();
            if (propValue != null) {
                propValue = propValue.trim();
            }
            if (propertyValue.equals(propValue = CmsEncoder.escapeXml((String)propValue))) {
                checked = " checked=\"checked\"";
            }
        } else if (propertyValue.equals(PARAM_DEFAULT)) {
            checked = " checked=\"checked\"";
        }
        String onclick = PARAM_DEFAULT;
        if (JSToggleFunction != null) {
            onclick = "onclick=\"" + JSToggleFunction + "();\" ";
        }
        result.append("<input ");
        result.append(onclick);
        result.append("type=\"radio\" ");
        result.append("name=\"");
        result.append("valprop");
        result.append(propertyName);
        result.append("\" value=\"");
        result.append(propertyValue);
        result.append("\"");
        result.append(checked);
        result.append(disabled);
        result.append(">");
        result.append("&nbsp;");
        result.append(propertyText);
        return result;
    }

    private StringBuffer buildPropertySearchEntry(String propertyName, String propertyTitle, boolean editable, CmsMessages messages) {
        StringBuffer result = new StringBuffer(256);
        result.append(this.buildTableRowStart(this.key(propertyTitle)));
        String disabled = PARAM_DEFAULT;
        if (!editable) {
            disabled = " disabled=\"disabled\"";
        }
        String propValue = PARAM_DEFAULT;
        CmsProperty currentProperty = (CmsProperty)this.getActiveProperties().get(propertyName);
        if (currentProperty != null) {
            propValue = currentProperty.getValue();
            if (CmsStringUtil.isEmpty((String)propValue)) {
                String tmp;
                if (("style_head_img_uri".equals(propertyName) || "style_head_img_link".equals(propertyName)) && !CmsStringUtil.isEmpty((String)(tmp = this.getDefault(propertyName)))) {
                    propValue = tmp;
                }
            } else {
                propValue = propValue.trim();
            }
        }
        propValue = CmsEncoder.escapeXml((String)propValue);
        result.append("<input type=\"text\" style=\"width: 99%\" class=\"maxwidth\" ");
        result.append("name=\"");
        result.append("valprop");
        result.append(propertyName);
        result.append("\" id=\"");
        result.append("valprop");
        result.append(propertyName);
        result.append("\" value=\"");
        result.append(propValue);
        result.append("\"");
        result.append(disabled);
        result.append(">");
        result.append("<input type=\"hidden\" name=\"");
        result.append("valhidden");
        result.append(propertyName);
        result.append("\" id=\"");
        result.append("valhidden");
        result.append(propertyName);
        result.append("\" value=\"");
        result.append(propValue);
        result.append("\">");
        result.append("</td>\n");
        result.append("<td>");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        result.append("\t<tr>\n");
        result.append("<td>&nbsp;&nbsp;</td>");
        result.append("<td><a href=\"#\" onclick=\"javascript:top.openTreeWin('copy', true, 'main', '");
        result.append("valprop");
        result.append(propertyName);
        result.append("', document);\" class=\"button\" title=\"");
        result.append(messages.key("GUI_BUTTON_SEARCH_0"));
        result.append("\"><img class=\"button\" src=\"");
        result.append(CmsPropertyTemplateOne.getSkinUri());
        result.append("/buttons/folder.png\" border=\"0\"></a></td>");
        result.append("</tr>\n");
        result.append("</table>\n");
        result.append("</td>\n");
        result.append("</tr>");
        return result;
    }

    private StringBuffer buildPropertySelectbox(String listType, String propertyName, String propertyTitle, boolean editable) {
        StringBuffer result = new StringBuffer(128);
        result.append(this.buildTableRowStart(this.key(propertyTitle)));
        String disabled = PARAM_DEFAULT;
        if (!editable) {
            disabled = " disabled=\"disabled\"";
        }
        String propValue = PARAM_DEFAULT;
        CmsProperty currentProperty = (CmsProperty)this.getActiveProperties().get(propertyName);
        String inheritedValue = PARAM_DEFAULT;
        if (currentProperty != null) {
            propValue = currentProperty.getValue();
            inheritedValue = this.getDefault(propertyName);
        } else {
            propValue = this.getDefault(propertyName);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)propValue)) {
                propValue = PARAM_DEFAULT;
            }
            inheritedValue = propValue;
        }
        List resources = this.getConfigurationFiles(listType);
        ArrayList<String> options = new ArrayList<String>(resources.size() + 1);
        ArrayList<String> values = new ArrayList<String>(resources.size() + 1);
        int selectedIndex = 0;
        options.add(this.key("templateonedialog.nolayout"));
        if (PARAM_DEFAULT.equals(propValue) || PARAM_DEFAULT.equals(inheritedValue) || "none".equals(inheritedValue)) {
            values.add(PARAM_DEFAULT);
        } else {
            values.add("none");
        }
        for (int i = 0; i < resources.size(); ++i) {
            String description;
            String path;
            block13: {
                CmsResource res = (CmsResource)resources.get(i);
                path = this.getCms().getSitePath(res);
                description = PARAM_DEFAULT;
                try {
                    description = this.getCms().readPropertyObject(path, "Description", false).getValue(null);
                    if (CmsStringUtil.isEmpty((String)description)) {
                        description = this.getCms().readPropertyObject(path, "Title", false).getValue(path);
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block13;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String localized = this.key(description);
            if (localized.startsWith("???")) {
                localized = description;
            }
            options.add(localized);
            if (path.equals(propValue)) {
                selectedIndex = i + 1;
            }
            if (path.equals(inheritedValue)) {
                path = PARAM_DEFAULT;
            }
            values.add(path);
        }
        StringBuffer attrs = new StringBuffer(4);
        attrs.append("name=\"").append("valprop").append(propertyName).append("\"");
        attrs.append(" class=\"maxwidth\"");
        attrs.append(disabled);
        result.append(this.buildSelect(attrs.toString(), options, values, selectedIndex));
        result.append("<input type=\"hidden\" name=\"");
        result.append("valhidden");
        result.append(propertyName);
        result.append("\" id=\"");
        result.append("valhidden");
        result.append(propertyName);
        result.append("\" value=\"");
        result.append(propValue);
        result.append("\">");
        result.append("</td>\n");
        result.append("</tr>");
        return result;
    }

    private StringBuffer buildRadioButtons(String propertyName, String mode, String JSToggleFunction, boolean editable) {
        StringBuffer result = new StringBuffer(256);
        result.append(this.buildTableRowStart(this.key(KEY_PREFIX + propertyName), 2));
        result.append("\t<table border=\"0\">\n");
        result.append("\t<tr>\n");
        result.append("\t<td>\n");
        result.append(this.buildPropertyRadioEntry(propertyName, PARAM_DEFAULT, this.key("templateonedialog.radio.default"), JSToggleFunction, editable));
        result.append("</td>\n");
        result.append("\t<td>\n");
        result.append(this.buildPropertyRadioEntry(propertyName, PARAM_TRUE, this.key("templateonedialog.radio." + mode), JSToggleFunction, editable));
        result.append("</td>\n");
        result.append("\t<td>\n");
        result.append(this.buildPropertyRadioEntry(propertyName, PARAM_FALSE, this.key("templateonedialog.radio.disable"), JSToggleFunction, editable));
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        result.append(this.buildTableRowEnd());
        return result;
    }

    private StringBuffer buildTableRowStart(String propertyName, int colspan) {
        StringBuffer result = new StringBuffer(96);
        result.append("<tr>\n");
        result.append("\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
        result.append(propertyName);
        result.append("</td>\n");
        result.append("\t<td class=\"maxwidth\" colspan=\"");
        result.append(String.valueOf(colspan));
        result.append("\">");
        return result;
    }

    private List getConfigurationFiles(String listType) {
        List<CmsResource> result;
        block4: {
            result = new ArrayList();
            String configFolder = listType.equals("center") ? VFS_PATH_CONFIGFILES_CENTER : VFS_PATH_CONFIGFILES_RIGHT;
            try {
                result = this.getCms().readResources(configFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                String configPath = this.getCms().readPropertyObject(this.getParamResource(), "style_main_configpath", true).getValue();
                if (CmsStringUtil.isNotEmpty((String)configPath)) {
                    int type = OpenCms.getResourceManager().getResourceType("layout").getTypeId();
                    CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(type);
                    Iterator i = this.getCms().readResources(configPath, filter, false).iterator();
                    while (i.hasNext()) {
                        CmsResource res = (CmsResource)i.next();
                        String column = this.getCms().readPropertyObject(this.getCms().getSitePath(res), "layout.column", false).getValue();
                        if (!listType.equals(column)) continue;
                        result.add(res);
                    }
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

