/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.frontend.templateone.CmsTemplateBase;
import org.opencms.frontend.templateone.CmsTemplateContentListItem;
import org.opencms.frontend.templateone.CmsTemplateLink;
import org.opencms.frontend.templateone.CmsTemplateParts;
import org.opencms.frontend.templateone.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsTemplateBean
extends CmsTemplateBase {
    public static final String FILE_CONFIG_COMMON = "configuration_common";
    public static final String FILE_CSS = "style.css";
    public static final String FILE_CSS_ACCESSIBLE = "style_accessible.css";
    public static final String FILE_LINKS_HEAD = "configuration_links";
    public static final String FOLDER_ELEMENTS = "../elements/";
    public static final String MESSAGE_BUNDLE = "templateone";
    public static final String MODULE_NAME = "org.opencms.frontend.templateone";
    public static final String PARAM_ACCESSIBLE = "accessible";
    public static final String PARAM_COMMON = "common";
    public static final String PARAM_HELPURI = "helpuri";
    public static final String PARAM_LAYOUT = "layout";
    public static final String PARAM_LOGINURI = "loginuri";
    public static final String PARAM_PART = "part";
    public static final String PARAM_PRINT = "print";
    public static final String PARAM_SITE = "site";
    public static final String PARAM_URI = "uri";
    public static final String PROPERTY_CONFIGPATH = "style_main_configpath";
    public static final String PROPERTY_EXTENSIONMODULE = "style_main_extensionmodule";
    public static final String PROPERTY_HEAD_DEFAULTLINK = "style_head_links_defaultlink";
    public static final String PROPERTY_HEAD_ELEMENTURI = "style_head_elementuri";
    public static final String PROPERTY_HEAD_IMGHEIGHT = "style_head_img_height";
    public static final String PROPERTY_HEAD_IMGLINK = "style_head_img_link";
    public static final String PROPERTY_HEAD_IMGURI = "style_head_img_uri";
    public static final String PROPERTY_LAYOUT_CENTER = "layout.center";
    public static final String PROPERTY_LAYOUT_RIGHT = "layout.right";
    public static final String PROPERTY_NAVLEFT_ELEMENTURI = "style_navleft_element_uri";
    public static final String PROPERTY_RESOURCEPATH = "style_main_resourcepath";
    public static final String PROPERTY_SHOW_HEADNAV = "style_show_head_nav";
    public static final String PROPERTY_SHOW_NAVLEFT = "style_show_navleft";
    public static final String PROPERTY_SHOWHEADIMAGE = "style_show_head_img";
    public static final String PROPERTY_SHOWHEADLINKS = "style_show_head_links";
    public static final String PROPERTY_SIDE_URI = "style_side_uri";
    public static final String PROPERTY_STARTFOLDER = "style_main_startfolder";
    public static final String PROPERTY_VALUE_NONE = "none";
    public static final String RESOURCE_TYPE_MICROSITE_NAME = "microsite";
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateBean.class);
    private CmsXmlContent m_globalConfiguration;
    private String m_layout;
    private Map m_listDefaults;
    private CmsMessages m_messages;
    private Map m_properties;
    private String m_resPath;
    private boolean m_showAccessibleVersion;
    private boolean m_showHeadNavigation;
    private boolean m_showPrintVersion;
    private String m_startFolder;

    public CmsTemplateBean() {
    }

    public CmsTemplateBean(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    protected static CmsXmlContent getConfigurationFile(String fileName, CmsObject cms) {
        CmsXmlContent configuration;
        block2: {
            configuration = null;
            try {
                CmsFile configFile = cms.readFile(fileName, CmsResourceFilter.IGNORE_EXPIRATION);
                configuration = CmsXmlContentFactory.unmarshal((CmsObject)cms, (CmsFile)configFile);
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)Messages.get().getBundle().key("LOG_XMLCONTEN_CONFIG_NOT_FOUND_2", (Object)fileName, (Object)cms.getRequestContext().getUri()));
            }
        }
        return configuration;
    }

    public void buildHtmlBodyEnd() throws IOException, JspException {
        this.m_properties.put(PARAM_LAYOUT, this.getLayout());
        JspWriter out = this.getJspContext().getOut();
        String elementName = "../elements/body_end.jsp";
        out.print(this.getTemplateParts().includePart(elementName, "1", this.getLayout(), this));
        if (!this.showPrintVersion()) {
            this.include(this.getExtensionModuleFileUri("elements/info_side.jsp"), null, this.m_properties);
        }
        out.print(this.getTemplateParts().includePart(elementName, "2", this.getLayout(), this));
        if (!this.showPrintVersion()) {
            this.getProperties().put(PARAM_HELPURI, this.getConfigurationValue("help.uri", PROPERTY_VALUE_NONE));
            this.getProperties().put(PARAM_LOGINURI, this.getConfigurationValue("login.uri", PROPERTY_VALUE_NONE));
            this.include("../elements/foot_links.jsp", null, this.m_properties);
            boolean showMenus = Boolean.valueOf(this.getConfigurationValue("headnav.menus", CmsStringUtil.TRUE));
            if (this.showHeadNavigation() && showMenus) {
                if (this.getProperties().get("headnavmenudepth") == null) {
                    this.getProperties().put(PARAM_SITE, this.getRequestContext().getSiteRoot());
                    this.getProperties().put("startfolder", this.getStartFolder());
                    this.getProperties().put("headnavfolder", this.getNavigationStartFolder());
                    this.getProperties().put("headnavmenudepth", this.getConfigurationValue("headnav.menudepth", "1"));
                    this.getProperties().put("showmenus", this.getConfigurationValue("headnav.menus", CmsStringUtil.TRUE));
                    this.getProperties().put("headnavmanual", this.getConfigurationValue("headnav.manual", CmsStringUtil.FALSE));
                }
                this.include("../elements/nav_head_menus.jsp", null, this.m_properties);
            }
        } else {
            this.m_properties.put(PARAM_URI, this.getRequestContext().getUri());
            this.include("/system/modules/org.opencms.frontend.templateone/pages/imprint.html", "content", this.m_properties);
        }
        out.print(this.getTemplateParts().includePart(elementName, "3", this.getLayout(), this));
    }

    public String getAreaName() {
        String name = this.getConfigurationValue("area.name", null);
        if (name == null) {
            String startFolder = this.getStartFolder();
            name = this.property("Title", startFolder, CmsResource.getName((String)startFolder));
        }
        return name;
    }

    public String getConfigPath() {
        return this.property(PROPERTY_CONFIGPATH, "search", "/");
    }

    public CmsXmlContent getConfiguration() {
        if (this.m_globalConfiguration == null) {
            this.m_globalConfiguration = CmsTemplateBean.getConfigurationFile(this.getConfigPath() + FILE_CONFIG_COMMON, this.getCmsObject());
        }
        return this.m_globalConfiguration;
    }

    public String getConfigurationValue(String key) {
        return this.getConfigurationValue(key, null);
    }

    public String getConfigurationValue(String key, String defaultValue) {
        String value;
        block3: {
            value = null;
            try {
                value = this.getConfiguration().getStringValue(null, key, this.getRequestContext().getLocale());
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    public String getDescription(String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        return this.property("Description", "search", defaultValue);
    }

    public String getEncoding() {
        return this.property("content-encoding", "search", OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public String getExtensionModuleFileUri(String relFilePath) {
        block4: {
            String configModule = this.property(PROPERTY_EXTENSIONMODULE, "/system/modules/org.opencms.frontend.templateone", PROPERTY_VALUE_NONE);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EXT_MODULE_PROP_VALUE_1", (Object)configModule));
            }
            if (!PROPERTY_VALUE_NONE.equals(configModule)) {
                String fileName = "/system/modules/" + configModule + "/" + relFilePath;
                try {
                    this.getCmsObject().readResource(fileName);
                    return fileName;
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EXT_MODULE_FILE_NOT_FOUND_1", (Object)fileName));
                }
            }
        }
        return "/system/modules/org.opencms.frontend.templateone/" + relFilePath;
    }

    public String getHeadElementUri() {
        String elemUri = (String)this.getProperties().get(PROPERTY_HEAD_ELEMENTURI);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)elemUri)) {
            elemUri = PROPERTY_VALUE_NONE;
        }
        return elemUri;
    }

    public List getHeadLinks() {
        String defaultLink;
        ArrayList<CmsTemplateLink> links = new ArrayList<CmsTemplateLink>(10);
        String configFile = this.getConfigPath() + FILE_LINKS_HEAD;
        CmsXmlContent configuration = CmsTemplateBean.getConfigurationFile(configFile, this.getCmsObject());
        boolean showMainLink = true;
        if (configuration != null) {
            Locale locale = this.getRequestContext().getLocale();
            int count = configuration.getIndexCount("Headlink", locale);
            for (int i = 1; i <= count; ++i) {
                block11: {
                    String prefix = "Headlink[" + i + "]";
                    try {
                        String url = configuration.getStringValue(null, prefix + "/link.url", locale);
                        String text = configuration.getStringValue(null, prefix + "/link.text", locale);
                        String target = configuration.getStringValue(null, prefix + "/link.target", locale);
                        if (CmsStringUtil.isEmpty((String)url) || CmsStringUtil.isEmpty((String)text)) break;
                        if (url.startsWith("/")) {
                            url = this.link(url);
                        }
                        CmsTemplateLink link = new CmsTemplateLink(url, text, target, i);
                        links.add(link);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (i != 10) continue;
                showMainLink = false;
            }
        }
        if (showMainLink && (defaultLink = (String)this.m_properties.get(PROPERTY_HEAD_DEFAULTLINK)) != null && !PROPERTY_VALUE_NONE.equals(defaultLink)) {
            String target;
            String text;
            String url;
            block12: {
                url = defaultLink;
                text = defaultLink;
                target = "";
                int sepIndex = defaultLink.indexOf("|");
                try {
                    if (sepIndex != -1) {
                        url = defaultLink.substring(0, sepIndex);
                        text = defaultLink.substring(sepIndex + 1);
                        if ((sepIndex = text.indexOf("|")) != -1) {
                            target = text.substring(sepIndex + 1);
                            text = text.substring(0, sepIndex);
                        }
                    }
                    if (url.startsWith("/")) {
                        url = this.link(url);
                    }
                    text = this.keyDefault(text, text);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block12;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            CmsTemplateLink link = new CmsTemplateLink(url, text, target, 0);
            links.add(link);
            Collections.sort(links);
        }
        return links;
    }

    public String getKeywords(String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        return this.property("Keywords", "search", defaultValue);
    }

    public String getLayout() {
        return this.m_layout;
    }

    public String getLeftNavigationElementUri() {
        return this.property(PROPERTY_NAVLEFT_ELEMENTURI, "search", PROPERTY_VALUE_NONE);
    }

    public String getNavigationStartFolder() {
        String startFolder = this.getConfigurationValue("navigation.startfolder", null);
        if (startFolder == null) {
            return this.getStartFolder();
        }
        startFolder = this.getRequestContext().removeSiteRoot(startFolder);
        return startFolder;
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public String getResourcePath() {
        if (this.m_resPath == null) {
            this.m_resPath = this.property(PROPERTY_RESOURCEPATH, "search", "na");
            if ("na".equals(this.m_resPath)) {
                this.m_resPath = "/system/modules/org.opencms.frontend.templateone/resources/";
            }
            this.m_resPath = this.link(this.m_resPath);
        }
        return this.m_resPath;
    }

    public String getSearchIndexName() {
        String currentSite = this.getRequestContext().getSiteRoot();
        if (currentSite.indexOf("sites/default") == -1) {
            return currentSite;
        }
        return "Online project " + this.getRequestContext().getLocale().toString().toUpperCase() + " (VFS)";
    }

    public String getStartFolder() {
        block7: {
            if (this.m_startFolder == null) {
                int folderTypeId;
                block6: {
                    folderTypeId = -1;
                    try {
                        folderTypeId = OpenCms.getResourceManager().getResourceType(RESOURCE_TYPE_MICROSITE_NAME).getTypeId();
                    }
                    catch (CmsLoaderException e) {
                        if (!LOG.isErrorEnabled()) break block6;
                        LOG.error((Object)Messages.get().getBundle().key("LOG_MICROSITE_FOLDER_NOT_FOUND_0"));
                    }
                }
                this.m_startFolder = "/";
                try {
                    CmsFolder startFolder = this.getCmsObject().readAncestor(this.getRequestContext().getUri(), folderTypeId);
                    if (startFolder != null) {
                        this.m_startFolder = this.getCmsObject().getRequestContext().removeSiteRoot(startFolder.getRootPath());
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block7;
                    LOG.error((Object)Messages.get().getBundle().key("LOG_MICROSITE_READ_START_FOLDER_0"));
                }
            }
        }
        return this.m_startFolder;
    }

    public String getStyleSheetConfigUri() {
        String confUri = this.property("properties_style", "search", "");
        if ("".equals(confUri)) {
            confUri = this.getConfigPath() + "configuration_css";
        }
        return confUri;
    }

    public String getStyleSheetUri() {
        String fileName = FILE_CSS;
        if (this.showAccessibleVersion()) {
            fileName = FILE_CSS_ACCESSIBLE;
        }
        return this.link("/system/modules/org.opencms.frontend.templateone/resources/" + fileName);
    }

    public String getStyleSheetUri(String resPath, String config, String site, Locale locale) {
        StringBuffer result = new StringBuffer(16);
        result.append("/system/modules/");
        result.append(MODULE_NAME);
        result.append("/resources/");
        if (this.showAccessibleVersion()) {
            result.append(FILE_CSS_ACCESSIBLE);
        } else {
            result.append(FILE_CSS);
        }
        result.append("?respath=");
        result.append(resPath);
        result.append("&config=");
        result.append(config);
        result.append("&site=");
        result.append(site);
        result.append("&__locale=");
        result.append(locale);
        return this.link(result.toString());
    }

    public CmsTemplateParts getTemplateParts() {
        return CmsTemplateParts.getInstance();
    }

    public String getTitle(String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        return this.property("Title", "search", defaultValue);
    }

    public void includeElements() throws IOException, JspException {
        boolean elementsPresent = this.template("text1,text2,text3,text4,text5,text6,text7,text8", false);
        String configFile = (String)this.getProperties().get(PROPERTY_LAYOUT_CENTER);
        List contents = new ArrayList();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)configFile) && !PROPERTY_VALUE_NONE.equals(configFile)) {
            contents = this.getContentListItems(configFile, "center");
        }
        int size = contents.size();
        boolean showPageLinks = true;
        if (size > 1) {
            showPageLinks = false;
        }
        if (elementsPresent || size > 0) {
            JspWriter out = this.getJspContext().getOut();
            String elementName = "../elements/elements.jsp";
            out.print(this.getTemplateParts().includePart(elementName, "start", this.getLayout(), this));
            int startPoint = 3 - size;
            int listIndex = 0;
            for (int i = 0; i < 4; ++i) {
                int elementIndex = i * 2 + 1;
                this.includeContentRow("text" + elementIndex, "text" + (elementIndex + 1), out);
                if (listIndex >= size || i < startPoint) continue;
                CmsTemplateContentListItem item = (CmsTemplateContentListItem)contents.get(listIndex);
                out.print(this.getTemplateParts().includePart(elementName, "column_start", this.getLayout(), this));
                out.print(this.getTemplateParts().includePart(elementName, "element_start_1", this.getLayout(), this));
                item.includeListItem(this, showPageLinks);
                out.print(this.getTemplateParts().includePart(elementName, "element_end", this.getLayout(), this));
                out.print(this.getTemplateParts().includePart(elementName, "column_end", this.getLayout(), this));
                ++listIndex;
            }
            out.print(this.getTemplateParts().includePart(elementName, "end", this.getLayout(), this));
        }
    }

    public void includePopup(String element, String title) throws JspException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if ("popuphead".equals(element)) {
            properties.put("stylesheeturi", this.getStyleSheetUri());
            properties.put("resourcepath", this.getResourcePath());
            properties.put("title", title);
            properties.put("config", this.getStyleSheetConfigUri());
        }
        this.include("/system/modules/org.opencms.frontend.templateone/pages/popup_includes.jsp", element, properties);
    }

    public void includeRightLists() throws JspException {
        String configFile = (String)this.getProperties().get(PROPERTY_LAYOUT_RIGHT);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)configFile) && !PROPERTY_VALUE_NONE.equals(configFile)) {
            List contents = this.getContentListItems(configFile, "right");
            int size = contents.size();
            for (int i = 0; i < size; ++i) {
                CmsTemplateContentListItem item = (CmsTemplateContentListItem)contents.get(i);
                item.includeListItem(this, false);
            }
        }
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super.init(context, req, res);
        String className = ((Object)((Object)this)).getClass().getName();
        if (className.endsWith("Bean")) {
            this.m_properties = this.properties("search");
            this.initPageVersion();
            this.m_showHeadNavigation = !this.showPrintVersion() && Boolean.valueOf(this.property(PROPERTY_SHOW_HEADNAV, "search", CmsStringUtil.TRUE)) != false;
        }
    }

    public String key(String keyName) {
        return this.messages().key(keyName);
    }

    public String keyDefault(String keyName, String defaultValue) {
        return this.messages().keyDefault(keyName, defaultValue);
    }

    public CmsMessages messages() {
        if (this.m_messages == null) {
            this.messages(MESSAGE_BUNDLE);
        }
        return this.m_messages;
    }

    public CmsMessages messages(String bundleName) {
        if (this.m_messages == null) {
            this.m_messages = new CmsMessages(bundleName, this.getRequestContext().getLocale());
        }
        return this.m_messages;
    }

    public void putNavigationProperties() {
        this.getProperties().put(PARAM_SITE, this.getRequestContext().getSiteRoot());
        this.getProperties().put(PARAM_ACCESSIBLE, "" + this.showAccessibleVersion());
        this.getProperties().put("respath", this.getResourcePath());
        this.getProperties().put("startfolder", this.getStartFolder());
        this.getProperties().put("headnavfolder", this.getNavigationStartFolder());
        this.getProperties().put("headnavimages", this.getConfigurationValue("headnav.images", CmsStringUtil.FALSE));
        this.getProperties().put("headnavmanual", this.getConfigurationValue("headnav.manual", CmsStringUtil.FALSE));
        this.getProperties().put("headnavmarkcurrent", this.getConfigurationValue("headnav.markcurrent", CmsStringUtil.FALSE));
        this.getProperties().put("headnavmenudepth", this.getConfigurationValue("headnav.menudepth", "1"));
        this.getProperties().put("headnavmenuclick", this.getConfigurationValue("headnav.menuclick", CmsStringUtil.FALSE));
        this.getProperties().put("showmenus", this.getConfigurationValue("headnav.menus", CmsStringUtil.TRUE));
        this.getProperties().put("navleftselected", this.getConfigurationValue("navleft.showselected", CmsStringUtil.FALSE));
        this.getProperties().put("navleftshowtree", "" + this.showLeftNavigation());
        this.getProperties().put("navleftelementuri", this.getLeftNavigationElementUri());
    }

    public void setLayout(String layout) {
        this.m_layout = layout;
    }

    public boolean showAccessibleVersion() {
        return this.m_showAccessibleVersion;
    }

    public boolean showHeadImage() {
        return Boolean.valueOf(this.property(PROPERTY_SHOWHEADIMAGE, "search", CmsStringUtil.TRUE));
    }

    public boolean showHeadLinks() {
        return Boolean.valueOf(this.property(PROPERTY_SHOWHEADLINKS, "search", CmsStringUtil.TRUE));
    }

    public boolean showHeadNavigation() {
        return this.m_showHeadNavigation;
    }

    public boolean showLeftNavigation() {
        return Boolean.valueOf(this.property(PROPERTY_SHOW_NAVLEFT, "search", CmsStringUtil.TRUE));
    }

    public boolean showPrintVersion() {
        return this.m_showPrintVersion;
    }

    private List getContentListItems(String configFile, String displayArea) {
        ArrayList<CmsTemplateContentListItem> result = new ArrayList<CmsTemplateContentListItem>();
        Map properties = this.properties(configFile);
        int i = 1;
        boolean cont = true;
        do {
            CmsTemplateContentListItem item;
            if ((item = CmsTemplateContentListItem.newInstance(this.getListDefaults(), properties, this.getStartFolder(), displayArea, i)) == null) {
                cont = false;
                continue;
            }
            result.add(item);
            ++i;
        } while (cont);
        return result;
    }

    private Map getListDefaults() {
        if (this.m_listDefaults == null) {
            CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(this.getRequestContext().getLocale());
            this.m_listDefaults = CmsTemplateContentListItem.getDefaultValuesFromMessages((CmsMessages)messages);
        }
        return this.m_listDefaults;
    }

    private void includeContentRow(String elementLeft, String elementRight, JspWriter out) throws IOException, JspException {
        if (this.template(elementLeft + "," + elementRight, false)) {
            String elementName = "../elements/elements.jsp";
            out.print(this.getTemplateParts().includePart(elementName, "column_start", this.getLayout(), this));
            if (this.template(elementLeft, true)) {
                if (this.template(elementRight, true)) {
                    out.print(this.getTemplateParts().includePart(elementName, "element_start_2", this.getLayout(), this));
                } else {
                    out.print(this.getTemplateParts().includePart(elementName, "element_start_1", this.getLayout(), this));
                }
                this.include(null, elementLeft, true);
                out.print(this.getTemplateParts().includePart(elementName, "element_end", this.getLayout(), this));
            }
            if (this.template(elementRight, true)) {
                if (this.template(elementLeft, true)) {
                    out.print(this.getTemplateParts().includePart(elementName, "element_start_2", this.getLayout(), this));
                } else {
                    out.print(this.getTemplateParts().includePart(elementName, "element_start_1", this.getLayout(), this));
                }
                this.include(null, elementRight, true);
                out.print(this.getTemplateParts().includePart(elementName, "element_end", this.getLayout(), this));
            }
            out.print(this.getTemplateParts().includePart(elementName, "column_end", this.getLayout(), this));
        }
    }

    private void initPageVersion() {
        this.m_showPrintVersion = Boolean.valueOf(this.getRequest().getParameter(PARAM_PRINT));
        if (!this.showPrintVersion()) {
            String param = this.getRequest().getParameter(PARAM_ACCESSIBLE);
            this.m_showAccessibleVersion = CmsStringUtil.isNotEmpty((String)param) ? Boolean.valueOf(param).booleanValue() : this.getConfigurationValue("layout.version", PARAM_COMMON).equals(PARAM_ACCESSIBLE);
            if (this.showAccessibleVersion()) {
                this.setLayout(PARAM_ACCESSIBLE);
            } else {
                this.setLayout(PARAM_COMMON);
            }
        } else {
            this.setLayout(PARAM_PRINT);
        }
    }
}

