/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

public class CmsTemplateContentListItem {
    public static final String DISPLAYAREA_CENTER = "center";
    public static final String DISPLAYAREA_LEFT = "left";
    public static final String DISPLAYAREA_RIGHT = "right";
    static final String[] DISPLAYAREAS = new String[]{"center", "left", "right"};
    public static final String LISTVARIATION_LONG = "long";
    public static final String LISTVARIATION_SHORT = "short";
    static final String[] LISTVARIATIONS = new String[]{"", ".long", ".short"};
    public static final String MACRO_LISTINDEX = "index";
    public static final String MACRO_MICROSITEFOLDER = "microsite.folder";
    public static final String PARAM_COLLECTOR = "collector";
    public static final String PARAM_COUNT = "count";
    public static final String PARAM_ELEMENTCOUNT = "elementcount";
    public static final String PARAM_FOLDER = "folder";
    public static final String PARAM_LISTELEMENT = "listelement";
    public static final String PROPERTY_LAYOUT_COLLECTOR = "layout.${index}.collector";
    public static final String PROPERTY_LAYOUT_COUNT = "layout.${index}.count";
    public static final String PROPERTY_LAYOUT_FOLDER = "layout.${index}.folder";
    public static final String PROPERTY_LAYOUT_TYPE = "layout.${index}.type";
    public static final String PROPERTY_LAYOUT_VARIATION = "layout.${index}.variation";
    public static final String PROPERTY_VALUE_NONE = "none";
    private String m_collector;
    private int m_count;
    private String m_displayArea;
    private String m_folder;
    private String m_listElement;
    private String m_type;
    private String m_variation;

    public static Map getDefaultValuesFromMessages(CmsMessages messages) {
        HashMap<String, String> result = new HashMap<String, String>();
        List resTypes = OpenCms.getResourceManager().getResourceTypes();
        for (int i = 0; i < resTypes.size(); ++i) {
            I_CmsResourceType type = (I_CmsResourceType)resTypes.get(i);
            if (!type.isAdditionalModuleResourceType()) continue;
            for (int k = 0; k < DISPLAYAREAS.length; ++k) {
                String area = DISPLAYAREAS[k];
                String typeName = type.getTypeName();
                StringBuffer keyPrefix = new StringBuffer(8);
                keyPrefix.append("layout.").append(typeName).append('.').append(area).append('.');
                String key = keyPrefix + PARAM_COLLECTOR;
                String value = messages.key(key);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)value) || value.startsWith("???")) continue;
                result.put(key, value);
                key = keyPrefix + PARAM_COUNT;
                result.put(key, messages.key(key));
                key = keyPrefix + PARAM_FOLDER;
                result.put(key, messages.key(key));
                for (int m = 0; m < LISTVARIATIONS.length; ++m) {
                    key = keyPrefix + PARAM_LISTELEMENT + LISTVARIATIONS[m];
                    value = messages.key(key);
                    if (value.startsWith("???")) continue;
                    result.put(key, value);
                }
            }
        }
        return result;
    }

    public static CmsTemplateContentListItem newInstance(Map defaultValues, Map properties, String microSiteFolder, String displayArea, int index) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.addMacro(MACRO_LISTINDEX, Integer.toString(index));
        resolver.addMacro(MACRO_MICROSITEFOLDER, microSiteFolder);
        String type = (String)properties.get(resolver.resolveMacros(PROPERTY_LAYOUT_TYPE));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)type) && !PROPERTY_VALUE_NONE.equals(type)) {
            CmsTemplateContentListItem listItem = new CmsTemplateContentListItem();
            listItem.setType(type);
            StringBuffer keyPrefix = new StringBuffer(8);
            keyPrefix.append("layout.").append(type).append('.').append(displayArea).append('.');
            String collector = (String)properties.get(resolver.resolveMacros(PROPERTY_LAYOUT_COLLECTOR));
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)collector)) {
                collector = (String)defaultValues.get(keyPrefix + PARAM_COLLECTOR);
            }
            listItem.setCollector(collector);
            String count = (String)properties.get(resolver.resolveMacros(PROPERTY_LAYOUT_COUNT));
            String defaultCount = (String)defaultValues.get(keyPrefix + PARAM_COUNT);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)count)) {
                count = defaultCount;
            }
            try {
                listItem.setCount(Integer.parseInt(count));
            }
            catch (NumberFormatException e) {
                listItem.setCount(Integer.parseInt(defaultCount));
            }
            String folder = (String)properties.get(resolver.resolveMacros(PROPERTY_LAYOUT_FOLDER));
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)folder)) {
                folder = (String)defaultValues.get(keyPrefix + PARAM_FOLDER);
            }
            listItem.setFolder(resolver.resolveMacros(folder));
            String variation = (String)properties.get(resolver.resolveMacros(PROPERTY_LAYOUT_VARIATION));
            variation = CmsStringUtil.isEmptyOrWhitespaceOnly((String)variation) ? "" : '.' + variation;
            String listElement = (String)defaultValues.get(keyPrefix + PARAM_LISTELEMENT + variation);
            listItem.setListElement(listElement);
            listItem.setDisplayArea(displayArea);
            return listItem;
        }
        return null;
    }

    public String getCollector() {
        return this.m_collector;
    }

    public int getCount() {
        return this.m_count;
    }

    public String getDisplayArea() {
        return this.m_displayArea;
    }

    public String getFolder() {
        return this.m_folder;
    }

    public String getListElement() {
        return this.m_listElement;
    }

    public String getType() {
        return this.m_type;
    }

    public String getVariation() {
        return this.m_variation;
    }

    public void includeListItem(CmsJspActionElement jsp, boolean showPageLinks) throws JspException {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put(PARAM_COLLECTOR, this.getCollector());
        properties.put(PARAM_COUNT, Integer.toString(this.getCount()));
        if (showPageLinks) {
            properties.put(PARAM_ELEMENTCOUNT, Integer.toString(Integer.MAX_VALUE));
        } else {
            properties.put(PARAM_ELEMENTCOUNT, Integer.toString(this.getCount()));
        }
        properties.put(PARAM_FOLDER, this.getFolder());
        jsp.include(this.getListElement(), null, properties);
    }

    protected void setCollector(String collector) {
        this.m_collector = collector;
    }

    protected void setCount(int count) {
        this.m_count = count;
    }

    protected void setDisplayArea(String displayArea) {
        this.m_displayArea = displayArea;
    }

    protected void setFolder(String contentFolder) {
        this.m_folder = contentFolder;
    }

    protected void setListElement(String listElement) {
        this.m_listElement = listElement;
    }

    protected void setType(String type) {
        this.m_type = type;
    }

    protected void setVariation(String variation) {
        this.m_variation = variation;
    }
}

