/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.CmsTemplateForm;
import org.opencms.frontend.templateone.CmsTemplateImprint;
import org.opencms.frontend.templateone.Messages;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsTemplateFormLetter
extends CmsTemplateForm {
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateFormLetter.class);
    private String m_concern;
    private String m_concernDetail;
    private String m_contactCity;
    private String m_contactCountry;
    private String m_contactEmail;
    private String m_contactFirstName;
    private String m_contactLastName;
    private String m_contactNumber;
    private String m_contactPhone;
    private String m_contactSalutation;
    private String m_contactStreet;
    private String m_contactTitle;
    private String m_contactZip;
    private String m_copy;
    private String m_message;

    public CmsTemplateFormLetter() {
        this.m_concern = "";
        this.m_concernDetail = "";
        this.m_contactCity = "";
        this.m_contactCountry = "";
        this.m_contactEmail = "";
        this.m_contactFirstName = "";
        this.m_contactLastName = "";
        this.m_contactNumber = "";
        this.m_contactPhone = "";
        this.m_contactSalutation = "";
        this.m_contactStreet = "";
        this.m_contactTitle = "";
        this.m_contactZip = "";
        this.m_copy = "";
        this.m_message = "";
    }

    public CmsTemplateFormLetter(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super.init(context, req, res);
    }

    public String getConcern() {
        return this.m_concern;
    }

    public String getConcernDetail() {
        return this.m_concernDetail;
    }

    public String getContactCity() {
        return this.m_contactCity;
    }

    public String getContactCountry() {
        return this.m_contactCountry;
    }

    public String getContactEmail() {
        return this.m_contactEmail;
    }

    public String getContactFirstName() {
        return this.m_contactFirstName;
    }

    public String getContactLastName() {
        return this.m_contactLastName;
    }

    public String getContactNumber() {
        return this.m_contactNumber;
    }

    public String getContactPhone() {
        return this.m_contactPhone;
    }

    public String getContactSalutation() {
        return this.m_contactSalutation;
    }

    public String getContactStreet() {
        return this.m_contactStreet;
    }

    public String getContactTitle() {
        return this.m_contactTitle;
    }

    public String getContactZip() {
        return this.m_contactZip;
    }

    public String getCopy() {
        return this.m_copy;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String isConcernChecked(String currentValue) {
        if (this.isSelected(currentValue, this.getConcern())) {
            return " checked=\"checked\"";
        }
        return "";
    }

    public String isCopyChecked() {
        return this.isChecked(this.getCopy());
    }

    public String isSalutationSelected(String currentValue) {
        if (this.isSelected(currentValue, this.getContactSalutation())) {
            return " selected=\"selected\"";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMail() {
        CmsHtmlMail theMail = new CmsHtmlMail();
        theMail.setSubject(this.key("letter.mail.subject.prefix") + this.getPageTitle());
        theMail.setCharset(this.getRequestContext().getEncoding());
        theMail.setHtmlMsg(this.getContent("letter_mail.html", "html", this.getRequestContext().getLocale()));
        theMail.setTextMsg(this.getContent("letter_mail.html", "text", this.getRequestContext().getLocale()));
        try {
            String uri = this.getRequestContext().getUri();
            try {
                CmsTemplateImprint imprint = new CmsTemplateImprint(this.getJspContext(), this.getRequest(), this.getResponse());
                String receiver = imprint.getEmail(null);
                theMail.addTo(receiver);
            }
            finally {
                this.getRequestContext().setUri(uri);
            }
            String sender = OpenCms.getSystemInfo().getMailSettings().getMailFromDefault();
            String contactMail = this.getContactEmail();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)contactMail)) {
                contactMail = sender;
            }
            theMail.setFrom(sender);
            theMail.addReplyTo(contactMail);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCopy())) {
                theMail.addCc(contactMail);
            }
            theMail.send();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)e);
            } else if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_SEND_MAIL_CONTACT_1"));
            }
            return false;
        }
        return true;
    }

    public void setConcern(String concern) {
        this.m_concern = concern;
    }

    public void setConcernDetail(String concernDetail) {
        this.m_concernDetail = concernDetail;
    }

    public void setContactCity(String contactCity) {
        this.m_contactCity = contactCity;
    }

    public void setContactCountry(String contactCountry) {
        this.m_contactCountry = contactCountry;
    }

    public void setContactEmail(String email) {
        this.m_contactEmail = email;
    }

    public void setContactFirstName(String contactFirstName) {
        this.m_contactFirstName = contactFirstName;
    }

    public void setContactLastName(String contactLastName) {
        this.m_contactLastName = contactLastName;
    }

    public void setContactNumber(String contactNumber) {
        this.m_contactNumber = contactNumber;
    }

    public void setContactPhone(String contactPhone) {
        this.m_contactPhone = contactPhone;
    }

    public void setContactSalutation(String contactSalutation) {
        this.m_contactSalutation = contactSalutation;
    }

    public void setContactStreet(String contactStreet) {
        this.m_contactStreet = contactStreet;
    }

    public void setContactTitle(String contactTitle) {
        this.m_contactTitle = contactTitle;
    }

    public void setContactZip(String contactZip) {
        this.m_contactZip = contactZip;
    }

    public void setCopy(String copy) {
        this.m_copy = copy;
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    public boolean validate() {
        boolean allOk = true;
        this.setErrors(new HashMap());
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getConcern())) {
            this.getErrors().put("concern", this.key("letter.error.concern.empty"));
            allOk = false;
        } else if ("other".equals(this.getConcern()) && CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getConcernDetail())) {
            this.getErrors().put("concern", this.key("letter.error.concerndetails.empty"));
            allOk = false;
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getMessage())) {
            this.getErrors().put("message", this.key("letter.error.message.empty"));
            allOk = false;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCopy()) && CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getContactEmail())) {
            this.getErrors().put("email", this.key("letter.error.email.empty"));
            allOk = false;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getContactEmail()) && !CmsTemplateFormLetter.isValidEmailAddress(this.getContactEmail())) {
            this.getErrors().put("email", this.key("letter.error.email.wrong"));
            allOk = false;
        }
        return allOk;
    }

    protected String checkTextsUri() {
        String fileUri = this.getConfigurationValue("page.form.letter", null);
        if (fileUri != null) {
            fileUri = this.getRequestContext().removeSiteRoot(fileUri);
            try {
                this.getCmsObject().readResource(fileUri);
                return fileUri;
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return "/system/modules/org.opencms.frontend.templateone/pages/letter_content.html";
    }
}

