/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.CmsTemplateForm;
import org.opencms.frontend.templateone.Messages;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsTemplateFormRecommend
extends CmsTemplateForm {
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateFormRecommend.class);
    private String m_copy;
    private String m_emailRecipient;
    private String m_emailSender;
    private String m_message;

    public CmsTemplateFormRecommend() {
        this.m_emailRecipient = "";
        this.m_emailSender = "";
        this.m_message = "";
        this.m_copy = "";
    }

    public CmsTemplateFormRecommend(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super.init(context, req, res);
    }

    public String getCopy() {
        return this.m_copy;
    }

    public String getEmailRecipient() {
        return this.m_emailRecipient;
    }

    public String getEmailSender() {
        return this.m_emailSender;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String isCopyChecked() {
        return this.isChecked(this.getCopy());
    }

    public boolean sendMail() {
        CmsHtmlMail theMail = new CmsHtmlMail();
        theMail.setSubject(this.key("recommend.mail.subject.prefix") + this.getPageTitle());
        theMail.setCharset(this.getRequestContext().getEncoding());
        theMail.setHtmlMsg(this.getContent("recommend_mail.html", "html", this.getRequestContext().getLocale()));
        theMail.setTextMsg(this.getContent("recommend_mail.html", "text", this.getRequestContext().getLocale()));
        try {
            theMail.addTo(this.getEmailRecipient());
            String sender = OpenCms.getSystemInfo().getMailSettings().getMailFromDefault();
            String replyTo = this.getEmailSender();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)replyTo)) {
                replyTo = sender;
            }
            theMail.setFrom(sender);
            theMail.addReplyTo(replyTo);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCopy())) {
                theMail.addCc(replyTo);
            }
            theMail.send();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)e);
            } else if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_SEND_MAIL_RECOMMENDPAGE_1", (Object)this.getRequestContext().getUri()));
            }
            return false;
        }
        return true;
    }

    public void setCopy(String copy) {
        this.m_copy = copy;
    }

    public void setEmailRecipient(String emailRecipient) {
        this.m_emailRecipient = emailRecipient;
    }

    public void setEmailSender(String emailSender) {
        this.m_emailSender = emailSender;
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    public boolean validate() {
        boolean allOk = true;
        this.setErrors(new HashMap());
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getEmailRecipient())) {
            this.getErrors().put("recipient", this.key("recommend.error.recipient.empty"));
            allOk = false;
        } else if (!CmsTemplateFormRecommend.isValidEmailAddress(this.getEmailRecipient())) {
            this.getErrors().put("recipient", this.key("recommend.error.recipient.wrong"));
            allOk = false;
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getMessage())) {
            this.getErrors().put("message", this.key("recommend.error.message.empty"));
            allOk = false;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCopy()) && CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getEmailSender())) {
            this.getErrors().put("sender", this.key("recommend.error.sender.empty"));
            allOk = false;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getEmailSender()) && !CmsTemplateFormRecommend.isValidEmailAddress(this.getEmailSender())) {
            this.getErrors().put("sender", this.key("recommend.error.sender.wrong"));
            allOk = false;
        }
        return allOk;
    }

    protected String checkTextsUri() {
        String fileUri = this.getConfigurationValue("page.form.recommend", null);
        if (fileUri != null) {
            fileUri = this.getRequestContext().removeSiteRoot(fileUri);
            try {
                this.getCmsObject().readResource(fileUri);
                return fileUri;
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return "/system/modules/org.opencms.frontend.templateone/pages/recommend_content.html";
    }
}

