/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.Messages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public final class CmsTemplateParts
implements I_CmsEventListener {
    public static final String KEY_ILLEGAL = "illpart";
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateParts.class);
    private static CmsTemplateParts m_instance;
    private Map m_parts;

    private CmsTemplateParts() {
        this.initPartsMap();
        OpenCms.addCmsEventListener((I_CmsEventListener)this);
    }

    public static CmsTemplateParts getInstance() {
        if (m_instance == null) {
            m_instance = new CmsTemplateParts();
        }
        return m_instance;
    }

    public void addPart(String partKey, String value) {
        if (!partKey.equals(KEY_ILLEGAL)) {
            this.m_parts.put(partKey, value);
        }
    }

    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                this.initPartsMap();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CMSTEMPLATEPARTS_CLEARED_0"));
                break;
            }
        }
    }

    public String getPart(String partKey) {
        return (String)this.m_parts.get(partKey);
    }

    public String includePart(String target, String element, String layout, CmsJspActionElement jsp) {
        String part;
        block9: {
            if (OpenCms.getRunLevel() < 4) {
                return "";
            }
            part = null;
            String partKey = "";
            try {
                partKey = this.generateKey(target, element, layout, jsp.getRequestContext().getLocale(), jsp.getRequestContext().currentProject().getUuid());
                part = (String)this.m_parts.get(partKey);
                if (part == null) {
                    part = jsp.getContent(target, element, jsp.getRequestContext().getLocale());
                    if (part != null && !part.startsWith("???")) {
                        this.addPart(partKey, part);
                    } else {
                        part = "";
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_INCLUDE_PART_NOT_FOUND_1", (Object)partKey));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_INCLUDE_PART_FOUND_1", (Object)partKey));
                }
            }
            catch (Throwable t) {
                part = "";
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_INCLUDE_PART_ERR_2", (Object)partKey, (Object)t));
            }
        }
        return part;
    }

    private String generateKey(String target, String element, String layout, Locale locale, CmsUUID project) {
        try {
            if (element == null) {
                element = "";
            }
            StringBuffer partKey = new StringBuffer(32);
            partKey.append(target);
            partKey.append("_");
            partKey.append(element);
            partKey.append("_");
            partKey.append(layout);
            partKey.append("_");
            partKey.append(locale);
            partKey.append("_");
            partKey.append(project);
            return partKey.toString();
        }
        catch (Exception e) {
            return KEY_ILLEGAL;
        }
    }

    private synchronized Map initPartsMap() {
        LRUMap cacheParts = new LRUMap(512);
        Map oldParts = this.m_parts;
        this.m_parts = Collections.synchronizedMap(cacheParts);
        if (oldParts != null) {
            oldParts.clear();
            oldParts = null;
        }
        return this.m_parts;
    }
}

