/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.frontend.templateone.CmsTemplateBean;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.search.CmsSearch;
import org.opencms.search.CmsSearchResult;
import org.opencms.util.CmsStringUtil;

public class CmsTemplateSearch
extends CmsTemplateBean {
    public static final String PARAM_SEARCHALL = "entire";
    private String m_pageUri;
    private boolean m_searchAll;

    public CmsTemplateSearch() {
    }

    public CmsTemplateSearch(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public String buildSearchErrorMessages(CmsSearch search, List results) {
        StringBuffer result = new StringBuffer(32);
        if (search.getLastException() != null) {
            String errorMessage = "";
            errorMessage = ((CmsException)((Object)search.getLastException())).getMessageContainer().getKey().equals("ERR_QUERY_TOO_SHORT_1") ? this.key("search.error.wordlength") : this.key("search.error.details");
            result.append("<h3>");
            result.append(this.key("search.error"));
            result.append("</h3>\n");
            result.append("<p>");
            result.append(errorMessage);
            result.append("</p>\n");
            result.append("<!-- Exception message: ");
            result.append(search.getLastException().toString());
            result.append("// -->\n");
        } else if (results == null || results.size() == 0) {
            result.append("<h3>");
            result.append(this.key("search.error.nomatch"));
            result.append("</h3>\n");
        }
        return result.toString();
    }

    public String buildSearchHeadline() {
        StringBuffer result = new StringBuffer(32);
        result.append(this.key("search.headline"));
        if (!this.isSearchAll() && !"/".equals(this.getStartFolder())) {
            result.append(this.key("search.headline.area"));
            result.append(this.getAreaName());
        } else {
            result.append(this.key("search.headline.all"));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildSearchLinks(CmsSearch search) {
        Map pageLinks;
        StringBuffer result = new StringBuffer(32);
        boolean showPageLinks = false;
        StringBuffer additionalParams = new StringBuffer(16);
        if (search.getPreviousUrl() != null || search.getNextUrl() != null) {
            showPageLinks = true;
            result.append("<div class=\"searchlinks\">\n");
            additionalParams.append("&uri=");
            additionalParams.append(CmsEncoder.encode((String)this.getRequestContext().getUri()));
            additionalParams.append("&");
            additionalParams.append("__locale");
            additionalParams.append("=");
            additionalParams.append(this.getRequestContext().getLocale());
            additionalParams.append("&");
            additionalParams.append(PARAM_SEARCHALL);
            additionalParams.append("=");
            additionalParams.append(this.isSearchAll());
        }
        if (search.getPreviousUrl() != null) {
            result.append("\t<input type=\"button\" class=\"formbutton\" value=\"&lt;&lt; ");
            result.append(this.key("search.previous"));
            result.append("\" onclick=\"location.href='");
            result.append(this.link(search.getPreviousUrl()));
            result.append(additionalParams);
            result.append("';\">");
        }
        try {
            this.getRequestContext().setUri("/system/modules/org.opencms.frontend.templateone/pages/search.html");
            pageLinks = search.getPageLinks();
        }
        finally {
            this.getRequestContext().setUri(this.getPageUri());
        }
        Iterator i = pageLinks.keySet().iterator();
        while (i.hasNext()) {
            int pageNumber = (Integer)i.next();
            String pageLink = this.link((String)pageLinks.get(new Integer(pageNumber)));
            result.append("&nbsp;&nbsp;");
            if (pageNumber != search.getSearchPage()) {
                result.append("<a href=\"");
                result.append(pageLink);
                result.append(additionalParams);
                result.append("\">");
                result.append(pageNumber);
                result.append("</a>");
                continue;
            }
            result.append(pageNumber);
        }
        if (search.getNextUrl() != null) {
            result.append("&nbsp;&nbsp;<input type=\"button\" class=\"formbutton\" value=\"");
            result.append(this.key("search.next"));
            result.append(" &gt;&gt;\" onclick=\"location.href='");
            result.append(this.link(search.getNextUrl()));
            result.append(additionalParams);
            result.append("';\">");
        }
        if (showPageLinks) {
            result.append("\n</div>\n");
        }
        return result.toString();
    }

    public String buildSearchResultList(List results) {
        StringBuffer result = new StringBuffer(128);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            CmsSearchResult entry = (CmsSearchResult)iterator.next();
            result.append("<div class=\"searchresult\">");
            String path = entry.getPath();
            path = this.getRequestContext().removeSiteRoot(path);
            String fileIcon = this.getFileIcon(path);
            if (CmsStringUtil.isNotEmpty((String)fileIcon)) {
                result.append("<a href=\"");
                result.append(this.link(path));
                result.append("\">");
                result.append(fileIcon);
                result.append("</a>&nbsp;");
            }
            result.append("<a href=\"");
            result.append(this.link(path));
            result.append("\">");
            String title = entry.getField("title-key");
            if (CmsStringUtil.isEmpty((String)title)) {
                title = CmsResource.getName((String)path);
            }
            result.append(title);
            result.append("</a>&nbsp;(");
            result.append(entry.getScore());
            result.append("%)<br>");
            if (entry.getExcerpt() != null) {
                result.append(entry.getExcerpt());
            }
            if (entry.getField("keywords") != null) {
                result.append("<br>");
                result.append(this.key("search.keywords"));
                result.append(": ");
                result.append(entry.getField("keywords"));
            }
            if (entry.getField("description") != null) {
                result.append("<br>");
                result.append(this.key("search.description"));
                result.append(": ");
                result.append(entry.getField("description"));
            }
            result.append("<br>");
            result.append(this.messages().getDateTime(entry.getDateLastModified().getTime()));
            result.append("</div>\n");
        }
        return result.toString();
    }

    public String getFileIcon(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        String extension = "";
        if (lastDot > 0 && lastDot < fileName.length() - 1) {
            extension = fileName.substring(lastDot + 1).toLowerCase();
            String iconPath = "/system/modules/org.opencms.frontend.templateone/resources/icons/ic_app_" + extension + ".gif";
            if (this.getCmsObject().existsResource(iconPath)) {
                StringBuffer result = new StringBuffer(8);
                String title = this.property("Title", iconPath, "");
                result.append("<img src=\"");
                result.append(this.link(iconPath));
                result.append("\" border=\"0\" alt=\"");
                result.append(title);
                result.append("\" title=\"");
                result.append(title);
                result.append("\" align=\"left\" hspace=\"2\">");
                return result.toString();
            }
        }
        return "";
    }

    public String getPageUri() {
        return this.m_pageUri;
    }

    public String getSearchAllChecked() {
        if (this.isSearchAll() || "/".equals(this.getStartFolder())) {
            return " checked=\"checked\"";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSearchResults(CmsSearch search) {
        ArrayList result;
        if (this.isSearchAll()) {
            search.setSearchRoot("/");
        } else {
            search.setSearchRoot(this.getStartFolder());
        }
        String queryString = search.getQuery();
        try {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)queryString)) {
                queryString = "";
                search.setQuery("");
                result = new ArrayList();
            } else {
                this.getRequestContext().setUri("/system/modules/org.opencms.frontend.templateone/pages/search.html");
                result = search.getSearchResult();
            }
        }
        finally {
            this.getRequestContext().setUri(this.getPageUri());
        }
        return result;
    }

    public void includeWithPageUri(String element) throws JspException {
        String template = this.property("template", "search", null);
        this.include(template, element);
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super.init(context, req, res);
        this.m_pageUri = req.getParameter("uri");
        if (this.m_pageUri == null) {
            this.m_pageUri = this.getRequestContext().getUri();
        }
        this.m_searchAll = Boolean.valueOf(req.getParameter(PARAM_SEARCHALL));
        this.getRequestContext().setUri(this.m_pageUri);
    }

    public boolean isSearchAll() {
        return this.m_searchAll;
    }

    public boolean isSearchAllDisplayed() {
        return !"/".equals(this.getStartFolder());
    }

    public void setSearchAll(boolean searchAll) {
        this.m_searchAll = searchAll;
    }
}

