/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.CmsTemplateBase;
import org.opencms.frontend.templateone.CmsTemplateBean;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsTemplateStyleSheet
extends CmsTemplateBase {
    public static final String FILENAME_CONFIGFILE = "configuration_css";
    public static final String NODE_OPTIONALCONFIG = "StyleOptional";
    public static final String PARAM_CONFIGFILE = "config";
    public static final String PROPERTY_CONFIGFILE = "properties_style";
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateStyleSheet.class);
    private CmsXmlContent m_configuration;
    private List m_headlineSizes;
    private String m_resPath;
    private String m_templateWidth;

    public CmsTemplateStyleSheet() {
    }

    public CmsTemplateStyleSheet(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public static String calculateHeight(String value, int delta) {
        String newHeight = value;
        try {
            int val = Integer.parseInt(value);
            newHeight = "" + (val + delta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newHeight;
    }

    public String getConfigValue(String key, String defaultValue) {
        String value;
        block4: {
            value = null;
            try {
                value = this.m_configuration.getStringValue(this.getCmsObject(), key, this.getRequestContext().getLocale());
                if (CmsStringUtil.isEmpty((String)value)) {
                    value = this.m_configuration.getStringValue(this.getCmsObject(), key, (Locale)this.m_configuration.getLocales().get(0));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    public String getFontUnderline(String key, String defaultValue) {
        String value = this.getOptionalConfigValue(key, defaultValue);
        value = Boolean.valueOf(value) != false ? "underline;" : "none;";
        return "text-decoration: " + value;
    }

    public String getFontWeight(String key, String defaultValue) {
        String value = this.getOptionalConfigValue(key, defaultValue);
        value = Boolean.valueOf(value) != false ? "bold;" : "normal;";
        return "font-weight: " + value;
    }

    public String getHeadlineSize(int headline) {
        String size = (String)this.getHeadlineSizes().get(headline - 1);
        if (CmsStringUtil.isEmpty((String)size)) {
            size = "13";
        }
        return size;
    }

    public String getOptionalConfigValue(String key, String defaultValue) {
        return this.getConfigValue("StyleOptional/" + key, defaultValue);
    }

    public String getResourcePath() {
        return this.m_resPath;
    }

    public String getTemplateWidth() {
        if (this.m_templateWidth == null) {
            String templateType = this.getConfigValue("main.template.type", "normal");
            this.m_templateWidth = "small".equals(templateType) ? "800" : "950";
        }
        return this.m_templateWidth;
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        block4: {
            super.init(context, req, res);
            String siteRoot = req.getParameter("site");
            if (CmsStringUtil.isNotEmpty((String)siteRoot)) {
                this.getRequestContext().setSiteRoot(siteRoot);
            }
            this.m_resPath = req.getParameter("respath");
            try {
                String configUri = req.getParameter(PARAM_CONFIGFILE);
                if (CmsStringUtil.isNotEmpty((String)configUri)) {
                    this.m_configuration = CmsTemplateBean.getConfigurationFile(configUri, this.getCmsObject());
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private List getHeadlineSizes() {
        if (this.m_headlineSizes == null) {
            ArrayList<String> sizes = new ArrayList<String>(6);
            String selectedValues = this.getOptionalConfigValue("headlines.set", "");
            if (CmsStringUtil.isEmpty((String)selectedValues)) {
                try {
                    CmsXmlContent conf = this.m_configuration;
                    if (conf != null) {
                        conf.addValue(this.getCmsObject(), NODE_OPTIONALCONFIG, this.getRequestContext().getLocale(), 0);
                        I_CmsXmlContentValue value = conf.getValue("StyleOptional/headlines.set", this.getRequestContext().getLocale());
                        selectedValues = value.getContentDefinition().getContentHandler().getConfiguration((I_CmsXmlSchemaType)value);
                        selectedValues = selectedValues.substring(0, selectedValues.indexOf(42));
                    } else {
                        selectedValues = "13-12-11-10-9-9";
                    }
                }
                catch (Exception e) {
                    selectedValues = "13-12-11-10-9-9";
                }
            }
            StringTokenizer T = new StringTokenizer(selectedValues, "-");
            while (T.hasMoreTokens()) {
                sizes.add(T.nextToken());
            }
            this.m_headlineSizes = sizes;
        }
        return this.m_headlineSizes;
    }
}

