/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.photoalbum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.frontend.photoalbum.CmsPhotoAlbumConfiguration;
import org.opencms.frontend.photoalbum.CmsPhotoAlbumStyle;
import org.opencms.frontend.photoalbum.Messages;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsPhotoAlbumBean
extends CmsJspActionElement {
    public static final int ACTION_DETAIL = 1;
    public static final int ACTION_ORIGINAL = 2;
    public static final int ACTION_THUMBNAIL = 0;
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_IMAGE = "image";
    public static final String PARAM_PAGE = "thumbpage";
    public static final String VALUE_ACTION_DETAIL = "detail";
    public static final String VALUE_ACTION_ORIGINAL = "original";
    public static final String VALUE_ACTION_THUMBNAIL = "thumbnail";
    private static final Log LOG = CmsLog.getLog((Object)CmsPhotoAlbumBean.class);
    private List m_albumPhotos;
    private List m_configErrors;
    private CmsPhotoAlbumConfiguration m_configuration;
    private int m_currentPage;
    private int m_displayAction;
    private CmsMessages m_messages;
    private int m_pageCount;
    private int m_photosPerPage;
    private CmsPhotoAlbumStyle m_style;

    public CmsPhotoAlbumBean(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(context, req, res, null);
    }

    public CmsPhotoAlbumBean(PageContext context, HttpServletRequest req, HttpServletResponse res, String configUri) {
        super(context, req, res);
        this.init(configUri);
    }

    public String displayAlbum() throws IOException {
        this.buildHtmlConfigurationErrors();
        switch (this.getDisplayAction()) {
            case 1: {
                return this.buildHtmlViewDetail();
            }
            case 2: {
                return "";
            }
        }
        return this.buildHtmlViewThumbNail();
    }

    public List getAlbumPhotos() {
        if (this.m_albumPhotos == null) {
            CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(CmsResourceTypeImage.getStaticTypeId());
            try {
                this.m_albumPhotos = this.getCmsObject().readResources(this.getConfiguration().getVfsPathGallery(), filter, false);
            }
            catch (CmsException e) {
                this.m_albumPhotos = new ArrayList(0);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_IMAGEFOLDER_NOT_FOUND_1", (Object)this.getConfiguration().getVfsPathGallery()));
                }
                this.addConfigError(this.m_messages.key("LOG_ERR_IMAGEFOLDER_NOT_FOUND_1", (Object)this.getConfiguration().getVfsPathGallery()));
            }
        }
        return this.m_albumPhotos;
    }

    public CmsPhotoAlbumConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    public int getDisplayAction() {
        return this.m_displayAction;
    }

    public int getPageCount() {
        return this.m_pageCount;
    }

    public int getPhotosPerPage() {
        return this.m_photosPerPage;
    }

    public CmsPhotoAlbumStyle getStyle() {
        return this.m_style;
    }

    public void init(String configUri) {
        this.m_messages = Messages.get().getBundle(this.getRequestContext().getLocale());
        this.setConfigErrors(new ArrayList());
        this.setStyle(new CmsPhotoAlbumStyle());
        try {
            this.setConfiguration(new CmsPhotoAlbumConfiguration(this, configUri));
        }
        catch (Exception e) {
            this.setConfiguration(new CmsPhotoAlbumConfiguration());
            if (e instanceof CmsException) {
                this.addConfigError(((CmsException)((Object)e)).getLocalizedMessage(this.getRequestContext().getLocale()));
            }
            this.addConfigError(e.getLocalizedMessage());
        }
        String action = this.getRequest().getParameter(PARAM_ACTION);
        if (VALUE_ACTION_DETAIL.equals(action)) {
            this.setDisplayAction(1);
        } else if (VALUE_ACTION_ORIGINAL.equals(action)) {
            this.setDisplayAction(2);
        } else {
            this.setDisplayAction(0);
        }
        this.calculatePageData();
    }

    public void setConfiguration(CmsPhotoAlbumConfiguration configuration) {
        this.m_configuration = configuration;
    }

    public void setStyle(CmsPhotoAlbumStyle style) {
        this.m_style = style;
    }

    protected void addConfigError(String configError) {
        this.m_configErrors.add(configError);
    }

    protected String buildHtmlAlbumTitle() {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getConfiguration().getAlbumTitle())) {
            StringBuffer result = new StringBuffer(128);
            result.append("<h1");
            result.append(this.getStyle().getClassPageTitle());
            result.append(">");
            result.append(this.getConfiguration().getAlbumTitle());
            result.append("</h1>\n");
            return result.toString();
        }
        return "";
    }

    protected void buildHtmlConfigurationErrors() throws IOException {
        if (!this.getRequestContext().currentProject().isOnlineProject() && this.getConfigErrors().size() > 0) {
            this.getJspContext().getOut().print("<h1>");
            this.getJspContext().getOut().print(this.m_messages.key("GUI_CONFIG_ERRORS_HEADLINE_0"));
            this.getJspContext().getOut().print("</h1>");
            this.getJspContext().getOut().print("<p>");
            for (int i = 0; i < this.getConfigErrors().size(); ++i) {
                if (i > 0) {
                    this.getJspContext().getOut().println("<br />");
                }
                this.getJspContext().getOut().print(this.getConfigErrors().get(i));
            }
            this.getJspContext().getOut().print("</p>");
        }
    }

    protected String buildHtmlImageNavigation(String currentNavigationPosition, int photoIndex, CmsResource photo) {
        if (!this.checkNavigationPosition(currentNavigationPosition)) {
            return "";
        }
        StringBuffer result = new StringBuffer(1024);
        StringBuffer link = new StringBuffer(256);
        result.append("<tr>\n\t<td");
        result.append(this.getStyle().getClassNavigation());
        result.append(this.getConfiguration().getStyleAlignAttribute(this.getConfiguration().getAlignNavigation()));
        result.append(">");
        if (photoIndex > 0) {
            result.append("<a");
            result.append(this.getStyle().getClassLink());
            result.append(" href=\"");
            link.append(this.getRequestContext().getUri());
            link.append("?");
            link.append(PARAM_ACTION).append("=").append(VALUE_ACTION_DETAIL);
            link.append("&amp;");
            link.append(PARAM_IMAGE).append("=").append(photoIndex - 1);
            result.append(this.link(link.toString()));
            result.append("\">");
            result.append(this.m_messages.key("GUI_NAVIGATION_BACK_0"));
            result.append("</a>");
            result.append(" - ");
        } else {
            result.append(this.fillNavSpaces(this.m_messages.key("GUI_NAVIGATION_BACK_0") + " - "));
        }
        Object[] args = new Object[]{new Integer(photoIndex + 1), new Integer(this.getAlbumPhotos().size())};
        result.append(this.m_messages.key("GUI_DETAIL_IMAGEINFO_2", args));
        if (photoIndex < this.getAlbumPhotos().size() - 1) {
            result.append(" - ");
            result.append("<a");
            result.append(this.getStyle().getClassLink());
            result.append(" href=\"");
            link = new StringBuffer(256);
            link.append(this.getRequestContext().getUri());
            link.append("?");
            link.append(PARAM_ACTION).append("=").append(VALUE_ACTION_DETAIL);
            link.append("&amp;");
            link.append(PARAM_IMAGE).append("=").append(photoIndex + 1);
            result.append(this.link(link.toString()));
            result.append("\">");
            result.append(this.m_messages.key("GUI_NAVIGATION_NEXT_0"));
            result.append("</a>");
        } else {
            result.append(this.fillNavSpaces(" - " + this.m_messages.key("GUI_NAVIGATION_NEXT_0")));
        }
        result.append("<br />");
        int thumbPage = 1;
        if (this.getConfiguration().showPageNavigation()) {
            thumbPage = photoIndex / this.getPhotosPerPage() + 1;
        }
        result.append("<a");
        result.append(this.getStyle().getClassLink());
        result.append(" href=\"");
        link = new StringBuffer(256);
        link.append(this.getRequestContext().getUri());
        link.append("?");
        link.append(PARAM_ACTION).append("=").append(VALUE_ACTION_THUMBNAIL);
        link.append("&amp;");
        link.append(PARAM_PAGE).append("=").append(thumbPage);
        result.append(this.link(link.toString()));
        result.append("\">");
        result.append(this.m_messages.key("GUI_NAVIGATION_OVERVIEW_0"));
        result.append("</a>");
        if (this.getConfiguration().showDetailOriginalLink()) {
            result.append(" - <a");
            result.append(this.getStyle().getClassLink());
            result.append(" href=\"");
            result.append(this.link(this.getCmsObject().getSitePath(photo)));
            result.append("\" target=\"originalphoto\">");
            result.append(this.m_messages.key("GUI_NAVIGATION_ORIGINAL_0"));
            result.append("</a>");
        }
        result.append("</td>\n</tr>\n");
        return result.toString();
    }

    protected String buildHtmlPageNavigation(String currentNavigationPosition) {
        if (!this.checkNavigationPosition(currentNavigationPosition)) {
            return "";
        }
        StringBuffer result = new StringBuffer(1024);
        if (this.getConfiguration().showPageNavigation() && this.getPageCount() > 1) {
            result.append("<tr>\n\t<td colspan=\"");
            result.append(this.getConfiguration().getThumbCols());
            result.append("\"");
            result.append(this.getStyle().getClassNavigation());
            result.append(this.getConfiguration().getStyleAlignAttribute(this.getConfiguration().getAlignNavigation()));
            result.append(">");
            StringBuffer link = new StringBuffer(256);
            if (this.getCurrentPage() > 1) {
                result.append("<a");
                result.append(this.getStyle().getClassLink());
                result.append(" href=\"");
                link.append(this.getRequestContext().getUri());
                link.append("?");
                link.append(PARAM_ACTION).append("=").append(VALUE_ACTION_THUMBNAIL);
                link.append("&amp;");
                link.append(PARAM_PAGE).append("=").append(this.getCurrentPage() - 1);
                result.append(this.link(link.toString()));
                result.append("\">");
                result.append(this.m_messages.key("GUI_NAVIGATION_BACK_0"));
                result.append("</a>");
                result.append(" - ");
            } else {
                result.append(this.fillNavSpaces(this.m_messages.key("GUI_NAVIGATION_BACK_0") + " - "));
            }
            result.append(this.m_messages.key("GUI_THUMB_PAGEINFO_2", (Object)new Integer(this.getCurrentPage()), (Object)new Integer(this.getPageCount())));
            if (this.getCurrentPage() < this.getPageCount()) {
                result.append(" - ");
                result.append("<a class=\"");
                result.append(this.getStyle().getClassLink());
                result.append("\" href=\"");
                link = new StringBuffer(256);
                link.append(this.getRequestContext().getUri());
                link.append("?");
                link.append(PARAM_ACTION).append("=").append(VALUE_ACTION_THUMBNAIL);
                link.append("&amp;");
                link.append(PARAM_PAGE).append("=").append(this.getCurrentPage() + 1);
                result.append(this.link(link.toString()));
                result.append("\">");
                result.append(this.m_messages.key("GUI_NAVIGATION_NEXT_0"));
                result.append("</a>");
            } else {
                result.append(this.fillNavSpaces(" - " + this.m_messages.key("GUI_NAVIGATION_NEXT_0")));
            }
            result.append("</td>\n</tr>\n");
        }
        return result.toString();
    }

    protected String buildHtmlThumbTextRow(String text) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)text)) {
            StringBuffer result = new StringBuffer(2048);
            result.append("<tr>\n\t<td colspan=\"");
            result.append(this.getConfiguration().getThumbCols());
            result.append("\"");
            result.append(this.getStyle().getClassThumbText());
            result.append(">");
            result.append(text);
            result.append("</td>\n</tr>\n");
            return result.toString();
        }
        return "";
    }

    protected String buildHtmlViewDetail() {
        String description;
        StringBuffer result = new StringBuffer(4096);
        result.append(this.buildHtmlAlbumTitle());
        String indexParam = this.getRequest().getParameter(PARAM_IMAGE);
        int photoIndex = 0;
        if (CmsStringUtil.isNotEmpty((String)indexParam) && (photoIndex = Integer.parseInt(indexParam)) > this.getAlbumPhotos().size() - 1) {
            photoIndex = this.getAlbumPhotos().size() - 1;
        }
        CmsResource photo = (CmsResource)this.getAlbumPhotos().get(photoIndex);
        String resourceName = this.getCmsObject().getSitePath(photo);
        String title = "";
        if (this.getConfiguration().showResourceNameAsTitle()) {
            title = CmsResource.getName((String)resourceName);
        }
        title = this.property("Title", resourceName, title);
        title = CmsEncoder.escapeXml((String)title);
        result.append("<table border=\"0\"");
        result.append(this.getStyle().getClassThumbTable());
        result.append(" width=\"");
        result.append(this.getConfiguration().getDetailImageScaler().getWidth());
        result.append("\">\n");
        result.append(this.buildHtmlImageNavigation("t_a", photoIndex, photo));
        if (this.getConfiguration().showDetailTitle() && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)title)) {
            result.append("<tr>\n\t<td");
            result.append(this.getStyle().getClassDetailImageTitle());
            result.append(this.getConfiguration().getStyleAlignAttribute(this.getConfiguration().getDetailAlignTitle()));
            result.append(">");
            result.append(title);
            result.append("</td>\n</tr>\n");
        }
        result.append(this.buildHtmlImageNavigation("t_b", photoIndex, photo));
        result.append("<tr>\n\t<td>");
        result.append("<img src=\"");
        StringBuffer link = new StringBuffer(256);
        link.append(resourceName);
        link.append(this.getConfiguration().getDetailImageScaler().toRequestParam());
        result.append(this.link(link.toString()));
        result.append("\" border=\"0\" width=\"");
        result.append(this.getConfiguration().getDetailImageScaler().getWidth());
        result.append("\" height=\"");
        result.append(this.getConfiguration().getDetailImageScaler().getHeight());
        result.append("\" alt=\"");
        result.append(title);
        result.append("\" title=\"");
        result.append(title);
        result.append("\" />");
        result.append("</td>\n</tr>\n");
        result.append(this.buildHtmlImageNavigation("b_a", photoIndex, photo));
        if (this.getConfiguration().showDetailDescription() && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(description = this.property("Description", resourceName, "")))) {
            result.append("<tr>\n\t<td");
            result.append(this.getStyle().getClassDetailImageDescription());
            result.append(this.getConfiguration().getStyleAlignAttribute(this.getConfiguration().getDetailAlignTitle()));
            result.append(">");
            result.append(description);
            result.append("</td>\n</tr>\n");
        }
        result.append(this.buildHtmlImageNavigation("b_b", photoIndex, photo));
        result.append("</table>");
        return result.toString();
    }

    protected String buildHtmlViewThumbNail() {
        StringBuffer result = new StringBuffer(4096);
        int startIndex = (this.getCurrentPage() - 1) * this.getPhotosPerPage();
        int endIndex = 0;
        int rowCount = this.getConfiguration().getThumbRows();
        if (this.getConfiguration().showPageNavigation()) {
            endIndex = this.getCurrentPage() * this.getPhotosPerPage() - 1;
            if (endIndex > this.getAlbumPhotos().size() - 1) {
                endIndex = this.getAlbumPhotos().size() - 1;
            }
        } else {
            endIndex = this.getAlbumPhotos().size() - 1;
        }
        int photoCount = endIndex - startIndex + 1;
        rowCount = photoCount / this.getConfiguration().getThumbCols();
        if (photoCount % this.getConfiguration().getThumbCols() > 0) {
            ++rowCount;
        }
        result.append(this.buildHtmlAlbumTitle());
        result.append("<table border=\"0\"");
        result.append(this.getStyle().getClassThumbTable());
        result.append(" width=\"");
        result.append(this.getConfiguration().getThumbCols() * this.getConfiguration().getThumbNailScaler().getWidth());
        result.append("\">\n");
        result.append(this.buildHtmlPageNavigation("t_a"));
        result.append(this.buildHtmlThumbTextRow(this.getConfiguration().getThumbTextTop()));
        result.append(this.buildHtmlPageNavigation("t_b"));
        String styleAttr = this.getConfiguration().getStyleAlignAttribute(this.getConfiguration().getThumbAlignTitle());
        int photoIndex = startIndex;
        for (int i = 1; i <= rowCount; ++i) {
            result.append("<tr>\n");
            for (int k = 1; k <= this.getConfiguration().getThumbCols(); ++k) {
                result.append("\t<td width=\"");
                result.append(this.getConfiguration().getThumbNailScaler().getWidth());
                result.append("\"");
                result.append(this.getStyle().getClassThumbImageTitle());
                result.append(styleAttr);
                result.append(">");
                if (photoIndex <= endIndex) {
                    CmsResource photo = (CmsResource)this.getAlbumPhotos().get(photoIndex);
                    String resourceName = this.getCmsObject().getSitePath(photo);
                    String title = "";
                    if (this.getConfiguration().showResourceNameAsTitle()) {
                        title = CmsResource.getName((String)resourceName);
                    }
                    title = this.property("Title", resourceName, title);
                    title = CmsEncoder.escapeXml((String)title);
                    result.append("<a href=\"");
                    StringBuffer link = new StringBuffer(256);
                    link.append(this.getRequestContext().getUri());
                    link.append("?");
                    link.append(PARAM_ACTION).append("=").append(VALUE_ACTION_DETAIL);
                    link.append("&amp;").append(PARAM_IMAGE).append("=").append(photoIndex);
                    result.append(this.link(link.toString()));
                    result.append("\">");
                    result.append("<img src=\"");
                    link = new StringBuffer(256);
                    link.append(resourceName);
                    link.append(this.getConfiguration().getThumbNailScaler().toRequestParam());
                    result.append(this.link(link.toString()));
                    result.append("\" border=\"0\" width=\"");
                    result.append(this.getConfiguration().getThumbNailScaler().getWidth());
                    result.append("\" height=\"");
                    result.append(this.getConfiguration().getThumbNailScaler().getHeight());
                    result.append("\" alt=\"");
                    result.append(title);
                    result.append("\" title=\"");
                    result.append(title);
                    result.append("\" />");
                    result.append("</a>");
                    if (this.getConfiguration().showThumbTitle() && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)title)) {
                        result.append("<br clear=\"all\" /><span");
                        result.append(this.getStyle().getClassThumbImageTitle());
                        result.append(">");
                        result.append(title);
                        result.append("</span>");
                    }
                    ++photoIndex;
                }
                result.append("</td>\n");
            }
            result.append("</tr>\n");
        }
        result.append(this.buildHtmlPageNavigation("b_a"));
        result.append(this.buildHtmlThumbTextRow(this.getConfiguration().getThumbTextBottom()));
        result.append(this.buildHtmlPageNavigation("b_b"));
        result.append("</table>");
        return result.toString();
    }

    protected void calculatePageData() {
        if (this.getConfiguration().showPageNavigation()) {
            this.setPhotosPerPage(this.getConfiguration().getThumbCols() * this.getConfiguration().getThumbRows());
            int pageCount = this.getAlbumPhotos().size() / this.getPhotosPerPage();
            if (this.getAlbumPhotos().size() % this.getPhotosPerPage() != 0) {
                ++pageCount;
            }
            this.setPageCount(pageCount);
            String page = this.getRequest().getParameter(PARAM_PAGE);
            if (CmsStringUtil.isNotEmpty((String)page) && this.getPageCount() > 1) {
                int currentPage = Integer.parseInt(page);
                if (currentPage > this.getPageCount()) {
                    currentPage = this.getPageCount();
                }
                this.setCurrentPage(currentPage);
            } else {
                this.setCurrentPage(1);
            }
        } else {
            this.setPhotosPerPage(0);
            this.setPageCount(1);
            this.setCurrentPage(1);
        }
    }

    protected boolean checkNavigationPosition(String currentPosition) {
        return this.getConfiguration().getNavigationPosition().indexOf(currentPosition) > -1;
    }

    protected String fillNavSpaces(String replaceValue) {
        int centerIndex = this.getConfiguration().getAlignNavigation().indexOf("center");
        if (centerIndex > -1 && CmsStringUtil.isNotEmpty((String)replaceValue)) {
            int length = replaceValue.length();
            StringBuffer result = new StringBuffer(6 * length);
            for (int i = 0; i < length; ++i) {
                result.append("&nbsp;");
            }
            return result.toString();
        }
        return "";
    }

    protected List getConfigErrors() {
        return this.m_configErrors;
    }

    protected void setConfigErrors(List configErrors) {
        this.m_configErrors = configErrors;
    }

    protected void setCurrentPage(int currentPage) {
        this.m_currentPage = currentPage;
    }

    protected void setDisplayAction(int displayAction) {
        this.m_displayAction = displayAction;
    }

    protected void setPageCount(int pageCount) {
        this.m_pageCount = pageCount;
    }

    protected void setPhotosPerPage(int photosPerPage) {
        this.m_photosPerPage = photosPerPage;
    }
}

