/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsReport;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsDialogElement;
import org.opencms.workplace.explorer.CmsNewResourceXmlPage;
import org.opencms.workplace.tools.content.CmsElementRenameThread;
import org.opencms.workplace.tools.content.Messages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;
import org.opencms.xml.types.CmsXmlHtmlValue;

public class CmsElementRename
extends CmsReport {
    public static final String ALL = "ALL";
    public static final String DIALOG_TYPE = "renameelement";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_NEW_ELEMENT = "newelement";
    public static final String PARAM_OLD_ELEMENT = "oldelement";
    public static final String PARAM_RECURSIVE = "recursive";
    public static final String PARAM_REMOVE_EMPTYELEMENTS = "removeemptyelements";
    public static final String PARAM_TEMPLATE = "template";
    public static final String PARAM_VALIDATE_NEW_ELEMENT = "validatenewelement";
    private static final Log LOG = CmsLog.getLog((Object)CmsElementRename.class);
    private CmsObject m_cms;
    private String m_errorMessage;
    private String m_paramLocale;
    private String m_paramNewElement;
    private String m_paramOldElement;
    private String m_paramRecursive;
    private String m_paramRemoveEmptyElements;
    private String m_paramTemplate;
    private String m_paramValidateNewElement;
    private I_CmsReport m_report;

    public CmsElementRename(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsElementRename(CmsJspActionElement jsp, CmsObject cms, String resource, String recursive, String template, String locale, String oldElement, String newElement, String removeEmptyElements, String validateNewElement) {
        super(jsp);
        this.m_cms = cms;
        this.setParamResource(resource);
        this.setParamRecursive(recursive);
        this.setParamTemplate(template);
        this.setParamLocale(locale);
        this.setParamOldElement(oldElement);
        this.setParamNewElement(newElement);
        this.setParamRemoveEmptyElements(removeEmptyElements);
        this.setParamValidateNewElement(validateNewElement);
    }

    public CmsElementRename(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionRename(I_CmsReport report) {
        this.m_report = report;
        List locales = OpenCms.getLocaleManager().getAvailableLocales();
        List xmlPages = this.getXmlPages();
        if (ALL.equals(this.getParamLocale())) {
            Iterator i = locales.iterator();
            while (i.hasNext()) {
                Locale locale = (Locale)i.next();
                this.performRenameOperation(xmlPages, locale);
            }
        } else {
            this.performRenameOperation(xmlPages, CmsLocaleManager.getLocale((String)this.getParamLocale()));
        }
    }

    public void actionReport() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        switch (this.getAction()) {
            case 92: {
                this.actionCloseDialog();
                break;
            }
            case 91: {
                this.setParamAction("reportupdate");
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
                break;
            }
            default: {
                CmsElementRenameThread thread = new CmsElementRenameThread(this.getCms(), this);
                thread.start();
                this.setParamAction("reportbegin");
                this.setParamThread(thread.getUUID().toString());
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
            }
        }
    }

    public String buildSelectLocales(String attributes) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        List locales = OpenCms.getLocaleManager().getAvailableLocales();
        int selectedIndex = -1;
        if (locales == null) {
            return "";
        }
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        options.add(messages.key("GUI_PLEASE_SELECT_0"));
        values.add("");
        options.add(messages.key("GUI_BUTTON_ALL_0"));
        values.add(ALL);
        if (ALL.equals(this.getParamLocale())) {
            selectedIndex = 1;
        }
        Iterator i = locales.iterator();
        int counter = 2;
        while (i.hasNext()) {
            Locale locale = (Locale)i.next();
            String language = locale.getLanguage();
            String displayLanguage = locale.getDisplayLanguage();
            if (language.equals(this.getParamLocale())) {
                selectedIndex = counter;
            }
            options.add(displayLanguage);
            values.add(language);
            ++counter;
        }
        return CmsWorkplace.buildSelect((String)attributes, options, values, (int)selectedIndex, (boolean)false);
    }

    public String buildSelectTemplates(String attributes) {
        int selectedIndex;
        TreeMap templates;
        ArrayList<String> values;
        ArrayList<String> options;
        block6: {
            options = new ArrayList<String>();
            values = new ArrayList<String>();
            templates = null;
            selectedIndex = -1;
            try {
                templates = CmsNewResourceXmlPage.getTemplates((CmsObject)this.getCms(), null);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.info((Object)e);
            }
        }
        if (templates == null) {
            return "";
        }
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        options.add(messages.key("GUI_PLEASE_SELECT_0"));
        values.add("");
        options.add(messages.key("GUI_BUTTON_ALL_0"));
        values.add(ALL);
        if (ALL.equals(this.getParamTemplate())) {
            selectedIndex = 1;
        }
        Iterator i = templates.entrySet().iterator();
        int counter = 2;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String path = (String)entry.getValue();
            if (path.equals(this.getParamTemplate())) {
                selectedIndex = counter;
            }
            options.add(key);
            values.add(path);
            ++counter;
        }
        return CmsElementRename.buildSelect((String)attributes, options, values, (int)selectedIndex, (boolean)false);
    }

    public CmsObject getCms() {
        if (this.m_cms == null) {
            return super.getCms();
        }
        return this.m_cms;
    }

    public String getErrorMessage() {
        if (CmsStringUtil.isEmpty((String)this.m_errorMessage)) {
            return "";
        }
        return this.m_errorMessage;
    }

    public String getParamLocale() {
        return this.m_paramLocale;
    }

    public String getParamNewElement() {
        return this.m_paramNewElement;
    }

    public String getParamOldElement() {
        return this.m_paramOldElement;
    }

    public String getParamRecursive() {
        return this.m_paramRecursive;
    }

    public String getParamRemoveEmptyElements() {
        return this.m_paramRemoveEmptyElements;
    }

    public String getParamTemplate() {
        return this.m_paramTemplate;
    }

    public String getParamValidateNewElement() {
        return this.m_paramValidateNewElement;
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public void setParamLocale(String paramLocale) {
        this.m_paramLocale = paramLocale;
    }

    public void setParamNewElement(String paramNewValue) {
        this.m_paramNewElement = paramNewValue;
    }

    public void setParamOldElement(String paramOldValue) {
        this.m_paramOldElement = paramOldValue;
    }

    public void setParamRecursive(String paramRecursive) {
        this.m_paramRecursive = paramRecursive;
    }

    public void setParamRemoveEmptyElements(String paramRemoveEmptyElements) {
        this.m_paramRemoveEmptyElements = paramRemoveEmptyElements;
    }

    public void setParamTemplate(String paramTemplate) {
        this.m_paramTemplate = paramTemplate;
    }

    public void setParamValidateNewElement(String paramValidateNewElement) {
        this.m_paramValidateNewElement = paramValidateNewElement;
    }

    public void validateParameters() {
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        StringBuffer validationErrors = new StringBuffer();
        if (CmsStringUtil.isEmpty((String)this.getParamResource())) {
            validationErrors.append(messages.key("GUI_ELEM_RENAME_VALIDATE_RESOURCE_FOLDER_0")).append("<br>");
        }
        if (CmsStringUtil.isEmpty((String)this.getParamTemplate())) {
            validationErrors.append(messages.key("GUI_ELEM_RENAME_VALIDATE_SELECT_TEMPLATE_0")).append("<br>");
        }
        if (CmsStringUtil.isEmpty((String)this.getParamLocale())) {
            validationErrors.append(messages.key("GUI_ELEM_RENAME_VALIDATE_SELECT_LANGUAGE_0")).append("<br>");
        }
        if (CmsStringUtil.isEmpty((String)this.getParamOldElement())) {
            validationErrors.append(messages.key("GUI_ELEM_RENAME_VALIDATE_ENTER_OLD_ELEM_0")).append("<br>");
        }
        if (CmsStringUtil.isEmpty((String)this.getParamNewElement())) {
            validationErrors.append(messages.key("GUI_ELEM_RENAME_VALIDATE_ENTER_NEW_ELEM_0")).append("<br>");
        }
        if (!this.isValidElement(this.getParamNewElement())) {
            validationErrors.append(messages.key("GUI_ELEM_RENAME_VALIDATE_INVALID_NEW_ELEM_2", (Object)this.getParamNewElement(), (Object)this.getParamTemplate())).append("<br>");
        }
        this.setErrorMessage(validationErrors.toString());
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if ("confirmed".equals(this.getParamAction())) {
            this.setAction(1);
        } else if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if ("reportupdate".equals(this.getParamAction())) {
            this.setAction(91);
        } else if ("reportbegin".equals(this.getParamAction())) {
            this.setAction(90);
        } else if ("reportend".equals(this.getParamAction())) {
            this.setAction(92);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("title.renameelement"));
        }
    }

    private List getRetainedPagesWithTemplate(List xmlPages) {
        TreeMap templates;
        ArrayList<CmsResource> resourcesWithTemplate;
        block6: {
            resourcesWithTemplate = new ArrayList<CmsResource>();
            templates = null;
            try {
                templates = CmsNewResourceXmlPage.getTemplates((CmsObject)this.getCms(), null);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (templates != null && templates.containsValue(this.getParamTemplate())) {
            Iterator i = xmlPages.iterator();
            while (i.hasNext()) {
                CmsProperty templateProperty;
                CmsResource currentPage = (CmsResource)i.next();
                try {
                    templateProperty = this.getCms().readPropertyObject(this.getCms().getSitePath(currentPage), PARAM_TEMPLATE, false);
                }
                catch (CmsException e2) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e2);
                    continue;
                }
                if (!this.getParamTemplate().equals(templateProperty.getValue())) continue;
                resourcesWithTemplate.add(currentPage);
            }
            xmlPages.retainAll(resourcesWithTemplate);
        }
        return xmlPages;
    }

    private Set getTemplateElements(String currentTemplate) {
        HashSet<CmsDialogElement> templateElements = new HashSet<CmsDialogElement>();
        if (currentTemplate != null && currentTemplate.length() > 0) {
            String elements;
            block7: {
                elements = null;
                try {
                    elements = this.getCms().readPropertyObject(currentTemplate, "template-elements", false).getValue(null);
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn((Object)e.getLocalizedMessage());
                }
            }
            if (elements != null) {
                StringTokenizer T = new StringTokenizer(elements, ",");
                while (T.hasMoreTokens()) {
                    String currentElement = T.nextToken();
                    String niceName = null;
                    boolean mandatory = false;
                    int sepIndex = currentElement.indexOf("|");
                    if (sepIndex != -1) {
                        niceName = currentElement.substring(sepIndex + 1);
                        currentElement = currentElement.substring(0, sepIndex);
                    }
                    if (currentElement.endsWith("*")) {
                        mandatory = true;
                        currentElement = currentElement.substring(0, currentElement.length() - 1);
                    }
                    CmsDialogElement element = new CmsDialogElement(currentElement, niceName, mandatory, true, false);
                    templateElements.add(element);
                }
            }
        }
        return templateElements;
    }

    private List getXmlPages() {
        List xmlPages;
        block2: {
            boolean isRecursive = Boolean.valueOf(this.getParamRecursive());
            CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(CmsResourceTypeXmlPage.getStaticTypeId());
            xmlPages = null;
            try {
                xmlPages = this.getCms().readResources(this.getParamResource(), filter, isRecursive);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return xmlPages;
    }

    private boolean isEmptyElement(CmsXmlPage page, String element, Locale locale) {
        CmsXmlHtmlValue xmlHtmlValue = (CmsXmlHtmlValue)page.getValue(element, locale);
        return !CmsStringUtil.isNotEmpty((String)xmlHtmlValue.getPlainText(this.getCms()));
    }

    private boolean isValidElement(CmsXmlPage page, String element) {
        String template;
        CmsFile file = page.getFile();
        try {
            template = this.getCms().readPropertyObject(this.getCms().getSitePath((CmsResource)file), PARAM_TEMPLATE, true).getValue(null);
        }
        catch (CmsException e) {
            return false;
        }
        return this.isValidTemplateElement(template, element);
    }

    private boolean isValidElement(String element) {
        boolean validateNewElement = Boolean.valueOf(this.getParamValidateNewElement());
        if (ALL.equals(this.getParamTemplate()) || !validateNewElement) {
            return true;
        }
        return this.isValidTemplateElement(this.getParamTemplate(), element);
    }

    private boolean isValidTemplateElement(String template, String element) {
        ArrayList elements = new ArrayList(this.getTemplateElements(template));
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            CmsDialogElement currElement = (CmsDialogElement)i.next();
            if (!element.equals(currElement.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRenameOperation(List xmlPages, Locale locale) {
        boolean removeEmptyElements = Boolean.valueOf(this.getParamRemoveEmptyElements());
        boolean validateNewElement = Boolean.valueOf(this.getParamValidateNewElement());
        if (xmlPages != null && xmlPages.size() > 0) {
            this.m_report.println(Messages.get().container("RPT_RENAME_LANG_1", (Object)locale.getLanguage()), 2);
            if (!ALL.equals(this.getParamTemplate())) {
                xmlPages = this.getRetainedPagesWithTemplate(xmlPages);
            }
            int m = 0;
            int n = xmlPages.size();
            Iterator i = xmlPages.iterator();
            while (i.hasNext()) {
                CmsXmlPage page;
                block22: {
                    block21: {
                        block20: {
                            CmsFile file;
                            ++m;
                            page = null;
                            CmsResource res = (CmsResource)i.next();
                            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)String.valueOf(m), (Object)String.valueOf(n)), 3);
                            this.m_report.print(Messages.get().container("RPT_PROCESSING_PAGE_0"), 3);
                            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)this.getCms().getSitePath(res)));
                            this.m_report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                            try {
                                file = this.getCms().readFile(this.getCms().getSitePath(res), CmsResourceFilter.IGNORE_EXPIRATION);
                            }
                            catch (CmsException e2) {
                                if (LOG.isErrorEnabled()) {
                                    LOG.error((Object)e2);
                                }
                                this.m_report.println((Throwable)e2);
                                if (!removeEmptyElements) continue;
                                this.removeInValidElements(page, locale);
                                continue;
                            }
                            try {
                                page = CmsXmlPageFactory.unmarshal((CmsObject)this.getCms(), (CmsFile)file);
                            }
                            catch (CmsXmlException e) {
                                this.m_report.println((Throwable)e);
                                if (!removeEmptyElements) continue;
                                this.removeInValidElements(page, locale);
                                continue;
                            }
                            if (page.hasValue(this.getParamOldElement(), locale)) break block20;
                            this.m_report.println(Messages.get().container("RPT_NONEXISTANT_ELEM_1", (Object)this.getParamOldElement()), 3);
                            if (!removeEmptyElements) continue;
                            this.removeInValidElements(page, locale);
                            continue;
                        }
                        if (!page.hasValue(this.getParamNewElement(), locale)) break block21;
                        this.m_report.println(Messages.get().container("RPT_NEW_ELEM_EXISTS_0"), 3);
                        if (!removeEmptyElements) continue;
                        this.removeInValidElements(page, locale);
                        continue;
                    }
                    if (!validateNewElement || this.isValidElement(page, this.getParamNewElement())) break block22;
                    this.m_report.println(Messages.get().container("RPT_INVALID_ARGUMENT_1", (Object)this.getParamNewElement()), 3);
                    if (!removeEmptyElements) continue;
                    this.removeInValidElements(page, locale);
                    continue;
                }
                try {
                    try {
                        page.renameValue(this.getParamOldElement(), this.getParamNewElement(), locale);
                        this.writePageAndReport(page, true);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)t);
                        this.m_report.println(t);
                        if (!removeEmptyElements) continue;
                        this.removeInValidElements(page, locale);
                        continue;
                    }
                    if (!removeEmptyElements) continue;
                    this.removeInValidElements(page, locale);
                }
                catch (Throwable t) {
                    try {
                        LOG.error((Object)t);
                        this.m_report.println(t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (!removeEmptyElements) continue;
                        this.removeInValidElements(page, locale);
                    }
                }
            }
        }
    }

    private void removeInValidElements(CmsXmlPage page, Locale locale) {
        if (page == null) {
            return;
        }
        if (ALL.equals(this.getParamTemplate())) {
            return;
        }
        List pageElements = page.getNames(locale);
        if (pageElements != null) {
            Iterator i = pageElements.iterator();
            while (i.hasNext()) {
                String currElement = (String)i.next();
                if (this.isValidElement(currElement) || !this.isEmptyElement(page, currElement, locale)) continue;
                page.removeValue(currElement, locale);
                try {
                    this.writePageAndReport(page, false);
                    this.m_report.println(Messages.get().container("RPT_REMOVE_INVALID_EMPTY_ELEM_1", (Object)currElement), 3);
                }
                catch (CmsException e) {}
            }
        }
    }

    private void writePageAndReport(CmsXmlPage page, boolean report) throws CmsException {
        CmsFile file = page.getFile();
        byte[] content = page.marshal();
        file.setContents(content);
        CmsLock lock = this.getCms().getLock((CmsResource)file);
        if (lock.isNullLock() || lock.isOwnedBy(this.getCms().getRequestContext().currentUser())) {
            this.checkLock(this.getCms().getSitePath((CmsResource)file));
            this.getCms().writeFile(file);
            this.getCms().unlockResource(this.getCms().getSitePath((CmsResource)file));
            if (report) {
                this.m_report.println(Messages.get().container("RPT_ELEM_RENAME_2", (Object)this.getParamOldElement(), (Object)this.getParamNewElement()), 4);
            }
        }
    }
}

