/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsException;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.content.CmsPropertyChange;
import org.opencms.workplace.tools.content.Messages;

public class CmsPropertyDelete
extends CmsDialog {
    public static final int ACTION_DELETE_CASCADE = 100;
    public static final String DIALOG_DELETE_CASCADE = "deletecascade";
    public static final String DIALOG_TYPE = "propertydelete";
    public static final String PARAM_PROPERTYNAME = "propertyname";
    private String m_paramPropertyName;

    public CmsPropertyDelete(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPropertyDelete(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionDelete() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            this.getCms().deletePropertyDefinition(this.getParamPropertyName());
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionDeleteCascade() throws JspException {
        block8: {
            this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
            try {
                List resourcesWithProperty = this.getCms().readResourcesWithProperty(this.getParamPropertyName());
                List resourcesLockedByOtherUser = this.getResourcesLockedByOtherUser(resourcesWithProperty);
                if (resourcesLockedByOtherUser.isEmpty()) {
                    String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                    try {
                        this.getCms().getRequestContext().setSiteRoot("/");
                        Iterator i = resourcesWithProperty.iterator();
                        while (i.hasNext()) {
                            CmsResource resource = (CmsResource)i.next();
                            CmsProperty property = this.getCms().readPropertyObject(resource.getRootPath(), this.getParamPropertyName(), false);
                            if (property.isNullProperty()) continue;
                            CmsLock lock = this.getCms().getLock(resource);
                            if (lock.isUnlocked()) {
                                this.getCms().lockResource(resource.getRootPath());
                            }
                            property.setStructureValue("");
                            property.setResourceValue("");
                            this.getCms().writePropertyObject(resource.getRootPath(), property);
                            this.getCms().unlockResource(resource.getRootPath());
                        }
                        this.getCms().deletePropertyDefinition(this.getParamPropertyName());
                        break block8;
                    }
                    finally {
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                        this.actionCloseDialog();
                    }
                }
                StringBuffer reason = new StringBuffer();
                reason.append(this.dialogWhiteBoxStart());
                reason.append(this.buildResourceList(resourcesLockedByOtherUser, true));
                reason.append(this.dialogWhiteBoxEnd());
                throw new CmsVfsException(Messages.get().container("ERR_DEL_PROP_RESOURCES_LOCKED_1", (Object)reason.toString()));
            }
            catch (Throwable e) {
                this.includeErrorpage((CmsWorkplace)this, e);
            }
        }
    }

    public String buildResourceList() throws CmsException {
        List resourcesWithProperty = this.getCms().readResourcesWithProperty(this.getParamPropertyName());
        return this.buildResourceList(resourcesWithProperty, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildResourceList(List resourceList, boolean lockInfo) throws CmsException {
        Collections.reverse(resourceList);
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        StringBuffer result = new StringBuffer();
        result.append("<table border=\"0\" width=\"100%\" cellpadding=\"1\" cellspacing=\"1\">\n");
        result.append("<tr>\n");
        result.append("\t<td style=\"width:5%;\" class=\"textbold\">");
        result.append(messages.key("GUI_INPUT_TYPE_0"));
        result.append("</td>\n");
        result.append("\t<td style=\"width:40%;\" class=\"textbold\">");
        result.append(messages.key("GUI_INPUT_ADRESS_0"));
        result.append("</td>\n");
        result.append("\t<td style=\"width:25%;\" class=\"textbold\">");
        result.append(messages.key("GUI_INPUT_TITLE_0"));
        result.append("</td>\n");
        if (!lockInfo) {
            result.append("\t<td style=\"width:30%;\" class=\"textbold\">");
            result.append(messages.key("GUI_INPUT_PROPERTYVALUE_0"));
            result.append("</td>\n");
        }
        if (lockInfo) {
            result.append("\t<td style=\"width:30%;\" class=\"textbold\">");
            result.append(messages.key("GUI_EXPLORER_LOCKEDBY_0"));
            result.append("</td>\n");
            result.append("</tr>\n");
        }
        result.append("</tr>\n");
        result.append("<tr><td colspan=\"4\"><span style=\"height: 6px;\">&nbsp;</span></td></tr>\n");
        String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
        try {
            this.getCms().getRequestContext().setSiteRoot("/");
            Iterator i = resourceList.iterator();
            while (i.hasNext()) {
                CmsResource resource = (CmsResource)i.next();
                String filetype = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
                result.append("<tr>\n");
                result.append("\t<td>");
                result.append("<img src=\"");
                result.append(CmsPropertyDelete.getSkinUri());
                result.append("filetypes/");
                result.append(filetype);
                result.append(".gif\">");
                result.append("</td>\n");
                result.append("\t<td>");
                result.append(resource.getRootPath());
                result.append("</td>\n");
                result.append("\t<td>");
                result.append(this.getJsp().property("Title", resource.getRootPath(), ""));
                result.append("</td>\n");
                if (!lockInfo) {
                    result.append("\t<td>");
                    result.append(this.getJsp().property(this.getParamPropertyName(), resource.getRootPath()));
                    result.append("</td>\n");
                }
                if (lockInfo) {
                    CmsLock lock = this.getCms().getLock(resource);
                    result.append("\t<td>");
                    result.append(this.getCms().readUser(lock.getUserId()).getName());
                    result.append("</td>\n");
                }
                result.append("</tr>\n");
            }
            result.append("</table>\n");
        }
        finally {
            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
        }
        return result.toString();
    }

    public String buildSelectProperty(String attributes) {
        return CmsPropertyChange.buildSelectProperty(this.getCms(), Messages.get().getBundle(this.getLocale()).key("GUI_PLEASE_SELECT_0"), attributes, "");
    }

    public String getParamPropertyName() {
        return this.m_paramPropertyName;
    }

    public void setParamPropertyName(String paramPropertyName) {
        this.m_paramPropertyName = paramPropertyName;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
            this.setParamTitle(Messages.get().getBundle(this.getLocale()).key("GUI_TITLE_PROPERTYDELETE_0") + ": " + this.getParamPropertyName());
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if (DIALOG_DELETE_CASCADE.equals(this.getParamAction())) {
            this.setAction(100);
        } else {
            this.setAction(0);
            this.setParamTitle(Messages.get().getBundle(this.getLocale()).key("GUI_TITLE_PROPERTYDELETE_0"));
        }
    }

    private List getResourcesLockedByOtherUser(List resourceList) throws CmsException {
        ArrayList<CmsResource> lockedResourcesByOtherUser = new ArrayList<CmsResource>();
        Iterator i = resourceList.iterator();
        while (i.hasNext()) {
            CmsResource resource = (CmsResource)i.next();
            CmsLock lock = this.getCms().getLock(resource);
            if (lock.isUnlocked() || lock.isOwnedBy(this.getCms().getRequestContext().currentUser())) continue;
            lockedResourcesByOtherUser.add(resource);
        }
        return lockedResourcesByOtherUser;
    }
}

