/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.threads.CmsXmlContentRepairSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.content.Messages;

public class CmsXmlContentRepairDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "xmlcontentrepair";
    public static final String[] PAGES = new String[]{"page1"};
    protected static final String TYPE_XMLCONTENT = "xmlcontent";
    protected static final String XMLCONTENTREPAIR_ACTION_REPORT = "/system/workplace/admin/contenttools/reports/xmlcontentrepair.jsp";
    private CmsXmlContentRepairSettings m_settings;

    public CmsXmlContentRepairDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsXmlContentRepairDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList<CmsIllegalArgumentException> errors = new ArrayList<CmsIllegalArgumentException>();
        this.setDialogObject(this.m_settings);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("style", "new");
            params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/contenttools"));
            this.getToolManager().jspForwardPage((CmsWorkplace)this, XMLCONTENTREPAIR_ACTION_REPORT, params);
        }
        catch (CmsIllegalArgumentException e) {
            errors.add(e);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        result.append(this.createWidgetBlockStart(Messages.get().getBundle(this.getLocale()).key("GUI_XMLCONTENTREPAIR_DIALOG_BLOCK_SETTINGS_0")));
        result.append(this.createDialogRowsHtml(0, 3));
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initSettingsObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "vfsFolder", "/", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot()), 1, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "includeSubFolders", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget("")));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "force", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget("")));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "resourceType", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getXmlContentResourceTypes())));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initSettingsObject() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) ? new CmsXmlContentRepairSettings(this.getCms()) : this.getDialogObject();
        this.m_settings = o == null ? new CmsXmlContentRepairSettings(this.getCms()) : (CmsXmlContentRepairSettings)o;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_settings);
    }

    private List getXmlContentResourceTypes() {
        List resTypes = OpenCms.getResourceManager().getResourceTypes();
        Iterator i = resTypes.iterator();
        ArrayList<String> resTypeNames = new ArrayList<String>(resTypes.size());
        while (i.hasNext()) {
            I_CmsResourceType resType = (I_CmsResourceType)i.next();
            if (!(resType instanceof CmsResourceTypeXmlContent) || resType.getTypeName().equals(TYPE_XMLCONTENT)) continue;
            resTypeNames.add(resType.getTypeName());
        }
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>(resTypeNames.size() + 2);
        result.add(new CmsSelectWidgetOption("", true, this.key("GUI_XMLCONTENTREPAIR_DIALOG_RESTYPE_SELECT_0")));
        Collections.sort(resTypeNames);
        i = resTypeNames.iterator();
        while (i.hasNext()) {
            String resTypeName = (String)i.next();
            result.add(new CmsSelectWidgetOption(resTypeName));
        }
        result.add(new CmsSelectWidgetOption(TYPE_XMLCONTENT, false, this.key("GUI_XMLCONTENTREPAIR_DIALOG_RESTYPE_GENERIC_0")));
        return result;
    }
}

