/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content.check;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsFileUtil;
import org.opencms.workplace.tools.content.check.CmsContentCheckResource;
import org.opencms.workplace.tools.content.check.CmsContentCheckResult;
import org.opencms.workplace.tools.content.check.I_CmsContentCheck;
import org.opencms.workplace.tools.content.check.Messages;

public class CmsContentCheck {
    public static final String VFS_PATH_PLUGIN_FOLDER = "/system/workplace/admin/contenttools/check/plugin/";
    private static final Log LOG = CmsLog.getLog((Object)CmsContentCheck.class);
    private CmsObject m_cms;
    private List m_paths;
    private List m_plugins;
    private I_CmsReport m_report;
    private SortedMap m_resources;
    private CmsContentCheckResult m_result;

    public CmsContentCheck(CmsObject cms) {
        this.m_cms = cms;
        this.m_plugins = new ArrayList();
        this.m_paths = new ArrayList();
        this.m_result = new CmsContentCheckResult();
        try {
            this.init();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public List getPaths() {
        return this.m_paths;
    }

    public List getPlugins() {
        return this.m_plugins;
    }

    public int getPluginsCount() {
        return this.m_plugins.size();
    }

    public CmsContentCheckResult getResults() {
        return this.m_result;
    }

    public void setPaths(List paths) {
        this.m_paths = paths;
    }

    public void startContentCheck(CmsObject cms, I_CmsReport report) throws Exception {
        this.m_report = report;
        this.m_report.println(Messages.get().container("RPT_CONTENT_CHECK_BEGIN_0"), 2);
        this.m_report.print(Messages.get().container("RPT_CONTENT_COLLECT_BEGIN_0"), 2);
        this.m_report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 2);
        this.m_resources = this.collectResources(cms);
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 2);
        this.m_report.println(Messages.get().container("RPT_CONTENT_COLLECT_END_1", (Object)new Integer(this.m_resources.size())), 2);
        this.m_report.print(Messages.get().container("RPT_CONTENT_PROCESS_BEGIN_0"), 2);
        this.m_report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 2);
        int count = 1;
        Iterator i = this.m_resources.keySet().iterator();
        while (i.hasNext()) {
            List warnings;
            String resourceName = (String)i.next();
            CmsContentCheckResource res = (CmsContentCheckResource)this.m_resources.get(resourceName);
            boolean errorWarning = false;
            this.m_report.print(Messages.get().container("RPT_CONTENT_PROCESS_2", (Object)new Integer(count++), (Object)new Integer(this.m_resources.size())), 3);
            this.m_report.print(Messages.get().container("RPT_CONTENT_PROCESS_RESOURCE_1", (Object)res.getResourceName()), 0);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 3);
            Iterator j = this.getPlugins().iterator();
            while (j.hasNext()) {
                I_CmsContentCheck plugin = (I_CmsContentCheck)j.next();
                if (!plugin.isActive()) continue;
                try {
                    res = plugin.executeContentCheck(this.m_cms, res);
                }
                catch (CmsException e) {
                    errorWarning = true;
                    this.m_report.println(Messages.get().container("RPT_EMPTY_0"), 0);
                    this.m_report.print(Messages.get().container("RPT_CONTENT_PROCESS_ERROR_2", (Object)plugin.getName(), (Object)e), 5);
                }
            }
            List errors = res.getErrors();
            if (errors != null && errors.size() > 0) {
                errorWarning = true;
                this.m_report.println(Messages.get().container("RPT_EMPTY_0"), 0);
                this.m_report.println(Messages.get().container("RPT_CONTENT_PROCESS_ERROR_0"), 5);
                Iterator k = errors.iterator();
                while (k.hasNext()) {
                    String error = (String)k.next();
                    this.m_report.println(Messages.get().container("RPT_CONTENT_PROCESS_ERROR_1", (Object)error), 5);
                }
            }
            if ((warnings = res.getWarnings()) != null && warnings.size() > 0) {
                errorWarning = true;
                this.m_report.println(Messages.get().container("RPT_EMPTY_0"), 0);
                this.m_report.println(Messages.get().container("RPT_CONTENT_PROCESS_WARNING_0"), 1);
                Iterator k = warnings.iterator();
                while (k.hasNext()) {
                    String warning = (String)k.next();
                    this.m_report.println(Messages.get().container("RPT_CONTENT_PROCESS_WARNING_1", (Object)warning), 1);
                }
            }
            this.m_resources.put(resourceName, res);
            if (!errorWarning) {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                continue;
            }
            this.m_result.addResult(res);
        }
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 2);
        this.m_report.println(Messages.get().container("RPT_CONTENT_PROCESS_END_0"), 2);
        this.m_report.println(Messages.get().container("RPT_CONTENT_CHECK_END_0"), 2);
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("CmsContentCheck Paths=[");
        for (i = 0; i < this.m_paths.size(); ++i) {
            String path = (String)this.m_paths.get(i);
            buf.append(path);
            if (i >= this.m_paths.size() - 1) continue;
            buf.append(",");
        }
        buf.append("] Plugins=[");
        for (i = 0; i < this.m_plugins.size(); ++i) {
            I_CmsContentCheck plugin = (I_CmsContentCheck)this.m_plugins.get(i);
            buf.append(plugin.getName());
            buf.append(" (");
            buf.append(plugin.isActive());
            buf.append(")");
            if (i >= this.m_plugins.size() - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    private SortedMap collectResources(CmsObject cms) {
        TreeMap<String, CmsContentCheckResource> collectedResources = new TreeMap<String, CmsContentCheckResource>();
        Iterator i = CmsFileUtil.removeRedundancies((List)this.m_paths).iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            this.m_report.print(Messages.get().container("RPT_EXTRACT_FROM_PATH_BEGIN_1", (Object)path), 2);
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 2);
            try {
                List resources = cms.readResources(path, CmsResourceFilter.IGNORE_EXPIRATION, true);
                Iterator j = resources.iterator();
                while (j.hasNext()) {
                    CmsResource res = (CmsResource)j.next();
                    CmsContentCheckResource contentCheckRes = new CmsContentCheckResource(res);
                    collectedResources.put(contentCheckRes.getResourceName(), contentCheckRes);
                }
            }
            catch (CmsException e) {
                this.m_report.println(Messages.get().container("RPT_EXTRACT_FROM_PATH_ERROR_2", (Object)path, (Object)e), 5);
            }
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 2);
            this.m_report.println(Messages.get().container("RPT_EXTRACT_FROM_PATH_END_0"), 2);
        }
        return collectedResources;
    }

    private void init() throws CmsException {
        List resources = this.m_cms.readResourcesWithProperty(VFS_PATH_PLUGIN_FOLDER, "admintoolhandler-class");
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            CmsResource res = (CmsResource)i.next();
            if (!res.isFolder()) continue;
            String classname = this.m_cms.readPropertyObject(res.getRootPath(), "admintoolhandler-class", false).getValue();
            try {
                Object objectInstance = Class.forName(classname).newInstance();
                if (objectInstance instanceof I_CmsContentCheck) {
                    I_CmsContentCheck plugin = (I_CmsContentCheck)objectInstance;
                    plugin.init(this.m_cms);
                    this.m_plugins.add(plugin);
                    LOG.info((Object)Messages.get().getBundle().key("LOG_CREATE_PLUGIN_1", (Object)classname));
                    continue;
                }
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CANNOT_CREATE_PLUGIN_1", (Object)classname));
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_CANNOT_CREATE_PLUGIN_2", (Object)classname, (Object)t));
            }
        }
    }
}

