/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.content.check.CmsContentCheck;
import org.opencms.workplace.tools.content.check.I_CmsContentCheck;
import org.opencms.workplace.tools.content.check.Messages;

public class CmsContentCheckDialog
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "contentcheck";
    public static final String[] PAGES = new String[]{"page1"};
    protected static final String CONTENT_CHECK_REPORT = "/system/workplace/admin/contenttools/check/report.jsp";
    protected static final String CONTENT_CHECK_RESULT = "/system/workplace/admin/contenttools/check/result.jsp";
    private CmsContentCheck m_contentCheck;

    public CmsContentCheckDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsContentCheckDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            List paths = this.m_contentCheck.getPaths();
            if (paths.size() == 0) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_NO_VFSPATH_0"));
            }
            Iterator i = paths.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                if (this.getCms().existsResource(path)) continue;
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_NO_VFSPATH_0"));
            }
            boolean isActive = false;
            List plugins = this.m_contentCheck.getPlugins();
            Iterator i2 = plugins.iterator();
            while (i2.hasNext()) {
                I_CmsContentCheck plugin = (I_CmsContentCheck)i2.next();
                if (!plugin.isActive()) continue;
                isActive = true;
            }
            if (!isActive) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_NO_TEST_0"));
            }
            this.setDialogObject(this.m_contentCheck);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("classname", ((Object)((Object)this)).getClass().getName());
            params.put("style", "new");
            params.put("closelink", this.getJsp().link(CONTENT_CHECK_RESULT));
            this.getToolManager().jspForwardPage((CmsWorkplace)this, CONTENT_CHECK_REPORT, params);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.vfsresources")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("label.contentcheck")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(1, this.m_contentCheck.getPluginsCount()));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initContentCheck();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_contentCheck, "paths", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget()));
        List plugins = this.m_contentCheck.getPlugins();
        for (int i = 0; i < plugins.size(); ++i) {
            I_CmsContentCheck plugin = (I_CmsContentCheck)plugins.get(i);
            this.addWidget(new CmsWidgetDialogParameter((Object)plugin, "active", plugin.getDialogParameterName(), PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        }
    }

    protected String[] getPageArray() {
        return new String[]{"page1"};
    }

    protected void initContentCheck() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? null : this.getDialogObject();
        this.m_contentCheck = !(o instanceof CmsContentCheck) ? new CmsContentCheck(this.getCms()) : (CmsContentCheck)o;
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.content.Messages.get().getBundleName());
        this.addMessages("org.opencms.workplace.workplace");
        this.addMessages(Messages.get().getBundleName());
        CmsContentCheck dummy = new CmsContentCheck(this.getCms());
        List plugins = dummy.getPlugins();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            I_CmsContentCheck plugin = (I_CmsContentCheck)i.next();
            List bundles = plugin.getMessageBundles();
            Iterator j = bundles.iterator();
            while (j.hasNext()) {
                String bundle = (String)j.next();
                this.addMessages(bundle);
            }
        }
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_contentCheck);
    }
}

