/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.content.check.A_CmsContentCheck;
import org.opencms.workplace.tools.content.check.CmsContentCheckPropertyObject;
import org.opencms.workplace.tools.content.check.CmsContentCheckResource;
import org.opencms.workplace.tools.content.check.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsContentCheckProperty
extends A_CmsContentCheck {
    private static final String CONFIGURATION = "/system/workplace/admin/contenttools/check/plugin/propertycheck/configuration.xml";
    private static final String DIALOG_PARAMETER = "property";
    private static final String ICONPATH = "tools/contenttools/icons/big/contentcheck_property_configuration.png";
    private static final Log LOG = CmsLog.getLog((Object)CmsContentCheckProperty.class);
    private static final String NAME = "Property Check";
    private static final String XPATH_EMPTY = "empty";
    private static final String XPATH_ERROR = "error";
    private static final String XPATH_FILENAME = "filename";
    private static final String XPATH_LENGTH = "length";
    private static final String XPATH_PROPERTYNAME = "propertyname";
    private static final String XPATH_TYPE = "type";
    private static final String XPATH_VALUE = "value";
    private static final String XPATH_WARNUING = "warning";
    private boolean m_active = true;
    private CmsObject m_cms;
    private List m_configuredErrorChecks = null;
    private List m_configuredWarningChecks = null;
    private Locale m_locale;

    public CmsContentCheckResource executeContentCheck(CmsObject cms, CmsContentCheckResource testResource) throws CmsException {
        List warnings;
        List errors;
        this.getConfiguration();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CONFIGURED_ERRORS_2", new Object[]{testResource.getResourceName(), this.m_configuredErrorChecks}));
        }
        if ((errors = this.processProperties(this.m_configuredErrorChecks, testResource)).size() > 0) {
            testResource.addErrors(errors);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CONFIGURED_WARNINGS_2", (Object)testResource.getResourceName(), (Object)this.m_configuredErrorChecks));
        }
        if ((warnings = this.processProperties(this.m_configuredWarningChecks, testResource)).size() > 0) {
            testResource.addWarnings(warnings);
        }
        return testResource;
    }

    public String getDialogParameterName() {
        return DIALOG_PARAMETER;
    }

    public String getHelpText() {
        return Messages.get().getBundle().key("GUI_CHECKCONTENT_CONFIGURATION_PROPERTY_HELP_0");
    }

    public String getIconPath() {
        return ICONPATH;
    }

    public String getLink() {
        return "/system/workplace/views/admin/admin-editor.jsp?resource=/system/workplace/admin/contenttools/check/plugin/propertycheck/configuration.xml";
    }

    public List getMessageBundles() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(Messages.get().getBundleName());
        return messages;
    }

    public String getName() {
        return NAME;
    }

    public String getPath() {
        return "/contenttools/checkconfig/checkproperty";
    }

    public float getPosition() {
        return 1.0f;
    }

    public String getShortName() {
        return NAME;
    }

    public void init(CmsObject cms) {
        this.m_cms = cms;
        this.m_locale = new Locale("en");
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean value) {
        this.m_active = value;
    }

    private void getConfiguration() throws CmsException {
        if (this.m_configuredErrorChecks == null || this.m_configuredWarningChecks == null) {
            CmsResource res = this.m_cms.readResource(CONFIGURATION);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CONFIG_FILENAME_1", (Object)res.getRootPath()));
            }
            CmsFile file = this.m_cms.readFile(res);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CONFIG_FILE_1", (Object)new String(file.getContents())));
            }
            CmsXmlContent configuration = CmsXmlContentFactory.unmarshal((CmsObject)this.m_cms, (CmsFile)file);
            this.m_configuredErrorChecks = this.getConfiguredChecks(configuration, XPATH_ERROR);
            this.m_configuredWarningChecks = this.getConfiguredChecks(configuration, XPATH_WARNUING);
        }
    }

    private List getConfiguredChecks(CmsXmlContent configuration, String xpath) {
        ArrayList<CmsContentCheckPropertyObject> checks = new ArrayList<CmsContentCheckPropertyObject>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CONFIG_XPATH_2", (Object)xpath, (Object)this.m_locale));
        }
        int size = configuration.getIndexCount(xpath, this.m_locale);
        for (int i = 1; i <= size; ++i) {
            String propertyname = configuration.getValue(xpath + "[" + i + "]/" + XPATH_PROPERTYNAME, this.m_locale).getStringValue(this.m_cms);
            String type = configuration.getValue(xpath + "[" + i + "]/" + XPATH_TYPE, this.m_locale).getStringValue(this.m_cms);
            String empty = configuration.getValue(xpath + "[" + i + "]/" + XPATH_EMPTY, this.m_locale).getStringValue(this.m_cms);
            String filename = configuration.getValue(xpath + "[" + i + "]/" + XPATH_FILENAME, this.m_locale).getStringValue(this.m_cms);
            String length = configuration.getValue(xpath + "[" + i + "]/" + XPATH_LENGTH, this.m_locale).getStringValue(this.m_cms);
            int values = configuration.getIndexCount(xpath + "[" + i + "]/" + XPATH_VALUE, this.m_locale);
            CmsContentCheckPropertyObject propObject = new CmsContentCheckPropertyObject();
            if (CmsStringUtil.isNotEmpty((String)propertyname)) {
                propObject.setPropertyname(propertyname);
            }
            if (CmsStringUtil.isNotEmpty((String)type)) {
                propObject.setType(type);
            }
            if (CmsStringUtil.isNotEmpty((String)empty)) {
                propObject.setEmpty(empty.equals("true"));
            }
            if (CmsStringUtil.isNotEmpty((String)filename)) {
                propObject.setFilename(filename.equals("true"));
            }
            if (CmsStringUtil.isNotEmpty((String)length)) {
                propObject.setLength(new Integer(length));
            }
            if (values > 0) {
                ArrayList<String> valueList = new ArrayList<String>();
                for (int j = 1; j <= values; ++j) {
                    String value = configuration.getValue(xpath + "[" + i + "]/" + XPATH_VALUE + "[" + j + "]", this.m_locale).getStringValue(this.m_cms);
                    if (!CmsStringUtil.isNotEmpty((String)value)) continue;
                    valueList.add(value);
                }
                propObject.setValue(valueList);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CONFIG_PROPERTY_3", (Object)new Integer(i), (Object)new Integer(size), (Object)propObject));
            }
            checks.add(propObject);
        }
        return checks;
    }

    private List processProperties(List properties, CmsContentCheckResource testResource) {
        ArrayList<String> results = new ArrayList<String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_RESOURCE_1", (Object)testResource.getResourceName()));
        }
        for (int i = 0; i < properties.size(); ++i) {
            try {
                CmsContentCheckPropertyObject propObject = (CmsContentCheckPropertyObject)properties.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_PROPERTY_1", (Object)propObject.toString()));
                }
                if (!propObject.getType().equals("both") && (!propObject.getType().equals("file") || !testResource.getResource().isFile()) && (!propObject.getType().equals("folder") || !testResource.getResource().isFolder())) continue;
                String prop = this.m_cms.readPropertyObject(testResource.getResource(), propObject.getPropertyname(), false).getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_VALUE_1", (Object)prop));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_ISEMPTYCHECK_1", (Object)propObject.isEmpty()));
                }
                if (propObject.isEmpty() && CmsStringUtil.isEmpty((String)prop)) {
                    results.add(Messages.get().getBundle().key("ERR_CHECK_NO_PROPERTYNAME_1", (Object)propObject.getPropertyname()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("ERR_CHECK_NO_PROPERTYNAME_1", (Object)propObject.getPropertyname()));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_ISFILENAME_1", (Object)propObject.isFilename()));
                }
                if (CmsStringUtil.isEmpty((String)prop)) continue;
                if (propObject.isFilename() && testResource.getResource().getName().toLowerCase().startsWith(prop.toLowerCase())) {
                    results.add(Messages.get().getBundle().key("ERR_CHECK_CONTAINS_FILENAME_2", (Object)propObject.getPropertyname(), (Object)prop));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("ERR_CHECK_CONTAINS_FILENAME_2", (Object)propObject.getPropertyname(), (Object)prop));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_CHECKLENGTH_2", (Object)new Integer(propObject.getLength()), (Object)new Integer(prop.length())));
                }
                if (propObject.getLength() > -1 && prop.length() < propObject.getLength()) {
                    results.add(Messages.get().getBundle().key("ERR_CHECK_TOO_SHORT_3", (Object)propObject.getPropertyname(), (Object)prop, (Object)new Integer(prop.length())));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("ERR_CHECK_TOO_SHORT_3", (Object)propObject.getPropertyname(), (Object)prop, (Object)new Integer(prop.length())));
                    }
                }
                if (propObject.getValue().size() <= 0) continue;
                for (int j = 0; j < propObject.getValue().size(); ++j) {
                    String regex = (String)propObject.getValue().get(j);
                    boolean matchResult = true;
                    if (regex.charAt(0) == '!') {
                        matchResult = false;
                        regex = regex.substring(1);
                    }
                    String matchValue = prop;
                    boolean match = Pattern.matches(regex, matchValue);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_PROPERTY_MATCHPATTERN_2", (Object)regex, (Object)matchValue));
                    }
                    if (matchResult == match) continue;
                    results.add(Messages.get().getBundle().key("ERR_CHECK_MATCH_3", (Object)propObject.getPropertyname(), (Object)prop, propObject.getValue().get(j)));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_CHECK_MATCH_3", (Object)propObject.getPropertyname(), (Object)prop, propObject.getValue().get(j)));
                }
                continue;
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_PROCESSING_PROPERTIES_2", (Object)testResource.getResourceName(), (Object)e));
            }
        }
        return results;
    }
}

