/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content.check;

import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsContentCheckResource {
    private byte[] m_content;
    private List m_errors;
    private CmsResource m_resource;
    private List m_warnings;
    private CmsXmlContent m_xmlcontent;

    public CmsContentCheckResource(CmsResource res) {
        this.m_resource = res;
        this.m_content = null;
        this.m_xmlcontent = null;
        this.m_errors = new ArrayList();
        this.m_warnings = new ArrayList();
    }

    public void addError(String error) {
        this.m_errors.add(error);
    }

    public void addErrors(List errors) {
        this.m_errors.addAll(errors);
    }

    public void addWarning(String warning) {
        this.m_warnings.add(warning);
    }

    public void addWarnings(List warnings) {
        this.m_warnings.addAll(warnings);
    }

    public byte[] getContent() {
        return this.m_content;
    }

    public List getErrors() {
        return this.m_errors;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public String getResourceName() {
        return this.m_resource.getRootPath();
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    public CmsXmlContent getXmlContent() {
        return this.m_xmlcontent;
    }

    public void upgradeContent(CmsObject cms) throws CmsException {
        if (this.m_content == null) {
            this.m_content = cms.readFile(this.m_resource).getContents();
        }
    }

    public void upgradeXmlContent(CmsObject cms) throws CmsException {
        if (this.m_xmlcontent == null) {
            CmsFile file = cms.readFile(this.m_resource);
            this.m_xmlcontent = CmsXmlContentFactory.unmarshal((CmsObject)cms, (CmsFile)file);
        }
    }
}

