/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.workplace.tools.content.check.CmsContentCheckResource;

public class CmsContentCheckResult {
    private List m_allCheckResources;
    private List m_allResources;
    private List m_errorCheckResources;
    private List m_errorResources;
    private Map m_errors = new HashMap();
    private List m_warningCheckResources;
    private List m_warningResources;
    private Map m_warnings = new HashMap();

    public CmsContentCheckResult() {
        this.m_errorResources = new ArrayList();
        this.m_warningResources = new ArrayList();
        this.m_allResources = new ArrayList();
        this.m_errorCheckResources = new ArrayList();
        this.m_warningCheckResources = new ArrayList();
        this.m_allCheckResources = new ArrayList();
    }

    public void addResult(CmsContentCheckResource testResource) {
        List warnings = testResource.getWarnings();
        List errors = testResource.getErrors();
        if (warnings != null && warnings.size() > 0) {
            this.m_warnings.put(testResource.getResourceName(), warnings);
            this.m_warningResources.add(testResource.getResource());
            this.m_warningCheckResources.add(testResource);
        }
        if (errors != null && errors.size() > 0) {
            this.m_errors.put(testResource.getResourceName(), errors);
            this.m_errorResources.add(testResource.getResource());
            this.m_errorCheckResources.add(testResource);
        }
        this.m_allResources.add(testResource.getResource());
        this.m_allCheckResources.add(testResource);
    }

    public List getAllCheckResources() {
        return this.m_allCheckResources;
    }

    public List getAllResources() {
        return this.m_allResources;
    }

    public List getErrorCheckResources() {
        return this.m_errorCheckResources;
    }

    public List getErrorResources() {
        return this.m_errorResources;
    }

    public Map getErrors() {
        return this.m_errors;
    }

    public List getErrors(String resourceName) {
        return (List)this.m_errors.get(resourceName);
    }

    public List getWarningCheckResources() {
        return this.m_warningCheckResources;
    }

    public List getWarningResources() {
        return this.m_warningResources;
    }

    public Map getWarnings() {
        return this.m_warnings;
    }

    public List getWarnings(String resourceName) {
        return (List)this.m_warnings.get(resourceName);
    }
}

