/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.logging.Log;
import org.opencms.configuration.Messages;
import org.opencms.file.types.CmsResourceTypeUnknown;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsLog;
import org.xml.sax.Attributes;

public class CmsDigesterResourceTypeCreationFactory
extends AbstractObjectCreationFactory
implements ObjectCreationFactory {
    private static final Log LOG = CmsLog.getLog(CmsDigesterResourceTypeCreationFactory.class);

    public Object createObject(Attributes attributes) throws Exception {
        I_CmsResourceType type;
        String className = attributes.getValue("class");
        try {
            if (className != null) {
                className = className.trim();
            }
            type = (I_CmsResourceType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            type = new CmsResourceTypeUnknown();
            LOG.error((Object)Messages.get().getBundle().key("ERR_UNKNOWN_RESTYPE_CLASS_2", className, type.getClass().getName()), (Throwable)e);
        }
        return type;
    }
}

