/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsConfigurationCopyResource;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsDigesterResourceTypeCreationFactory;
import org.opencms.configuration.I_CmsXmlConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.file.CmsProperty;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsMimeType;
import org.opencms.loader.CmsResourceManager;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsResourceTranslator;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentTypeManager;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsVfsConfiguration
extends A_CmsXmlConfiguration
implements I_CmsXmlConfiguration {
    public static final String A_DEFAULTWIDGET = "defaultwidget";
    public static final String A_EXTENSION = "extension";
    public static final String A_SOURCE = "source";
    public static final String A_TARGET = "target";
    public static final String CONFIGURATION_DTD_NAME = "opencms-vfs.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-vfs.xml";
    public static final String N_COLLECTOR = "collector";
    public static final String N_COLLECTORS = "collectors";
    public static final String N_COPY_RESOURCE = "copy-resource";
    public static final String N_COPY_RESOURCES = "copy-resources";
    public static final String N_DEFAULTFILE = "defaultfile";
    public static final String N_DEFAULTFILES = "defaultfiles";
    public static final String N_FILETRANSLATIONS = "filetranslations";
    public static final String N_FOLDERTRANSLATIONS = "foldertranslations";
    public static final String N_LOADER = "loader";
    public static final String N_MAPPING = "mapping";
    public static final String N_MAPPINGS = "mappings";
    public static final String N_MIMETYPE = "mimetype";
    public static final String N_MIMETYPES = "mimetypes";
    public static final String N_PROPERTIES = "properties";
    public static final String N_RELATIONTYPE = "relationtype";
    public static final String N_RELATIONTYPES = "relationtypes";
    public static final String N_RESOURCELOADERS = "resourceloaders";
    public static final String N_RESOURCES = "resources";
    public static final String N_RESOURCETYPES = "resourcetypes";
    public static final String N_SCHEMATYPE = "schematype";
    public static final String N_SCHEMATYPES = "schematypes";
    public static final String N_TRANSLATION = "translation";
    public static final String N_TRANSLATIONS = "translations";
    public static final String N_TYPE = "type";
    public static final String N_VERSIONHISTORY = "versionhistory";
    public static final String N_VFS = "vfs";
    public static final String N_WIDGET = "widget";
    public static final String N_WIDGETS = "widgets";
    public static final String N_XMLCONTENT = "xmlcontent";
    public static final String N_XMLCONTENTS = "xmlcontents";
    CmsXmlContentTypeManager m_xmlContentTypeManager;
    private List m_defaultFiles;
    private boolean m_fileTranslationEnabled;
    private List m_fileTranslations;
    private boolean m_folderTranslationEnabled;
    private List m_folderTranslations;
    private CmsResourceManager m_resourceManager;

    public CmsVfsConfiguration() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        this.m_fileTranslations = new ArrayList();
        this.m_folderTranslations = new ArrayList();
        this.m_defaultFiles = new ArrayList();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_CONFIG_INIT_0"));
        }
    }

    public static void addResourceTypeXmlRules(Digester digester) {
        digester.addFactoryCreate("*/resourcetypes/type", CmsDigesterResourceTypeCreationFactory.class);
        digester.addSetNext("*/resourcetypes/type", "addResourceType");
        digester.addCallMethod("*/resourcetypes/type", "initConfiguration", 3);
        digester.addCallParam("*/resourcetypes/type", 0, "name");
        digester.addCallParam("*/resourcetypes/type", 1, "id");
        digester.addCallParam("*/resourcetypes/type", 2, "class");
        digester.addObjectCreate("*/resourcetypes/type/properties/property", CmsProperty.class);
        digester.addCallMethod("*/resourcetypes/type/properties/property/name", "setName", 1);
        digester.addCallParam("*/resourcetypes/type/properties/property/name", 0);
        digester.addCallMethod("*/resourcetypes/type/properties/property/value", "setValue", 2);
        digester.addCallParam("*/resourcetypes/type/properties/property/value", 0);
        digester.addCallParam("*/resourcetypes/type/properties/property/value", 1, N_TYPE);
        digester.addSetNext("*/resourcetypes/type/properties/property", "addDefaultProperty");
        digester.addCallMethod("*/resourcetypes/type/mappings/mapping", "addMappingType", 1);
        digester.addCallParam("*/resourcetypes/type/mappings/mapping", 0, "suffix");
        digester.addCallMethod("*/resourcetypes/type/copy-resources/copy-resource", "addCopyResource", 3);
        digester.addCallParam("*/resourcetypes/type/copy-resources/copy-resource", 0, A_SOURCE);
        digester.addCallParam("*/resourcetypes/type/copy-resources/copy-resource", 1, A_TARGET);
        digester.addCallParam("*/resourcetypes/type/copy-resources/copy-resource", 2, N_TYPE);
    }

    public static void generateResourceTypeXml(Element startNode, List resourceTypes, boolean module) {
        for (int i = 0; i < resourceTypes.size(); ++i) {
            Map prop;
            List copyRes;
            List properties;
            I_CmsResourceType resType = (I_CmsResourceType)resourceTypes.get(i);
            if (resType.isAdditionalModuleResourceType() != module) continue;
            Element resourceType = startNode.addElement(N_TYPE).addAttribute("class", resType.getClassName());
            resourceType.addAttribute("name", resType.getTypeName());
            resourceType.addAttribute("id", String.valueOf(resType.getTypeId()));
            List mappings = resType.getConfiguredMappings();
            if (mappings != null && mappings.size() > 0) {
                Element mappingsNode = resourceType.addElement(N_MAPPINGS);
                for (int j = 0; j < mappings.size(); ++j) {
                    Element mapping = mappingsNode.addElement(N_MAPPING);
                    mapping.addAttribute("suffix", (String)mappings.get(j));
                }
            }
            if ((properties = resType.getConfiguredDefaultProperties()) != null && properties.size() > 0) {
                Element propertiesNode = resourceType.addElement(N_PROPERTIES);
                Iterator p = properties.iterator();
                while (p.hasNext()) {
                    CmsProperty property = (CmsProperty)p.next();
                    Element propertyNode = propertiesNode.addElement("property");
                    propertyNode.addElement("name").addText(property.getName());
                    if (property.getStructureValue() != null) {
                        propertyNode.addElement("value").addCDATA(property.getStructureValue());
                    }
                    if (property.getResourceValue() == null) continue;
                    propertyNode.addElement("value").addAttribute(N_TYPE, "shared").addCDATA(property.getResourceValue());
                }
            }
            if ((copyRes = resType.getConfiguredCopyResources()) != null && copyRes.size() > 0) {
                Element copyResNode = resourceType.addElement(N_COPY_RESOURCES);
                Iterator p = copyRes.iterator();
                while (p.hasNext()) {
                    CmsConfigurationCopyResource cRes = (CmsConfigurationCopyResource)p.next();
                    Element cNode = copyResNode.addElement(N_COPY_RESOURCE);
                    cNode.addAttribute(A_SOURCE, cRes.getSource());
                    if (!cRes.isTargetWasNull()) {
                        cNode.addAttribute(A_TARGET, cRes.getTarget());
                    }
                    if (cRes.isTypeWasNull()) continue;
                    cNode.addAttribute(N_TYPE, cRes.getTypeString());
                }
            }
            if ((prop = resType.getConfiguration()) == null) continue;
            ArrayList sortedRuntimeProperties = new ArrayList(prop.keySet());
            Collections.sort(sortedRuntimeProperties);
            Iterator it = sortedRuntimeProperties.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object val = prop.get(key);
                resourceType.addElement("param").addAttribute("name", key).addText(String.valueOf(val));
            }
        }
    }

    public void addDefaultFile(String defaultFile) {
        this.m_defaultFiles.add(defaultFile);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_DEFAULT_FILE_2", new Integer(this.m_defaultFiles.size()), defaultFile));
        }
    }

    public void addFileTranslation(String translation) {
        this.m_fileTranslations.add(translation);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_ADD_FILE_TRANSLATION_1", translation));
        }
    }

    public void addFolderTranslation(String translation) {
        this.m_folderTranslations.add(translation);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_ADD_FOLDER_TRANSLATION_1", translation));
        }
    }

    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/vfs", "initializeFinished");
        digester.addObjectCreate("*/vfs/resources", CmsResourceManager.class);
        digester.addCallMethod("*/vfs/resources", "initConfiguration");
        digester.addSetNext("*/vfs/resources", "setResourceManager");
        digester.addObjectCreate("*/vfs/resources/resourceloaders/loader", "class", CmsConfigurationException.class);
        digester.addCallMethod("*/vfs/resources/resourceloaders/loader", "initConfiguration");
        digester.addSetNext("*/vfs/resources/resourceloaders/loader", "addLoader");
        CmsVfsConfiguration.addResourceTypeXmlRules(digester);
        digester.addCallMethod("*/vfs/resources/collectors/collector", "addContentCollector", 2);
        digester.addCallParam("*/vfs/resources/collectors/collector", 0, "class");
        digester.addCallParam("*/vfs/resources/collectors/collector", 1, "order");
        digester.addCallMethod("*/vfs/resources/mimetypes/mimetype", "addMimeType", 2);
        digester.addCallParam("*/vfs/resources/mimetypes/mimetype", 0, A_EXTENSION);
        digester.addCallParam("*/vfs/resources/mimetypes/mimetype", 1, N_TYPE);
        digester.addCallMethod("*/vfs/resources/relationtypes/relationtype", "addRelationType", 2);
        digester.addCallParam("*/vfs/resources/relationtypes/relationtype", 0, "name");
        digester.addCallParam("*/vfs/resources/relationtypes/relationtype", 1, N_TYPE);
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        digester.addCallMethod("*/vfs/defaultfiles/defaultfile", "addDefaultFile", 1);
        digester.addCallParam("*/vfs/defaultfiles/defaultfile", 0, "name");
        digester.addCallMethod("*/vfs/translations/filetranslations/translation", "addFileTranslation", 0);
        digester.addCallMethod("*/vfs/translations/filetranslations", "setFileTranslationEnabled", 1);
        digester.addCallParam("*/vfs/translations/filetranslations", 0, "enabled");
        digester.addCallMethod("*/vfs/translations/foldertranslations/translation", "addFolderTranslation", 0);
        digester.addCallMethod("*/vfs/translations/foldertranslations", "setFolderTranslationEnabled", 1);
        digester.addCallParam("*/vfs/translations/foldertranslations", 0, "enabled");
        digester.addObjectCreate("*/vfs/xmlcontent", CmsXmlContentTypeManager.class);
        digester.addSetNext("*/vfs/xmlcontent", "setXmlContentTypeManager");
        digester.addCallMethod("*/vfs/xmlcontent/widgets/widget", "addWidget", 2);
        digester.addCallParam("*/vfs/xmlcontent/widgets/widget", 0, "class");
        digester.addCallParam("*/vfs/xmlcontent/widgets/widget", 1, "alias");
        digester.addCallMethod("*/vfs/xmlcontent/schematypes/schematype", "addSchemaType", 2);
        digester.addCallParam("*/vfs/xmlcontent/schematypes/schematype", 0, "class");
        digester.addCallParam("*/vfs/xmlcontent/schematypes/schematype", 1, A_DEFAULTWIDGET);
    }

    public Element generateXml(Element parent) {
        if (OpenCms.getRunLevel() >= 3) {
            this.m_resourceManager = OpenCms.getResourceManager();
            this.m_xmlContentTypeManager = OpenCms.getXmlContentTypeManager();
            this.m_defaultFiles = OpenCms.getDefaultFiles();
        }
        Element vfs = parent.addElement(N_VFS);
        Element resources = vfs.addElement(N_RESOURCES);
        Element resourceloadersElement = resources.addElement(N_RESOURCELOADERS);
        List loaders = this.m_resourceManager.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            I_CmsResourceLoader loader = (I_CmsResourceLoader)loaders.get(i);
            Element loaderNode = resourceloadersElement.addElement(N_LOADER);
            loaderNode.addAttribute("class", loader.getClass().getName());
            Map loaderConfiguration = loader.getConfiguration();
            if (loaderConfiguration == null) continue;
            Iterator it = loaderConfiguration.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                Element paramNode = loaderNode.addElement("param");
                paramNode.addAttribute("name", name);
                paramNode.addText(value);
            }
        }
        Element resourcetypesElement = resources.addElement(N_RESOURCETYPES);
        ArrayList<I_CmsResourceType> resourceTypes = new ArrayList<I_CmsResourceType>();
        if (this.m_resourceManager.getResTypeUnknownFolder() != null) {
            resourceTypes.add(this.m_resourceManager.getResTypeUnknownFolder());
        }
        if (this.m_resourceManager.getResTypeUnknownFile() != null) {
            resourceTypes.add(this.m_resourceManager.getResTypeUnknownFile());
        }
        resourceTypes.addAll(this.m_resourceManager.getResourceTypes());
        CmsVfsConfiguration.generateResourceTypeXml(resourcetypesElement, resourceTypes, false);
        Element collectorsElement = resources.addElement(N_COLLECTORS);
        Iterator it = this.m_resourceManager.getRegisteredContentCollectors().iterator();
        while (it.hasNext()) {
            I_CmsResourceCollector collector = (I_CmsResourceCollector)it.next();
            collectorsElement.addElement(N_COLLECTOR).addAttribute("class", collector.getClass().getName()).addAttribute("order", String.valueOf(collector.getOrder()));
        }
        Element mimeTypesElement = resources.addElement(N_MIMETYPES);
        it = this.m_resourceManager.getMimeTypes().iterator();
        while (it.hasNext()) {
            CmsMimeType type = (CmsMimeType)it.next();
            mimeTypesElement.addElement(N_MIMETYPE).addAttribute(A_EXTENSION, type.getExtension()).addAttribute(N_TYPE, type.getType());
        }
        Element relationTypesElement = resources.addElement(N_RELATIONTYPES);
        it = this.m_resourceManager.getRelationTypes().iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            relationTypesElement.addElement(N_RELATIONTYPE).addAttribute("name", type.getName()).addAttribute(N_TYPE, type.getType());
        }
        Element defaultFileElement = vfs.addElement(N_DEFAULTFILES);
        it = this.m_defaultFiles.iterator();
        while (it.hasNext()) {
            defaultFileElement.addElement(N_DEFAULTFILE).addAttribute("name", (String)it.next());
        }
        Element translationsElement = vfs.addElement(N_TRANSLATIONS);
        Element fileTransElement = translationsElement.addElement(N_FILETRANSLATIONS).addAttribute("enabled", String.valueOf(this.m_fileTranslationEnabled));
        it = this.m_fileTranslations.iterator();
        while (it.hasNext()) {
            fileTransElement.addElement(N_TRANSLATION).setText(it.next().toString());
        }
        Element folderTransElement = translationsElement.addElement(N_FOLDERTRANSLATIONS).addAttribute("enabled", String.valueOf(this.m_folderTranslationEnabled));
        it = this.m_folderTranslations.iterator();
        while (it.hasNext()) {
            folderTransElement.addElement(N_TRANSLATION).setText(it.next().toString());
        }
        Element xmlContentsElement = vfs.addElement(N_XMLCONTENT);
        Element xmlWidgetsElement = xmlContentsElement.addElement(N_WIDGETS);
        it = this.m_xmlContentTypeManager.getRegisteredWidgetNames().iterator();
        while (it.hasNext()) {
            String widget = (String)it.next();
            Element widgetElement = xmlWidgetsElement.addElement(N_WIDGET).addAttribute("class", widget);
            String alias = this.m_xmlContentTypeManager.getRegisteredWidgetAlias(widget);
            if (alias == null) continue;
            widgetElement.addAttribute("alias", alias);
        }
        Element xmlSchemaTypesElement = xmlContentsElement.addElement(N_SCHEMATYPES);
        it = this.m_xmlContentTypeManager.getRegisteredSchemaTypes().iterator();
        while (it.hasNext()) {
            I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)it.next();
            I_CmsWidget widget = this.m_xmlContentTypeManager.getWidgetDefault(type.getTypeName());
            xmlSchemaTypesElement.addElement(N_SCHEMATYPE).addAttribute("class", type.getClass().getName()).addAttribute(A_DEFAULTWIDGET, widget.getClass().getName());
        }
        return vfs;
    }

    public List getDefaultFiles() {
        return Collections.unmodifiableList(this.m_defaultFiles);
    }

    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsResourceTranslator getFileTranslator() {
        String[] array = this.m_fileTranslationEnabled ? new String[this.m_fileTranslations.size()] : new String[]{};
        for (int i = 0; i < this.m_fileTranslations.size(); ++i) {
            array[i] = (String)this.m_fileTranslations.get(i);
        }
        return new CmsResourceTranslator(array, true);
    }

    public CmsResourceTranslator getFolderTranslator() {
        String[] array = this.m_folderTranslationEnabled ? new String[this.m_folderTranslations.size()] : new String[]{};
        for (int i = 0; i < this.m_folderTranslations.size(); ++i) {
            array[i] = (String)this.m_folderTranslations.get(i);
        }
        return new CmsResourceTranslator(array, false);
    }

    public CmsResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public CmsXmlContentTypeManager getXmlContentTypeManager() {
        return this.m_xmlContentTypeManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_CONFIG_FINISHED_0"));
        }
    }

    public void setFileTranslationEnabled(String value) {
        this.m_fileTranslationEnabled = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_fileTranslationEnabled) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FILE_TRANSLATION_ENABLE_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FILE_TRANSLATION_DISABLE_0"));
            }
        }
    }

    public void setFolderTranslationEnabled(String value) {
        this.m_folderTranslationEnabled = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_folderTranslationEnabled) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FOLDER_TRANSLATION_ENABLE_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FOLDER_TRANSLATION_DISABLE_0"));
            }
        }
    }

    public void setResourceManager(CmsResourceManager manager) {
        this.m_resourceManager = manager;
    }

    public void setXmlContentTypeManager(CmsXmlContentTypeManager manager) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_XML_CONTENT_FINISHED_0"));
        }
        this.m_xmlContentTypeManager = manager;
    }
}

