/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsPublishList
implements Externalizable {
    private static final Log LOG = CmsLog.getLog(CmsPublishList.class);
    private static final int NIL = -1;
    private static final long serialVersionUID = -2578909250462750927L;
    private static final int UUID_LENGTH = CmsUUID.getNullUUID().toByteArray().length;
    private List m_deletedFolderList;
    private List m_directPublishResources;
    private List m_fileList;
    private List m_folderList;
    private boolean m_needsRevive = false;
    private CmsUUID m_projectId;
    private CmsUUID m_publishHistoryId;
    private boolean m_publishSiblings;
    private boolean m_publishSubResources;

    public CmsPublishList() {
    }

    public CmsPublishList(CmsProject project) {
        this(project, null, false, true);
    }

    public CmsPublishList(CmsResource directPublishResource, boolean publishSiblings) {
        this(null, Collections.singletonList(directPublishResource), publishSiblings, true);
    }

    public CmsPublishList(List directPublishResources, boolean publishSiblings) {
        this(null, directPublishResources, publishSiblings, true);
    }

    public CmsPublishList(List directPublishResources, boolean publishSiblings, boolean publishSubResources) {
        this(null, directPublishResources, publishSiblings, publishSubResources);
    }

    private CmsPublishList(CmsProject project, List directPublishResources, boolean publishSiblings, boolean publishSubResources) {
        this.m_fileList = new ArrayList();
        this.m_folderList = new ArrayList();
        this.m_deletedFolderList = new ArrayList();
        this.m_publishHistoryId = new CmsUUID();
        this.m_publishSiblings = publishSiblings;
        this.m_publishSubResources = publishSubResources;
        CmsUUID cmsUUID = this.m_projectId = project != null ? project.getUuid() : null;
        if (directPublishResources != null) {
            this.m_directPublishResources = Collections.unmodifiableList(CmsFileUtil.removeRedundantResources(directPublishResources));
        }
    }

    public List getAllResources() {
        ArrayList all = new ArrayList();
        all.addAll(this.m_folderList);
        all.addAll(this.m_fileList);
        all.addAll(this.m_deletedFolderList);
        Collections.sort(all, CmsResource.COMPARE_ROOT_PATH);
        return Collections.unmodifiableList(all);
    }

    public List getDeletedFolderList() {
        if (this.m_needsRevive) {
            return null;
        }
        return this.m_deletedFolderList;
    }

    public List getDirectPublishResources() {
        if (this.m_needsRevive) {
            return null;
        }
        return this.m_directPublishResources;
    }

    public List getFileList() {
        if (this.m_needsRevive) {
            return null;
        }
        return Collections.unmodifiableList(this.m_fileList);
    }

    public List getFolderList() {
        if (this.m_needsRevive) {
            return null;
        }
        return Collections.unmodifiableList(this.m_folderList);
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public CmsUUID getPublishHistoryId() {
        return this.m_publishHistoryId;
    }

    public boolean isDirectPublish() {
        return this.m_projectId == null;
    }

    public boolean isPublishSiblings() {
        return this.m_publishSiblings;
    }

    public boolean isPublishSubResources() {
        return this.m_publishSubResources;
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.m_publishHistoryId = this.internalReadUUID(in);
        this.m_projectId = this.internalReadUUID(in);
        if (this.m_projectId.isNullUUID()) {
            this.m_projectId = null;
        }
        this.m_publishSiblings = in.readInt() != 0;
        this.m_publishSubResources = in.readInt() != 0;
        this.m_directPublishResources = this.internalReadUUIDList(in);
        this.m_fileList = this.internalReadUUIDList(in);
        this.m_folderList = this.internalReadUUIDList(in);
        this.m_deletedFolderList = this.internalReadUUIDList(in);
        this.m_needsRevive = true;
    }

    public void revive(CmsObject cms) {
        if (this.m_needsRevive) {
            if (this.m_directPublishResources != null) {
                this.m_directPublishResources = this.internalReadResourceList(cms, this.m_directPublishResources);
            }
            if (this.m_fileList != null) {
                this.m_fileList = this.internalReadResourceList(cms, this.m_fileList);
            }
            if (this.m_folderList != null) {
                this.m_folderList = this.internalReadResourceList(cms, this.m_folderList);
            }
            if (this.m_deletedFolderList != null) {
                this.m_deletedFolderList = this.internalReadResourceList(cms, this.m_deletedFolderList);
            }
            this.m_needsRevive = false;
        }
    }

    public int size() {
        if (this.m_needsRevive) {
            return 0;
        }
        return this.m_folderList.size() + this.m_fileList.size() + this.m_deletedFolderList.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\n[\n");
        if (this.isDirectPublish()) {
            result.append("direct publish of resources: ").append(this.m_directPublishResources.toString()).append("\n");
        } else {
            result.append("publish of project: ").append(this.m_projectId).append("\n");
        }
        result.append("publish history ID: ").append(this.m_publishHistoryId.toString()).append("\n");
        result.append("resources: ").append(this.m_fileList.toString()).append("\n");
        result.append("folders: ").append(this.m_folderList.toString()).append("\n");
        result.append("deletedFolders: ").append(this.m_deletedFolderList.toString()).append("\n");
        result.append("]\n");
        return result.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Iterator i;
        out.write(this.m_publishHistoryId.toByteArray());
        out.write(this.m_projectId != null ? this.m_projectId.toByteArray() : CmsUUID.getNullUUID().toByteArray());
        out.writeInt(this.m_publishSiblings ? 1 : 0);
        out.writeInt(this.m_publishSubResources ? 1 : 0);
        if (this.m_directPublishResources != null) {
            out.writeInt(this.m_directPublishResources.size());
            i = this.m_directPublishResources.iterator();
            while (i.hasNext()) {
                out.write(((CmsResource)i.next()).getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
        if (this.m_fileList != null) {
            out.writeInt(this.m_fileList.size());
            i = this.m_fileList.iterator();
            while (i.hasNext()) {
                out.write(((CmsResource)i.next()).getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
        if (this.m_folderList != null) {
            out.writeInt(this.m_folderList.size());
            i = this.m_folderList.iterator();
            while (i.hasNext()) {
                out.write(((CmsResource)i.next()).getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
        if (this.m_deletedFolderList != null) {
            out.writeInt(this.m_deletedFolderList.size());
            i = this.m_deletedFolderList.iterator();
            while (i.hasNext()) {
                out.write(((CmsResource)i.next()).getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
    }

    protected void add(CmsResource resource, boolean check) throws IllegalArgumentException {
        if (check && resource.getState().isUnchanged()) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_PUBLISH_UNCHANGED_RESOURCE_1", resource.getRootPath()));
        }
        if (resource.isFolder()) {
            if (resource.getState().isDeleted()) {
                if (!this.m_deletedFolderList.contains(resource)) {
                    this.m_deletedFolderList.add(resource);
                }
            } else if (!this.m_folderList.contains(resource)) {
                this.m_folderList.add(resource);
            }
        } else if (!this.m_fileList.contains(resource)) {
            this.m_fileList.add(resource);
        }
    }

    protected void addAll(Collection resources, boolean check) throws IllegalArgumentException {
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            this.add((CmsResource)i.next(), check);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.m_fileList != null) {
                this.m_fileList.clear();
            }
            if (this.m_folderList != null) {
                this.m_folderList.clear();
            }
            if (this.m_deletedFolderList != null) {
                this.m_deletedFolderList.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected void initialize() {
        if (this.m_folderList != null) {
            Collections.sort(this.m_folderList, CmsResource.COMPARE_ROOT_PATH);
        }
        if (this.m_fileList != null) {
            Collections.sort(this.m_fileList, CmsResource.COMPARE_ROOT_PATH);
        }
        if (this.m_deletedFolderList != null) {
            Collections.sort(this.m_deletedFolderList, CmsResource.COMPARE_ROOT_PATH);
            Collections.reverse(this.m_deletedFolderList);
        }
    }

    protected boolean remove(CmsResource resource) {
        boolean ret = this.m_fileList.remove(resource);
        ret |= this.m_folderList.remove(resource);
        return ret |= this.m_deletedFolderList.remove(resource);
    }

    private List internalReadResourceList(CmsObject cms, List uuidList) {
        ArrayList<CmsResource> resList = new ArrayList<CmsResource>(uuidList.size());
        Iterator i = uuidList.iterator();
        while (i.hasNext()) {
            try {
                CmsResource res = cms.readResource((CmsUUID)i.next(), CmsResourceFilter.ALL);
                resList.add(res);
            }
            catch (CmsException exc) {
                LOG.error((Object)exc);
            }
        }
        return resList;
    }

    private CmsUUID internalReadUUID(ObjectInput in) throws IOException {
        byte[] bytes = new byte[UUID_LENGTH];
        in.readFully(bytes, 0, UUID_LENGTH);
        return new CmsUUID(bytes);
    }

    private List internalReadUUIDList(ObjectInput in) throws IOException {
        ArrayList<CmsUUID> result = null;
        int i = in.readInt();
        if (i >= 0) {
            result = new ArrayList<CmsUUID>();
            while (i > 0) {
                result.add(this.internalReadUUID(in));
                --i;
            }
        }
        return result;
    }
}

