/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.BLOB;
import org.apache.commons.dbcp.DelegatingResultSet;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.generic.Messages;
import org.opencms.db.oracle.CmsSqlManager;
import org.opencms.file.CmsDataAccessException;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsUUID;

public class CmsUserDriver
extends org.opencms.db.generic.CmsUserDriver {
    public static OutputStream getOutputStreamFromBlob(ResultSet res, String name) throws SQLException {
        Blob blob = res.getBlob(name);
        try {
            blob.truncate(0L);
            return blob.setBinaryStream(0L);
        }
        catch (SQLException e) {
            ((BLOB)blob).trim(0L);
            return ((BLOB)blob).getBinaryOutputStream();
        }
    }

    public org.opencms.db.generic.CmsSqlManager initSqlManager(String classname) {
        return org.opencms.db.generic.CmsSqlManager.getInstance(classname);
    }

    public void writeUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_USERDATA_WRITE_3");
            stmt.setString(1, userId.toString());
            stmt.setString(2, key);
            stmt.setString(3, value.getClass().getName());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.internalUpdateUserInfo(dbc, userId, key, value);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalUpdateUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        PreparedStatement commit = null;
        ResultSet res = null;
        Connection conn = null;
        boolean wasInTransaction = false;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            boolean bl = wasInTransaction = !conn.getAutoCommit();
            if (!wasInTransaction) {
                conn.setAutoCommit(false);
            }
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_USERDATA_UPDATE_2");
            stmt.setString(1, userId.toString());
            stmt.setString(2, key);
            res = ((DelegatingResultSet)stmt.executeQuery()).getInnermostDelegate();
            if (!res.next()) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_USER_WITH_ID_1", userId));
            }
            OutputStream output = CmsUserDriver.getOutputStreamFromBlob(res, "DATA_VALUE");
            output.write(CmsDataTypeUtil.dataSerialize(value));
            output.close();
            value = null;
            if (!wasInTransaction) {
                commit = this.m_sqlManager.getPreparedStatement(conn, "C_COMMIT");
                commit.execute();
                this.m_sqlManager.closeAll(dbc, null, commit, null);
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            commit = null;
            stmt = null;
            res = null;
            if (!wasInTransaction) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                catch (IOException e2) {
                    throw new CmsDbIoException(Messages.get().container("ERR_SERIALIZING_USER_DATA_1", userId), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
                throw throwable;
            }
        }
        CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
    }
}

