/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingResultSet;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.generic.Messages;
import org.opencms.db.oracle.CmsSqlManager;
import org.opencms.db.oracle.CmsUserDriver;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsProject;
import org.opencms.util.CmsUUID;

public class CmsVfsDriver
extends org.opencms.db.generic.CmsVfsDriver {
    public void createContent(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId, byte[] content) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_ORACLE_OFFLINE_CONTENTS_WRITE");
            stmt.setString(1, resourceId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.internalWriteContent(dbc, projectId, resourceId, content, -1);
    }

    public void createOnlineContent(CmsDbContext dbc, CmsUUID resourceId, byte[] contents, int publishTag, boolean keepOnline, boolean needToUpdateContent) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            if (needToUpdateContent) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_HISTORY");
                stmt.setString(1, resourceId.toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_ONLINE_CONTENTS_WRITE");
                stmt.setString(1, resourceId.toString());
                stmt.setInt(2, publishTag);
                stmt.setInt(3, publishTag);
                stmt.setInt(4, keepOnline ? 1 : 0);
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                this.internalWriteContent(dbc, CmsProject.ONLINE_PROJECT_ID, resourceId, contents, publishTag);
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_CONTENTS_UPDATE");
                stmt.setInt(1, publishTag);
                stmt.setString(2, resourceId.toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                if (!keepOnline) {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_HISTORY");
                    stmt.setString(1, resourceId.toString());
                    stmt.executeUpdate();
                    this.m_sqlManager.closeAll(dbc, null, stmt, null);
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public org.opencms.db.generic.CmsSqlManager initSqlManager(String classname) {
        return org.opencms.db.generic.CmsSqlManager.getInstance(classname);
    }

    public void writeContent(CmsDbContext dbc, CmsUUID resourceId, byte[] content) throws CmsDataAccessException {
        this.internalWriteContent(dbc, dbc.currentProject().getUuid(), resourceId, content, -1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalWriteContent(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId, byte[] contents, int publishTag) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        PreparedStatement commit = null;
        Connection conn = null;
        ResultSet res = null;
        boolean wasInTransaction = false;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = projectId.equals(CmsProject.ONLINE_PROJECT_ID) ? this.m_sqlManager.getPreparedStatement(conn, projectId, "C_ORACLE_ONLINE_CONTENTS_UPDATECONTENT") : this.m_sqlManager.getPreparedStatement(conn, projectId, "C_ORACLE_OFFLINE_CONTENTS_UPDATECONTENT");
            boolean bl = wasInTransaction = !conn.getAutoCommit();
            if (!wasInTransaction) {
                conn.setAutoCommit(false);
            }
            stmt.setString(1, resourceId.toString());
            if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                stmt.setInt(2, publishTag);
                stmt.setInt(3, publishTag);
            }
            if (!(res = ((DelegatingResultSet)stmt.executeQuery()).getInnermostDelegate()).next()) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("LOG_READING_RESOURCE_1", resourceId));
            }
            OutputStream output = CmsUserDriver.getOutputStreamFromBlob(res, "FILE_CONTENT");
            output.write(contents, 0, contents.length);
            output.close();
            if (!wasInTransaction) {
                commit = this.m_sqlManager.getPreparedStatement(conn, "C_COMMIT");
                commit.execute();
                this.m_sqlManager.closeAll(dbc, null, commit, null);
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            commit = null;
            stmt = null;
            res = null;
            if (!wasInTransaction) {
                conn.setAutoCommit(true);
            }
        }
        catch (IOException e) {
            try {
                throw new CmsDbIoException(Messages.get().container("ERR_WRITING_TO_OUTPUT_STREAM_1", resourceId), (Throwable)e);
                catch (SQLException e2) {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
                throw throwable;
            }
        }
        CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
    }
}

