/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.report.CmsShellReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsUUID;

public final class CmsObject {
    protected CmsRequestContext m_context;
    protected CmsSecurityManager m_securityManager;

    public CmsObject(CmsSecurityManager securityManager, CmsRequestContext context) {
        this.init(securityManager, context);
    }

    public void addRelationToResource(String resourceName, String targetPath, String type) throws CmsException {
        this.createRelation(resourceName, targetPath, type, false);
    }

    public void addUserToGroup(String username, String groupname) throws CmsException {
        this.m_securityManager.addUserToGroup(this.m_context, username, groupname, false);
    }

    public CmsUser addWebUser(String name, String password, String group, String description, Map additionalInfos) throws CmsException {
        CmsUser user = this.m_securityManager.createUser(this.m_context, name, password, description, additionalInfos);
        this.addUserToGroup(name, group);
        return user;
    }

    public void backupProject(int versionId, long publishDate) throws CmsException {
        this.writeHistoryProject(versionId, publishDate);
    }

    public void chacc(String resourceName, String principalType, String principalName, int allowedPermissions, int deniedPermissions, int flags) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        CmsAccessControlEntry acEntry = null;
        try {
            I_CmsPrincipal principal = CmsPrincipal.readPrincipal(this, principalType, principalName);
            acEntry = new CmsAccessControlEntry(res.getResourceId(), principal.getId(), allowedPermissions, deniedPermissions, flags);
            acEntry.setFlagsForPrincipal(principal);
        }
        catch (CmsDbEntryNotFoundException e) {
            if (principalName.equalsIgnoreCase("ALL_OTHERS")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, allowedPermissions, deniedPermissions, flags);
                acEntry.setFlags(128);
            }
            if (principalName.equalsIgnoreCase("OVERWRITE_ALL")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, allowedPermissions, deniedPermissions, flags);
                acEntry.setFlags(256);
            }
            if (principalType.equalsIgnoreCase("ROLE")) {
                this.m_securityManager.checkRoleForResource(this.m_context, CmsRole.VFS_MANAGER, res);
                CmsRole role = CmsRole.valueOfRoleName(principalName);
                if (role == null || !res.getRootPath().startsWith("/system/")) {
                    throw e;
                }
                acEntry = new CmsAccessControlEntry(res.getResourceId(), role.getId(), allowedPermissions, deniedPermissions, flags);
                acEntry.setFlags(512);
            }
            throw e;
        }
        this.m_securityManager.writeAccessControlEntry(this.m_context, res, acEntry);
    }

    public void chacc(String resourceName, String principalType, String principalName, String permissionString) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        CmsAccessControlEntry acEntry = null;
        try {
            I_CmsPrincipal principal = CmsPrincipal.readPrincipal(this, principalType, principalName);
            acEntry = new CmsAccessControlEntry(res.getResourceId(), principal.getId(), permissionString);
            acEntry.setFlagsForPrincipal(principal);
        }
        catch (CmsDbEntryNotFoundException e) {
            if (principalName.equalsIgnoreCase("ALL_OTHERS")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, permissionString);
                acEntry.setFlags(128);
            }
            if (principalName.equalsIgnoreCase("OVERWRITE_ALL")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, permissionString);
                acEntry.setFlags(256);
            }
            if (principalType.equalsIgnoreCase("ROLE")) {
                this.m_securityManager.checkRoleForResource(this.m_context, CmsRole.VFS_MANAGER, res);
                CmsRole role = CmsRole.valueOfRoleName(principalName);
                if (role == null || !res.getRootPath().startsWith("/system/") && !res.getRootPath().equals("/") && !res.getRootPath().equals("/system")) {
                    throw e;
                }
                acEntry = new CmsAccessControlEntry(res.getResourceId(), role.getId(), permissionString);
                acEntry.setFlags(512);
            }
            throw e;
        }
        this.m_securityManager.writeAccessControlEntry(this.m_context, res, acEntry);
    }

    public void changeLock(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).changeLock(this, this.m_securityManager, resource);
    }

    public List changeResourcesInFolderWithProperty(String resourcename, String property, String oldValue, String newValue, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.changeResourcesInFolderWithProperty(this.m_context, resource, property, oldValue, newValue, recursive);
    }

    public void checkPublishPermissions(CmsPublishList publishList) throws CmsException {
        this.m_securityManager.checkPublishPermissions(this.m_context, publishList);
    }

    public void checkRole(CmsRole role) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(this, role);
    }

    public void chflags(String resourcename, int flags) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).chflags(this, this.m_securityManager, resource, flags);
    }

    public void chtype(String resourcename, int type) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).chtype(this, this.m_securityManager, resource, type);
    }

    public void copyResource(String source, String destination) throws CmsException, CmsIllegalArgumentException {
        this.copyResource(source, destination, CmsResource.COPY_PRESERVE_SIBLING);
    }

    public void copyResource(String source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        CmsResource resource = this.readResource(source, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).copyResource(this, this.m_securityManager, resource, destination, siblingMode);
    }

    public void copyResource(String source, String destination, int siblingMode) throws CmsException, CmsIllegalArgumentException {
        this.copyResource(source, destination, CmsResource.CmsResourceCopyMode.valueOf(siblingMode));
    }

    public void copyResourceToProject(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).copyResourceToProject(this, this.m_securityManager, resource);
    }

    public int countLockedResources(CmsUUID id) throws CmsException {
        return this.m_securityManager.countLockedResources(this.m_context, id);
    }

    public int countLockedResources(int id) throws CmsException {
        return this.countLockedResources(this.m_securityManager.getProjectId(this.m_context, id));
    }

    public void cpacc(String sourceName, String destName) throws CmsException {
        CmsResource source = this.readResource(sourceName);
        CmsResource dest = this.readResource(destName);
        this.m_securityManager.copyAccessControlEntries(this.m_context, source, dest);
    }

    public CmsGroup createGroup(String groupFqn, String description, int flags, String parent) throws CmsException {
        return this.m_securityManager.createGroup(this.m_context, groupFqn, description, flags, parent);
    }

    public CmsProject createProject(String name, String description, String groupname, String managergroupname) throws CmsException {
        return this.m_securityManager.createProject(this.m_context, name, description, groupname, managergroupname, CmsProject.PROJECT_TYPE_NORMAL);
    }

    public CmsProject createProject(String name, String description, String groupname, String managergroupname, CmsProject.CmsProjectType projecttype) throws CmsException {
        return this.m_securityManager.createProject(this.m_context, name, description, groupname, managergroupname, projecttype);
    }

    public CmsProject createProject(String name, String description, String groupname, String managergroupname, int projecttype) throws CmsException {
        return this.createProject(name, description, groupname, managergroupname, CmsProject.CmsProjectType.valueOf(projecttype));
    }

    public CmsPropertyDefinition createPropertyDefinition(String name) throws CmsException {
        return this.m_securityManager.createPropertyDefinition(this.m_context, name);
    }

    public CmsResource createResource(String resourcename, int type) throws CmsException, CmsIllegalArgumentException {
        return this.createResource(resourcename, type, new byte[0], Collections.EMPTY_LIST);
    }

    public CmsResource createResource(String resourcename, int type, byte[] content, List properties) throws CmsException, CmsIllegalArgumentException {
        return this.getResourceType(type).createResource(this, this.m_securityManager, resourcename, content, properties);
    }

    public CmsResource createSibling(String source, String destination, List properties) throws CmsException {
        CmsResource resource = this.readResource(source, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.getResourceType(resource).createSibling(this, this.m_securityManager, resource, destination, properties);
    }

    public CmsProject createTempfileProject() throws CmsException {
        return this.m_securityManager.createTempfileProject(this.m_context);
    }

    public CmsUser createUser(String userFqn, String password, String description, Map additionalInfos) throws CmsException {
        return this.m_securityManager.createUser(this.m_context, userFqn, password, description, additionalInfos);
    }

    public void deleteAllStaticExportPublishedResources(int linkType) throws CmsException {
        this.m_securityManager.deleteAllStaticExportPublishedResources(this.m_context, linkType);
    }

    public void deleteBackups(long timestamp, int versions, I_CmsReport report) throws CmsException {
        if (timestamp != 0L && versions == 0) {
            versions = OpenCms.getSystemInfo().getHistoryVersions();
        }
        this.deleteHistoricalVersions("/", versions, versions, timestamp, report);
    }

    public void deleteGroup(CmsUUID groupId, CmsUUID replacementId) throws CmsException {
        this.m_securityManager.deleteGroup(this.m_context, groupId, replacementId);
    }

    public void deleteGroup(String group) throws CmsException {
        this.m_securityManager.deleteGroup(this.m_context, group);
    }

    public void deleteHistoricalVersions(String folderName, int versionsToKeep, int versionsDeleted, long timeDeleted, I_CmsReport report) throws CmsException {
        CmsFolder folder = this.readFolder(folderName);
        this.m_securityManager.deleteHistoricalVersions(this.m_context, folder, versionsToKeep, versionsDeleted, timeDeleted, report);
    }

    public void deleteProject(CmsUUID id) throws CmsException {
        this.m_securityManager.deleteProject(this.m_context, id);
    }

    public void deleteProject(int id) throws CmsException {
        this.deleteProject(this.m_securityManager.getProjectId(this.m_context, id));
    }

    public void deleteProperty(String resourcename, String key) throws CmsException {
        CmsProperty property = new CmsProperty();
        property.setName(key);
        property.setStructureValue("");
        this.writePropertyObject(resourcename, property);
    }

    public void deletePropertyDefinition(String name) throws CmsException {
        this.m_securityManager.deletePropertyDefinition(this.m_context, name);
    }

    public void deleteRelationsFromResource(String resourceName, CmsRelationFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        this.m_securityManager.deleteRelationsForResource(this.m_context, resource, filter);
    }

    public void deleteResource(String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).deleteResource(this, this.m_securityManager, resource, siblingMode);
    }

    public void deleteResource(String resourcename, int siblingMode) throws CmsException {
        this.deleteResource(resourcename, CmsResource.CmsResourceDeleteMode.valueOf(siblingMode));
    }

    public void deleteStaticExportPublishedResource(String resourceName, int linkType, String linkParameter) throws CmsException {
        this.m_securityManager.deleteStaticExportPublishedResource(this.m_context, resourceName, linkType, linkParameter);
    }

    public void deleteUser(CmsUUID userId) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, userId);
    }

    public void deleteUser(CmsUUID userId, CmsUUID replacementId) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, userId, replacementId);
    }

    public void deleteUser(String username) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, username);
    }

    public void deleteWebUser(CmsUUID userId) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, userId);
    }

    public boolean existsResource(String resourcename) {
        return this.existsResource(resourcename, CmsResourceFilter.DEFAULT);
    }

    public boolean existsResource(String resourcename, CmsResourceFilter filter) {
        return this.m_securityManager.existsResource(this.m_context, this.addSiteRoot(resourcename), filter);
    }

    public List getAccessControlEntries(String resourceName) throws CmsException {
        return this.getAccessControlEntries(resourceName, true);
    }

    public List getAccessControlEntries(String resourceName, boolean getInherited) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getAccessControlEntries(this.m_context, res, getInherited);
    }

    public CmsAccessControlList getAccessControlList(String resourceName) throws CmsException {
        return this.getAccessControlList(resourceName, false);
    }

    public CmsAccessControlList getAccessControlList(String resourceName, boolean inheritedOnly) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getAccessControlList(this.m_context, res, inheritedOnly);
    }

    public List getAllAccessibleProjects() throws CmsException {
        return OpenCms.getOrgUnitManager().getAllAccessibleProjects(this, "", true);
    }

    public List getAllBackupProjects() throws CmsException {
        return this.getAllHistoricalProjects();
    }

    public List getAllHistoricalProjects() throws CmsException {
        return this.m_securityManager.getAllHistoricalProjects(this.m_context);
    }

    public List getAllManageableProjects() throws CmsException {
        return OpenCms.getOrgUnitManager().getAllManageableProjects(this, "", true);
    }

    public int getBackupTagId() throws CmsException {
        return ((CmsHistoryProject)this.getAllHistoricalProjects().get(0)).getPublishTag() + 1;
    }

    public List getChild(String groupname) throws CmsException {
        return this.getChildren(groupname, false);
    }

    public List getChildren(String groupname, boolean includeSubChildren) throws CmsException {
        return this.m_securityManager.getChildren(this.m_context, groupname, includeSubChildren);
    }

    public List getChilds(String groupname) throws CmsException {
        return this.getChildren(groupname, true);
    }

    public List getDirectGroupsOfUser(String username) throws CmsException {
        return this.getGroupsOfUser(username, true);
    }

    public List getFilesInFolder(String resourcename) throws CmsException {
        return this.getFilesInFolder(resourcename, CmsResourceFilter.DEFAULT);
    }

    public List getFilesInFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, false, true);
    }

    public List getGroups() throws CmsException {
        return OpenCms.getOrgUnitManager().getGroups(this, "", true);
    }

    public List getGroupsOfUser(String username) throws CmsException {
        return this.getGroupsOfUser(username, false);
    }

    public List getGroupsOfUser(String username, boolean directGroupsOnly) throws CmsException {
        return this.getGroupsOfUser(username, directGroupsOnly, true);
    }

    public List getGroupsOfUser(String username, boolean directGroupsOnly, boolean includeOtherOus) throws CmsException {
        return this.getGroupsOfUser(username, directGroupsOnly, includeOtherOus, this.m_context.getRemoteAddress());
    }

    public List getGroupsOfUser(String username, boolean directGroupsOnly, boolean includeOtherOus, String remoteAddress) throws CmsException {
        return this.m_securityManager.getGroupsOfUser(this.m_context, username, includeOtherOus ? "" : CmsOrganizationalUnit.getParentFqn(username), includeOtherOus, false, directGroupsOnly, remoteAddress);
    }

    public List getGroupsOfUser(String username, String remoteAddress) throws CmsException {
        return this.getGroupsOfUser(username, false, false, remoteAddress);
    }

    public CmsLock getLock(CmsResource resource) throws CmsException {
        return this.m_securityManager.getLock(this.m_context, resource);
    }

    public CmsLock getLock(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.getLock(resource);
    }

    public List getLockedResources(String foldername, CmsLockFilter filter) throws CmsException {
        CmsResource resource = this.readResource(foldername, CmsResourceFilter.ALL);
        return this.m_securityManager.getLockedResources(this.m_context, resource, filter);
    }

    public String getLostAndFoundName(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.moveToLostAndFound(this.m_context, resource, true);
    }

    public CmsGroup getParent(String groupname) throws CmsException {
        return this.m_securityManager.getParent(this.m_context, groupname);
    }

    public CmsPermissionSet getPermissions(String resourceName) throws CmsException {
        return this.getPermissions(resourceName, this.m_context.currentUser().getName());
    }

    public CmsPermissionSet getPermissions(String resourceName, String userName) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        CmsUser user = this.readUser(userName);
        return this.m_securityManager.getPermissions(this.m_context, resource, user);
    }

    public CmsPublishList getPublishList() throws CmsException {
        return OpenCms.getPublishManager().getPublishList(this);
    }

    public CmsPublishList getPublishList(CmsResource directPublishResource, boolean directPublishSiblings) throws CmsException {
        return OpenCms.getPublishManager().getPublishList(this, directPublishResource, directPublishSiblings);
    }

    public CmsPublishList getPublishList(List directPublishResources, boolean directPublishSiblings) throws CmsException {
        return OpenCms.getPublishManager().getPublishList(this, directPublishResources, directPublishSiblings, true);
    }

    public CmsPublishList getPublishList(List directPublishResources, boolean directPublishSiblings, boolean publishSubResources) throws CmsException {
        return OpenCms.getPublishManager().getPublishList(this, directPublishResources, directPublishSiblings, publishSubResources);
    }

    public List getRelationsForResource(String resourceName, CmsRelationFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getRelationsForResource(this.m_context, resource, filter);
    }

    public CmsRequestContext getRequestContext() {
        return this.m_context;
    }

    public Set getResourcesForPrincipal(CmsUUID principalId, CmsPermissionSet permissions, boolean includeAttr) throws CmsException {
        return this.m_securityManager.getResourcesForPrincipal(this.getRequestContext(), principalId, permissions, includeAttr);
    }

    public List getResourcesInFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, true, true);
    }

    public List getResourcesInTimeRange(String folder, long starttime, long endtime) throws CmsException {
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
        filter = filter.addRequireLastModifiedAfter(starttime);
        filter = filter.addRequireLastModifiedBefore(endtime);
        return this.readResources(folder, filter);
    }

    public String getSitePath(CmsResource resource) {
        return this.m_context.getSitePath(resource);
    }

    public List getSubFolders(String resourcename) throws CmsException {
        return this.getSubFolders(resourcename, CmsResourceFilter.DEFAULT);
    }

    public List getSubFolders(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, true, false);
    }

    public List getUsers() throws CmsException {
        return OpenCms.getOrgUnitManager().getUsers(this, "", true);
    }

    public List getUsersOfGroup(String groupname) throws CmsException {
        return this.getUsersOfGroup(groupname, true);
    }

    public List getUsersOfGroup(String groupname, boolean includeOtherOus) throws CmsException {
        return this.m_securityManager.getUsersOfGroup(this.m_context, groupname, includeOtherOus, false, false);
    }

    public boolean hasPermissions(CmsResource resource, CmsPermissionSet requiredPermissions) throws CmsException {
        return this.m_securityManager.hasPermissions(this.m_context, resource, requiredPermissions, true, CmsResourceFilter.ALL).isAllowed();
    }

    public boolean hasPermissions(CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException {
        return I_CmsPermissionHandler.PERM_ALLOWED == this.m_securityManager.hasPermissions(this.m_context, resource, requiredPermissions, checkLock, filter);
    }

    public boolean hasPublishPermissions(String resourcename) {
        CmsResource resource = null;
        if (resourcename != null) {
            try {
                resource = this.readResource(resourcename, CmsResourceFilter.ALL);
                this.checkPublishPermissions(new CmsPublishList(Collections.singletonList(resource), false));
            }
            catch (CmsException e) {
                return false;
            }
        }
        return true;
    }

    public boolean hasRole(CmsRole role) {
        return OpenCms.getRoleManager().hasRole(this, role);
    }

    public void importAccessControlEntries(CmsResource resource, List acEntries) throws CmsException {
        this.m_securityManager.importAccessControlEntries(this.m_context, resource, acEntries);
    }

    public void importRelation(String resourceName, String targetPath, String relationType) throws CmsException {
        this.createRelation(resourceName, targetPath, relationType, true);
    }

    public CmsResource importResource(String resourcename, CmsResource resource, byte[] content, List properties) throws CmsException {
        return this.getResourceType(resource).importResource(this, this.m_securityManager, resourcename, resource, content, properties);
    }

    public CmsUser importUser(String id, String name, String password, String firstname, String lastname, String email, int flags, long dateCreated, Map additionalInfos) throws CmsException {
        return this.m_securityManager.importUser(this.m_context, id, name, password, firstname, lastname, email, flags, dateCreated, additionalInfos);
    }

    public CmsUser importUser(String id, String name, String password, String description, String firstname, String lastname, String email, String address, int flags, Map additionalInfos) throws CmsException {
        HashMap<String, String> info = new HashMap<String, String>();
        if (additionalInfos != null) {
            info.putAll(additionalInfos);
        }
        if (description != null) {
            info.put("USER_DESCRIPTION", description);
        }
        if (address != null) {
            info.put("USER_ADDRESS", address);
        }
        return this.importUser(id, name, password, firstname, lastname, email, flags, System.currentTimeMillis(), info);
    }

    public boolean isAdmin() {
        return this.hasRole(CmsRole.ROOT_ADMIN);
    }

    public boolean isInsideCurrentProject(String resourcename) {
        return this.m_securityManager.isInsideCurrentProject(this.m_context, this.addSiteRoot(resourcename));
    }

    public boolean isManagerOfProject() {
        return this.m_securityManager.isManagerOfProject(this.m_context);
    }

    public void lockResource(String resourcename) throws CmsException {
        this.lockResource(resourcename, CmsLockType.EXCLUSIVE);
    }

    public void lockResource(String resourcename, int mode) throws CmsException {
        this.lockResource(resourcename, CmsLockType.valueOf(mode));
    }

    public void lockResourceTemporary(String resourcename) throws CmsException {
        this.lockResource(resourcename, CmsLockType.TEMPORARY);
    }

    public String loginUser(String username, String password) throws CmsException {
        return this.loginUser(username, password, this.m_context.getRemoteAddress());
    }

    public String loginUser(String username, String password, String remoteAddress) throws CmsException {
        CmsUser newUser = this.m_securityManager.loginUser(this.m_context, username, password, remoteAddress);
        CmsProject newProject = this.m_securityManager.readProject(CmsProject.ONLINE_PROJECT_ID);
        this.m_context.switchUser(newUser, newProject, newUser.getOuFqn());
        this.init(this.m_securityManager, this.m_context);
        this.fireEvent(1, newUser);
        return newUser.getName();
    }

    public String loginWebUser(String username, String password) throws CmsException {
        return this.loginUser(username, password, this.m_context.getRemoteAddress());
    }

    public I_CmsPrincipal lookupPrincipal(CmsUUID principalId) {
        return this.m_securityManager.lookupPrincipal(this.m_context, principalId);
    }

    public I_CmsPrincipal lookupPrincipal(String principalName) {
        return this.m_securityManager.lookupPrincipal(this.m_context, principalName);
    }

    public void moveResource(String source, String destination) throws CmsException {
        CmsResource resource = this.readResource(source, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).moveResource(this, this.m_securityManager, resource, destination);
    }

    public String moveToLostAndFound(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.moveToLostAndFound(this.m_context, resource, false);
    }

    public CmsUUID publishProject() throws Exception {
        CmsUUID publishHistoryId = OpenCms.getPublishManager().publishProject(this, new CmsShellReport(this.m_context.getLocale()));
        OpenCms.getPublishManager().waitWhileRunning();
        return publishHistoryId;
    }

    public CmsUUID publishProject(I_CmsReport report) throws CmsException {
        CmsUUID publishHistoryId = OpenCms.getPublishManager().publishProject(this, report, OpenCms.getPublishManager().getPublishList(this));
        OpenCms.getPublishManager().waitWhileRunning();
        return publishHistoryId;
    }

    public CmsUUID publishProject(I_CmsReport report, CmsPublishList publishList) throws CmsException {
        CmsUUID publishHistoryId = OpenCms.getPublishManager().publishProject(this, report, publishList);
        OpenCms.getPublishManager().waitWhileRunning();
        return publishHistoryId;
    }

    public CmsUUID publishProject(I_CmsReport report, CmsResource directPublishResource, boolean directPublishSiblings) throws CmsException {
        CmsUUID publishHistoryId = OpenCms.getPublishManager().publishProject(this, report, OpenCms.getPublishManager().getPublishList(this, directPublishResource, directPublishSiblings));
        OpenCms.getPublishManager().waitWhileRunning();
        return publishHistoryId;
    }

    public CmsUUID publishResource(String resourcename) throws Exception {
        CmsUUID publishHistoryId = OpenCms.getPublishManager().publishResource(this, resourcename, false, new CmsShellReport(this.m_context.getLocale()));
        OpenCms.getPublishManager().waitWhileRunning();
        return publishHistoryId;
    }

    public CmsUUID publishResource(String resourcename, boolean publishSiblings, I_CmsReport report) throws Exception {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        CmsUUID publishHistoryId = OpenCms.getPublishManager().publishProject(this, report, resource, publishSiblings);
        OpenCms.getPublishManager().waitWhileRunning();
        return publishHistoryId;
    }

    public List readAllAvailableVersions(String resourceName) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.readAllAvailableVersions(this.m_context, resource);
    }

    public List readAllBackupFileHeaders(String filename) throws CmsException {
        return this.readAllAvailableVersions(filename);
    }

    public List readAllPropertyDefinitions() throws CmsException {
        return this.m_securityManager.readAllPropertyDefinitions(this.m_context);
    }

    public CmsFolder readAncestor(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readAncestor(this.m_context, resource, filter);
    }

    public CmsFolder readAncestor(String resourcename, int type) throws CmsException {
        return this.readAncestor(resourcename, CmsResourceFilter.requireType(type));
    }

    public I_CmsHistoryResource readBackupFile(CmsUUID structureId, int publishTag) throws CmsException {
        return this.readResourceByPublishTag(structureId, publishTag);
    }

    public I_CmsHistoryResource readBackupFile(String filename, int publishTag) throws CmsException {
        CmsResource resource = this.readResource(filename, CmsResourceFilter.ALL);
        return this.readResourceByPublishTag(resource.getStructureId(), publishTag);
    }

    public CmsHistoryProject readBackupProject(int tagId) throws CmsException {
        return this.readHistoryProject(tagId);
    }

    public List readBackupPropertyObjects(I_CmsHistoryResource resource) throws CmsException {
        return this.readHistoryPropertyObjects(resource);
    }

    public CmsResource readDefaultFile(String resourceNameOrID) throws CmsException, CmsSecurityException {
        CmsResource resource;
        try {
            resource = this.readResource(new CmsUUID(resourceNameOrID));
        }
        catch (NumberFormatException e) {
            resource = this.readResource(resourceNameOrID);
        }
        return this.m_securityManager.readDefaultFile(this.m_context, resource);
    }

    public List readDeletedResources(String resourcename, boolean readTree) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readDeletedResources(this.m_context, resource, readTree);
    }

    public CmsFile readFile(CmsResource resource) throws CmsException {
        CmsFile file;
        if (resource instanceof CmsFile && (file = (CmsFile)resource).getContents() != null && file.getContents().length > 0) {
            return file;
        }
        return this.m_securityManager.readFile(this.m_context, resource);
    }

    public CmsFile readFile(String resourcename) throws CmsException {
        return this.readFile(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsFile readFile(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, filter);
        return this.readFile(resource);
    }

    public CmsResource readFileHeader(String resourcename) throws CmsException {
        return this.readResource(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsFolder readFolder(String resourcename) throws CmsException {
        return this.readFolder(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsFolder readFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readFolder(this.m_context, this.addSiteRoot(resourcename), filter);
    }

    public CmsGroup readGroup(CmsProject project) {
        return this.m_securityManager.readGroup(this.m_context, project);
    }

    public CmsGroup readGroup(CmsUUID groupId) throws CmsException {
        return this.m_securityManager.readGroup(this.m_context, groupId);
    }

    public CmsGroup readGroup(String groupName) throws CmsException {
        return this.m_securityManager.readGroup(this.m_context, groupName);
    }

    public CmsHistoryPrincipal readHistoryPrincipal(CmsUUID principalId) throws CmsException {
        return this.m_securityManager.readHistoricalPrincipal(this.m_context, principalId);
    }

    public CmsHistoryProject readHistoryProject(CmsUUID projectId) throws CmsException {
        return this.m_securityManager.readHistoryProject(this.m_context, projectId);
    }

    public CmsHistoryProject readHistoryProject(int publishTag) throws CmsException {
        return this.m_securityManager.readHistoryProject(this.m_context, publishTag);
    }

    public List readHistoryPropertyObjects(I_CmsHistoryResource resource) throws CmsException {
        return this.m_securityManager.readHistoryPropertyObjects(this.m_context, resource);
    }

    public CmsGroup readManagerGroup(CmsProject project) {
        return this.m_securityManager.readManagerGroup(this.m_context, project);
    }

    public CmsUser readOwner(CmsProject project) throws CmsException {
        return this.m_securityManager.readOwner(this.m_context, project);
    }

    public List readPath(String path, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readPath(this.m_context, this.addSiteRoot(path), filter);
    }

    public CmsProject readProject(CmsUUID id) throws CmsException {
        return this.m_securityManager.readProject(id);
    }

    public CmsProject readProject(int id) throws CmsException {
        return this.readProject(this.m_securityManager.getProjectId(this.m_context, id));
    }

    public CmsProject readProject(String name) throws CmsException {
        return this.m_securityManager.readProject(name);
    }

    public List readProjectResources(CmsProject project) throws CmsException {
        return this.m_securityManager.readProjectResources(this.m_context, project);
    }

    public List readProjectView(CmsUUID projectId, CmsResourceState state) throws CmsException {
        return this.m_securityManager.readProjectView(this.m_context, projectId, state);
    }

    public List readProjectView(int projectId, CmsResourceState state) throws CmsException {
        return this.readProjectView(this.m_securityManager.getProjectId(this.m_context, projectId), state);
    }

    public List readProjectView(int projectId, int state) throws CmsException {
        return this.readProjectView(this.m_securityManager.getProjectId(this.m_context, projectId), CmsResourceState.valueOf(state));
    }

    public Map readProperties(String resourcePath) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        List properties = this.m_securityManager.readPropertyObjects(this.m_context, resource, false);
        return CmsProperty.toMap(properties);
    }

    public Map readProperties(String resourcePath, boolean search) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        List properties = this.m_securityManager.readPropertyObjects(this.m_context, resource, search);
        return CmsProperty.toMap(properties);
    }

    public String readProperty(String resourcePath, String property) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        CmsProperty value = this.m_securityManager.readPropertyObject(this.m_context, resource, property, false);
        return value.isNullProperty() ? null : value.getValue();
    }

    public String readProperty(String resourcePath, String property, boolean search) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        CmsProperty value = this.m_securityManager.readPropertyObject(this.m_context, resource, property, search);
        return value.isNullProperty() ? null : value.getValue();
    }

    public String readProperty(String resourcePath, String property, boolean search, String propertyDefault) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        CmsProperty value = this.m_securityManager.readPropertyObject(this.m_context, resource, property, search);
        return value.isNullProperty() ? propertyDefault : value.getValue();
    }

    public CmsPropertyDefinition readPropertyDefinition(String name) throws CmsException {
        return this.m_securityManager.readPropertyDefinition(this.m_context, name);
    }

    public CmsProperty readPropertyObject(CmsResource resource, String property, boolean search) throws CmsException {
        return this.m_securityManager.readPropertyObject(this.m_context, resource, property, search);
    }

    public CmsProperty readPropertyObject(String resourcePath, String property, boolean search) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        return this.m_securityManager.readPropertyObject(this.m_context, resource, property, search);
    }

    public List readPropertyObjects(CmsResource resource, boolean search) throws CmsException {
        return this.m_securityManager.readPropertyObjects(this.m_context, resource, search);
    }

    public List readPropertyObjects(String resourcePath, boolean search) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        return this.m_securityManager.readPropertyObjects(this.m_context, resource, search);
    }

    public List readPublishedResources(CmsUUID publishHistoryId) throws CmsException {
        return this.m_securityManager.readPublishedResources(this.m_context, publishHistoryId);
    }

    public CmsResource readResource(CmsUUID structureID) throws CmsException {
        return this.readResource(structureID, CmsResourceFilter.DEFAULT);
    }

    public CmsResource readResource(CmsUUID structureID, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readResource(this.m_context, structureID, filter);
    }

    public I_CmsHistoryResource readResource(CmsUUID structureID, int version) throws CmsException, CmsVfsResourceNotFoundException {
        CmsResource resource = this.readResource(structureID, CmsResourceFilter.ALL);
        return this.m_securityManager.readResource(this.m_context, resource, version);
    }

    public CmsResource readResource(String resourcename) throws CmsException {
        return this.readResource(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsResource readResource(String resourcename, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readResource(this.m_context, this.addSiteRoot(resourcename), filter);
    }

    public I_CmsHistoryResource readResourceByPublishTag(CmsUUID structureId, int publishTag) throws CmsException {
        CmsResource resource = this.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.readResourceForPublishTag(this.m_context, resource, publishTag);
    }

    public List readResources(String resourcename, CmsResourceFilter filter) throws CmsException {
        return this.readResources(resourcename, filter, true);
    }

    public List readResources(String resourcename, CmsResourceFilter filter, boolean readTree) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readResources(this.m_context, resource, filter, readTree);
    }

    public List readResourcesWithProperty(String propertyDefinition) throws CmsException {
        return this.readResourcesWithProperty("/", propertyDefinition);
    }

    public List readResourcesWithProperty(String path, String propertyDefinition) throws CmsException {
        return this.readResourcesWithProperty(path, propertyDefinition, null);
    }

    public List readResourcesWithProperty(String path, String propertyDefinition, String value) throws CmsException {
        CmsResource resource = this.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.readResourcesWithProperty(this.m_context, resource, propertyDefinition, value, CmsResourceFilter.ALL);
    }

    public List readResourcesWithProperty(String path, String propertyDefinition, String value, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.readResourcesWithProperty(this.m_context, resource, propertyDefinition, value, filter);
    }

    public Set readResponsiblePrincipals(CmsResource resource) throws CmsException {
        return this.m_securityManager.readResponsiblePrincipals(this.m_context, resource);
    }

    public Set readResponsibleUsers(CmsResource resource) throws CmsException {
        return this.m_securityManager.readResponsibleUsers(this.m_context, resource);
    }

    public List readSiblings(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, filter);
        return this.m_securityManager.readSiblings(this.m_context, resource, filter);
    }

    public String readStaticExportPublishedResourceParameters(String rfsName) throws CmsException {
        return this.m_securityManager.readStaticExportPublishedResourceParameters(this.m_context, rfsName);
    }

    public List readStaticExportResources(int parameterResources, long timestamp) throws CmsException {
        return this.m_securityManager.readStaticExportResources(this.m_context, parameterResources, timestamp);
    }

    public CmsUser readUser(CmsUUID userId) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, userId);
    }

    public CmsUser readUser(String username) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, username);
    }

    public CmsUser readUser(String username, String password) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, username, password);
    }

    public CmsUser readWebUser(String username) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, username);
    }

    public CmsUser readWebUser(String username, String password) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, username, password);
    }

    public void removeResourceFromProject(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).removeResourceFromProject(this, this.m_securityManager, resource);
    }

    public void removeUserFromGroup(String username, String groupname) throws CmsException {
        this.m_securityManager.removeUserFromGroup(this.m_context, username, groupname, false);
    }

    public void renameResource(String source, String destination) throws CmsException {
        this.moveResource(source, destination);
    }

    public void replaceResource(String resourcename, int type, byte[] content, List properties) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).replaceResource(this, this.m_securityManager, resource, type, content, properties);
    }

    public void restoreDeletedResource(CmsUUID structureId) throws CmsException {
        this.m_securityManager.restoreDeletedResource(this.m_context, structureId);
    }

    public void restoreResourceBackup(String resourcename, int publishTag) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        I_CmsHistoryResource history = this.readResourceByPublishTag(resource.getStructureId(), publishTag);
        this.restoreResourceVersion(resource.getStructureId(), history.getVersion());
    }

    public void restoreResourceVersion(CmsUUID structureId, int version) throws CmsException {
        CmsResource resource = this.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).restoreResource(this, this.m_securityManager, resource, version);
    }

    public void rmacc(String resourceName, String principalType, String principalName) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        if (CmsUUID.isValidUUID(principalName)) {
            this.m_securityManager.removeAccessControlEntry(this.m_context, res, new CmsUUID(principalName));
        } else {
            try {
                I_CmsPrincipal principal = CmsPrincipal.readPrincipal(this, principalType, principalName);
                this.m_securityManager.removeAccessControlEntry(this.m_context, res, principal.getId());
            }
            catch (CmsDbEntryNotFoundException e) {
                CmsRole role = CmsRole.valueOfRoleName(principalName);
                if (role == null) {
                    throw e;
                }
                this.m_securityManager.removeAccessControlEntry(this.m_context, res, role.getId());
            }
        }
    }

    public void setDateExpired(String resourcename, long dateExpired, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).setDateExpired(this, this.m_securityManager, resource, dateExpired, recursive);
    }

    public void setDateLastModified(String resourcename, long dateLastModified, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).setDateLastModified(this, this.m_securityManager, resource, dateLastModified, recursive);
    }

    public void setDateReleased(String resourcename, long dateReleased, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).setDateReleased(this, this.m_securityManager, resource, dateReleased, recursive);
    }

    public void setParentGroup(String groupName, String parentGroupName) throws CmsException {
        this.m_securityManager.setParentGroup(this.m_context, groupName, parentGroupName);
    }

    public void setPassword(String username, String newPassword) throws CmsException {
        this.m_securityManager.setPassword(this.m_context, username, newPassword);
    }

    public void setPassword(String username, String oldPassword, String newPassword) throws CmsException {
        this.m_securityManager.resetPassword(this.m_context, username, oldPassword, newPassword);
    }

    public void touch(String resourcename, long dateLastModified, long dateReleased, long dateExpired, boolean recursive) throws CmsException {
        if (dateReleased != -1L) {
            this.setDateReleased(resourcename, dateReleased, recursive);
        }
        if (dateExpired != -1L) {
            this.setDateExpired(resourcename, dateExpired, recursive);
        }
        if (dateLastModified != -1L) {
            this.setDateLastModified(resourcename, dateLastModified, recursive);
        }
    }

    public void undeleteResource(String resourcename) throws CmsException {
        this.undeleteResource(resourcename, false);
    }

    public void undeleteResource(String resourcename, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).undelete(this, this.m_securityManager, resource, recursive);
    }

    public void undoChanges(String resourcename, boolean recursive) throws CmsException {
        if (recursive) {
            this.undoChanges(resourcename, CmsResource.UNDO_CONTENT_RECURSIVE);
        } else {
            this.undoChanges(resourcename, CmsResource.UNDO_CONTENT);
        }
    }

    public void undoChanges(String resourcename, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).undoChanges(this, this.m_securityManager, resource, mode);
    }

    public void unlockProject(CmsUUID id) throws CmsException {
        this.m_securityManager.unlockProject(this.m_context, id);
    }

    public void unlockProject(int id) throws CmsException {
        this.unlockProject(this.m_securityManager.getProjectId(this.m_context, id));
    }

    public void unlockResource(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).unlockResource(this, this.m_securityManager, resource);
    }

    public boolean userInGroup(String username, String groupname) throws CmsException {
        return this.m_securityManager.userInGroup(this.m_context, username, groupname);
    }

    public void validatePassword(String password) throws CmsSecurityException {
        this.m_securityManager.validatePassword(password);
    }

    public CmsFile writeFile(CmsFile resource) throws CmsException {
        return this.getResourceType(resource).writeFile(this, this.m_securityManager, resource);
    }

    public void writeFileHeader(CmsFile file) throws CmsException {
        this.writeResource(file);
    }

    public void writeGroup(CmsGroup group) throws CmsException {
        this.m_securityManager.writeGroup(this.m_context, group);
    }

    public void writeHistoryProject(int publishTag, long publishDate) throws CmsException {
        this.m_securityManager.writeHistoryProject(this.m_context, publishTag, publishDate);
    }

    public void writeProject(CmsProject project) throws CmsException {
        this.m_securityManager.writeProject(this.m_context, project);
    }

    public void writeProperties(String resourceName, Map properties) throws CmsException {
        this.writePropertyObjects(resourceName, CmsProperty.toList(properties));
    }

    public void writeProperties(String name, Map properties, boolean addDefinition) throws CmsException {
        this.writePropertyObjects(name, CmsProperty.setAutoCreatePropertyDefinitions(CmsProperty.toList(properties), addDefinition));
    }

    public void writeProperty(String resourceName, String key, String value) throws CmsException {
        CmsProperty property = new CmsProperty();
        property.setName(key);
        property.setStructureValue(value);
        this.writePropertyObject(resourceName, property);
    }

    public void writeProperty(String resourcename, String key, String value, boolean addDefinition) throws CmsException {
        CmsProperty property = new CmsProperty();
        property.setName(key);
        property.setStructureValue(value);
        property.setAutoCreatePropertyDefinition(addDefinition);
        this.writePropertyObject(resourcename, property);
    }

    public void writePropertyObject(String resourcename, CmsProperty property) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).writePropertyObject(this, this.m_securityManager, resource, property);
    }

    public void writePropertyObjects(String resourcename, List properties) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).writePropertyObjects(this, this.m_securityManager, resource, properties);
    }

    public void writeResource(CmsResource resource) throws CmsException {
        this.m_securityManager.writeResource(this.m_context, resource);
    }

    public void writeStaticExportPublishedResource(String resourceName, int linkType, String linkParameter, long timestamp) throws CmsException {
        this.m_securityManager.writeStaticExportPublishedResource(this.m_context, resourceName, linkType, linkParameter, timestamp);
    }

    public void writeUser(CmsUser user) throws CmsException {
        this.m_securityManager.writeUser(this.m_context, user);
    }

    public void writeWebUser(CmsUser user) throws CmsException {
        this.m_securityManager.writeUser(this.m_context, user);
    }

    private String addSiteRoot(String resourcename) {
        return this.m_context.addSiteRoot(resourcename);
    }

    private void createRelation(String resourceName, String targetPath, String relationType, boolean importCase) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsResource target = this.readResource(targetPath, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsRelationType type = CmsRelationType.valueOf(relationType);
        this.m_securityManager.addRelationToResource(this.m_context, resource, target, type, importCase);
    }

    private void fireEvent(int type, Object data) {
        OpenCms.fireCmsEvent(type, Collections.singletonMap("data", data));
    }

    private I_CmsResourceType getResourceType(CmsResource resource) {
        return OpenCms.getResourceManager().getResourceType(resource);
    }

    private I_CmsResourceType getResourceType(int resourceType) throws CmsException {
        return OpenCms.getResourceManager().getResourceType(resourceType);
    }

    private void init(CmsSecurityManager securityManager, CmsRequestContext context) {
        this.m_securityManager = securityManager;
        this.m_context = context;
    }

    private void lockResource(String resourcename, CmsLockType type) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).lockResource(this, this.m_securityManager, resource, type);
    }
}

