/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.opencms.file.Messages;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;

public class CmsProperty
implements Serializable,
Cloneable,
Comparable {
    public static final int DELETE_OPTION_DELETE_RESOURCE_VALUES = 3;
    public static final int DELETE_OPTION_DELETE_STRUCTURE_AND_RESOURCE_VALUES = 1;
    public static final int DELETE_OPTION_DELETE_STRUCTURE_VALUES = 2;
    public static final String DELETE_VALUE = "";
    public static final int RESOURCE_RECORD_MAPPING = 2;
    public static final int STRUCTURE_RECORD_MAPPING = 1;
    public static final String TYPE_INDIVIDUAL = "individual";
    public static final String TYPE_SHARED = "shared";
    public static final char VALUE_LIST_DELIMITER = '|';
    public static final String VALUE_LIST_DELIMITER_REPLACEMENT = "%(ld)";
    public static final char VALUE_MAP_DELIMITER = '=';
    public static final String VALUE_MAP_DELIMITER_REPLACEMENT = "%(md)";
    private static final CmsProperty NULL_PROPERTY = new CmsProperty();
    private static final long serialVersionUID = 93613508924212782L;
    private boolean m_autoCreatePropertyDefinition;
    private boolean m_frozen;
    private String m_name;
    private String m_resourceValue;
    private List m_resourceValueList;
    private Map m_resourceValueMap;
    private String m_structureValue;
    private List m_structureValueList;
    private Map m_structureValueMap;

    public CmsProperty() {
    }

    public CmsProperty(String name, String structureValue, String resourceValue) {
        this(name, structureValue, resourceValue, true);
    }

    public CmsProperty(String name, String structureValue, String resourceValue, boolean autoCreatePropertyDefinition) {
        this.m_name = name;
        this.m_structureValue = structureValue;
        this.m_resourceValue = resourceValue;
        this.m_autoCreatePropertyDefinition = autoCreatePropertyDefinition;
    }

    public static final CmsProperty get(String name, List list) {
        CmsProperty property = null;
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                property = (CmsProperty)list.get(i);
                if (!property.m_name.equals(name)) continue;
                return property;
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                property = (CmsProperty)i.next();
                if (!property.m_name.equals(name)) continue;
                return property;
            }
        }
        return NULL_PROPERTY;
    }

    public static final CmsProperty getNullProperty() {
        return NULL_PROPERTY;
    }

    public static final List setAutoCreatePropertyDefinitions(List list, boolean value) {
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CmsProperty property = (CmsProperty)list.get(i);
                property.m_autoCreatePropertyDefinition = value;
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                CmsProperty property = (CmsProperty)i.next();
                property.m_autoCreatePropertyDefinition = value;
            }
        }
        return list;
    }

    public static final List setFrozen(List list) {
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CmsProperty property = (CmsProperty)list.get(i);
                if (property.isFrozen()) continue;
                property.setFrozen(true);
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                CmsProperty property = (CmsProperty)i.next();
                if (property.isFrozen()) continue;
                property.setFrozen(true);
            }
        }
        return list;
    }

    public static List toList(Map map) {
        if (map == null || map.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>(map.size());
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String name = String.valueOf(e.getKey());
            String value = String.valueOf(e.getValue());
            CmsProperty property = new CmsProperty(name, value, null);
            result.add(property);
        }
        return result;
    }

    public static Map toMap(List list) {
        if (list == null || list.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        String name = null;
        String value = null;
        CmsProperty property = null;
        HashMap<String, String> result = new HashMap<String, String>(list.size());
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                property = (CmsProperty)list.get(i);
                name = property.m_name;
                value = property.getValue();
                result.put(name, value);
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                property = (CmsProperty)i.next();
                name = property.m_name;
                value = property.getValue();
                result.put(name, value);
            }
        }
        return result;
    }

    public boolean autoCreatePropertyDefinition() {
        return this.m_autoCreatePropertyDefinition;
    }

    public Object clone() {
        return this.cloneAsProperty();
    }

    public CmsProperty cloneAsProperty() {
        if (this == NULL_PROPERTY) {
            return NULL_PROPERTY;
        }
        CmsProperty clone = new CmsProperty();
        clone.m_name = this.m_name;
        clone.m_structureValue = this.m_structureValue;
        clone.m_structureValueList = this.m_structureValueList;
        clone.m_resourceValue = this.m_resourceValue;
        clone.m_resourceValueList = this.m_resourceValueList;
        clone.m_autoCreatePropertyDefinition = this.m_autoCreatePropertyDefinition;
        return clone;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsProperty) {
            return this.m_name.compareTo(((CmsProperty)obj).m_name);
        }
        return 0;
    }

    public boolean deleteResourceValue() {
        return this.isDeleteResourceValue();
    }

    public boolean deleteStructureValue() {
        return this.isDeleteStructureValue();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsProperty) {
            return ((CmsProperty)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public String getKey() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getResourceValue() {
        return this.m_resourceValue;
    }

    public List getResourceValueList() {
        if (this.m_resourceValueList == null && this.m_resourceValue != null) {
            this.m_resourceValueList = this.createListFromValue(this.m_resourceValue);
            this.m_resourceValueList = Collections.unmodifiableList(this.m_resourceValueList);
        }
        return this.m_resourceValueList;
    }

    public Map getResourceValueMap() {
        if (this.m_resourceValueMap == null && this.m_resourceValue != null) {
            this.m_resourceValueMap = this.createMapFromValue(this.m_resourceValue);
            this.m_resourceValueMap = Collections.unmodifiableMap(this.m_resourceValueMap);
        }
        return this.m_resourceValueMap;
    }

    public String getStructureValue() {
        return this.m_structureValue;
    }

    public List getStructureValueList() {
        if (this.m_structureValueList == null && this.m_structureValue != null) {
            this.m_structureValueList = this.createListFromValue(this.m_structureValue);
            this.m_structureValueList = Collections.unmodifiableList(this.m_structureValueList);
        }
        return this.m_structureValueList;
    }

    public Map getStructureValueMap() {
        if (this.m_structureValueMap == null && this.m_structureValue != null) {
            this.m_structureValueMap = this.createMapFromValue(this.m_structureValue);
            this.m_structureValueMap = Collections.unmodifiableMap(this.m_structureValueMap);
        }
        return this.m_structureValueMap;
    }

    public String getValue() {
        return this.m_structureValue != null ? this.m_structureValue : this.m_resourceValue;
    }

    public String getValue(String defaultValue) {
        if (this == NULL_PROPERTY) {
            return defaultValue;
        }
        return this.m_structureValue != null ? this.m_structureValue : (this.m_resourceValue != null ? this.m_resourceValue : defaultValue);
    }

    public List getValueList() {
        return this.m_structureValue != null ? this.getStructureValueList() : this.getResourceValueList();
    }

    public List getValueList(List defaultValue) {
        if (this == NULL_PROPERTY) {
            return defaultValue;
        }
        return this.m_structureValue != null ? this.getStructureValueList() : (this.m_resourceValue != null ? this.getResourceValueList() : defaultValue);
    }

    public Map getValueMap() {
        return this.m_structureValue != null ? this.getStructureValueMap() : this.getResourceValueMap();
    }

    public Map getValueMap(Map defaultValue) {
        if (this == NULL_PROPERTY) {
            return defaultValue;
        }
        return this.m_structureValue != null ? this.getStructureValueMap() : (this.m_resourceValue != null ? this.getResourceValueMap() : defaultValue);
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean isDeleteResourceValue() {
        return this.m_resourceValue == DELETE_VALUE || this.m_resourceValue != null && this.m_resourceValue.length() == 0;
    }

    public boolean isDeleteStructureValue() {
        return this.m_structureValue == DELETE_VALUE || this.m_structureValue != null && this.m_structureValue.length() == 0;
    }

    public boolean isFrozen() {
        return this.m_frozen;
    }

    public boolean isIdentical(CmsProperty property) {
        boolean isEqual = this.m_name == null ? property.getName() == null : this.m_name.equals(property.getName());
        isEqual = this.m_structureValue == null ? (isEqual &= property.getStructureValue() == null) : (isEqual &= this.m_structureValue.equals(property.getStructureValue()));
        isEqual = this.m_resourceValue == null ? (isEqual &= property.getResourceValue() == null) : (isEqual &= this.m_resourceValue.equals(property.getResourceValue()));
        return isEqual;
    }

    public boolean isNullProperty() {
        return NULL_PROPERTY.equals(this);
    }

    public void setAutoCreatePropertyDefinition(boolean value) {
        this.checkFrozen();
        this.m_autoCreatePropertyDefinition = value;
    }

    public void setFrozen(boolean frozen) {
        if (!frozen) {
            this.checkFrozen();
        }
        this.m_frozen = frozen;
    }

    public void setKey(String name) {
        this.checkFrozen();
        this.setName(name);
    }

    public void setName(String name) {
        this.checkFrozen();
        this.m_name = name;
    }

    public void setResourceValue(String resourceValue) {
        this.checkFrozen();
        this.m_resourceValue = resourceValue;
        this.m_resourceValueList = null;
    }

    public void setResourceValueList(List valueList) {
        this.checkFrozen();
        if (valueList != null) {
            this.m_resourceValueList = new ArrayList(valueList);
            this.m_resourceValueList = Collections.unmodifiableList(this.m_resourceValueList);
            this.m_resourceValue = this.createValueFromList(this.m_resourceValueList);
        } else {
            this.m_resourceValueList = null;
            this.m_resourceValue = null;
        }
    }

    public void setResourceValueMap(Map valueMap) {
        this.checkFrozen();
        if (valueMap != null) {
            this.m_resourceValueMap = new HashMap(valueMap);
            this.m_resourceValueMap = Collections.unmodifiableMap(this.m_resourceValueMap);
            this.m_resourceValue = this.createValueFromMap(this.m_resourceValueMap);
        } else {
            this.m_resourceValueMap = null;
            this.m_resourceValue = null;
        }
    }

    public void setStructureValue(String structureValue) {
        this.checkFrozen();
        this.m_structureValue = structureValue;
        this.m_structureValueList = null;
    }

    public void setStructureValueList(List valueList) {
        this.checkFrozen();
        if (valueList != null) {
            this.m_structureValueList = new ArrayList(valueList);
            this.m_structureValueList = Collections.unmodifiableList(this.m_structureValueList);
            this.m_structureValue = this.createValueFromList(this.m_structureValueList);
        } else {
            this.m_structureValueList = null;
            this.m_structureValue = null;
        }
    }

    public void setStructureValueMap(Map valueMap) {
        this.checkFrozen();
        if (valueMap != null) {
            this.m_structureValueMap = new HashMap(valueMap);
            this.m_structureValueMap = Collections.unmodifiableMap(this.m_structureValueMap);
            this.m_structureValue = this.createValueFromMap(this.m_structureValueMap);
        } else {
            this.m_structureValueMap = null;
            this.m_structureValue = null;
        }
    }

    public void setValue(String value, String type) {
        this.checkFrozen();
        this.setAutoCreatePropertyDefinition(true);
        if (TYPE_SHARED.equalsIgnoreCase(type)) {
            this.setResourceValue(value);
        } else {
            this.setStructureValue(value);
        }
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("[").append(this.getClass().getName()).append(": ");
        strBuf.append("name: '").append(this.m_name).append("'");
        strBuf.append(", value: '").append(this.getValue()).append("'");
        strBuf.append(", structure value: '").append(this.m_structureValue).append("'");
        strBuf.append(", resource value: '").append(this.m_resourceValue).append("'");
        strBuf.append(", frozen: ").append(this.m_frozen);
        strBuf.append("]");
        return strBuf.toString();
    }

    private void checkFrozen() {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_PROPERTY_FROZEN_1", this.toString()));
        }
    }

    private List createListFromValue(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<String> result = CmsStringUtil.splitAsList(value, '|');
        if (value.indexOf(VALUE_LIST_DELIMITER_REPLACEMENT) != -1) {
            ArrayList<String> tempList = new ArrayList<String>(result.size());
            Iterator i = result.iterator();
            while (i.hasNext()) {
                String item = (String)i.next();
                tempList.add(this.rebuildDelimiter(item, '|', VALUE_LIST_DELIMITER_REPLACEMENT));
            }
            result = tempList;
        }
        return result;
    }

    private Map createMapFromValue(String value) {
        if (value == null) {
            return null;
        }
        List entries = this.createListFromValue(value);
        Iterator i = entries.iterator();
        HashMap<String, String> result = new HashMap<String, String>(entries.size());
        boolean rebuildDelimiters = false;
        if (value.indexOf(VALUE_MAP_DELIMITER_REPLACEMENT) != -1) {
            rebuildDelimiters = true;
        }
        while (i.hasNext()) {
            String entry = (String)i.next();
            int index = entry.indexOf(61);
            if (index == -1) continue;
            String key = entry.substring(0, index);
            String val = DELETE_VALUE;
            if (index + 1 < entry.length()) {
                val = entry.substring(index + 1);
            }
            if (!CmsStringUtil.isNotEmpty(key)) continue;
            if (rebuildDelimiters) {
                key = this.rebuildDelimiter(key, '=', VALUE_MAP_DELIMITER_REPLACEMENT);
                val = this.rebuildDelimiter(val, '=', VALUE_MAP_DELIMITER_REPLACEMENT);
            }
            result.put(key, val);
        }
        return result;
    }

    private String createValueFromList(List valueList) {
        if (valueList == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(valueList.size() * 32);
        Iterator i = valueList.iterator();
        while (i.hasNext()) {
            result.append(this.replaceDelimiter(i.next().toString(), '|', VALUE_LIST_DELIMITER_REPLACEMENT));
            if (!i.hasNext()) continue;
            result.append('|');
        }
        return result.toString();
    }

    private String createValueFromMap(Map valueMap) {
        if (valueMap == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(valueMap.size() * 32);
        Iterator i = valueMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            key = this.replaceDelimiter(key, '|', VALUE_LIST_DELIMITER_REPLACEMENT);
            key = this.replaceDelimiter(key, '=', VALUE_MAP_DELIMITER_REPLACEMENT);
            value = this.replaceDelimiter(value, '|', VALUE_LIST_DELIMITER_REPLACEMENT);
            value = this.replaceDelimiter(value, '=', VALUE_MAP_DELIMITER_REPLACEMENT);
            result.append(key);
            result.append('=');
            result.append(value);
            if (!i.hasNext()) continue;
            result.append('|');
        }
        return result.toString();
    }

    private String rebuildDelimiter(String value, char delimiter, String delimiterReplacement) {
        return CmsStringUtil.substitute(value, delimiterReplacement, String.valueOf(delimiter));
    }

    private String replaceDelimiter(String value, char delimiter, String delimiterReplacement) {
        return CmsStringUtil.substitute(value, String.valueOf(delimiter), delimiterReplacement);
    }

    static {
        CmsProperty.NULL_PROPERTY.m_frozen = true;
        CmsProperty.NULL_PROPERTY.m_name = DELETE_VALUE;
    }
}

