/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUser
extends CmsPrincipal
implements I_CmsPrincipal,
Cloneable {
    private Map m_additionalInfo;
    private long m_dateCreated;
    private String m_email;
    private String m_firstname;
    private boolean m_isTouched;
    private long m_lastlogin;
    private String m_lastname;
    private String m_password;

    public CmsUser() {
        this(null, "", "", "", "", "", 0L, 0, System.currentTimeMillis(), Collections.singletonMap("USER_DESCRIPTION", ""));
    }

    public CmsUser(CmsUUID id, String name, String password, String firstname, String lastname, String email, long lastlogin, int flags, long dateCreated, Map additionalInfo) {
        this.m_id = id;
        this.m_name = name;
        this.m_password = password;
        this.m_firstname = firstname;
        this.m_lastname = lastname;
        this.m_email = email;
        this.m_lastlogin = lastlogin;
        this.m_flags = flags;
        this.m_dateCreated = dateCreated;
        this.m_additionalInfo = additionalInfo != null ? new HashMap(additionalInfo) : new HashMap();
        if (this.m_additionalInfo.get("USER_ADDRESS") == null) {
            this.m_additionalInfo.put("USER_ADDRESS", "");
        }
        if (this.m_additionalInfo.get("USER_DESCRIPTION") == null) {
            this.m_additionalInfo.put("USER_DESCRIPTION", "");
        }
    }

    public static void checkEmail(String email) {
        OpenCms.getValidationHandler().checkEmail(email);
    }

    public static void checkZipCode(String zipcode) {
        OpenCms.getValidationHandler().checkZipCode(zipcode);
    }

    public static String getFullName(CmsUser user) {
        if (user == null) {
            return "";
        }
        return user.getFullName();
    }

    public static boolean isSystemUser(int type) {
        return (type & 1) > 0;
    }

    public void checkName(String name) throws CmsIllegalArgumentException {
        OpenCms.getValidationHandler().checkUserName(name);
    }

    public Object clone() {
        return new CmsUser(this.m_id, this.m_name, this.m_password, this.m_firstname, this.m_lastname, this.m_email, this.m_lastlogin, this.m_flags, this.m_dateCreated, this.m_additionalInfo);
    }

    public void deleteAdditionalInfo(String key) {
        this.m_additionalInfo.remove(key);
    }

    public Map getAdditionalInfo() {
        return this.m_additionalInfo;
    }

    public Object getAdditionalInfo(String key) {
        return this.m_additionalInfo.get(key);
    }

    public String getAddress() {
        return (String)this.getAdditionalInfo("USER_ADDRESS");
    }

    public String getCity() {
        return (String)this.getAdditionalInfo("USER_TOWN");
    }

    public String getCountry() {
        return (String)this.getAdditionalInfo("USER_COUNTRY");
    }

    public long getDateCreated() {
        return this.m_dateCreated;
    }

    public String getDescription() {
        return (String)this.getAdditionalInfo("USER_DESCRIPTION");
    }

    public String getDescription(Locale locale) {
        CmsMacroResolver macroResolver = new CmsMacroResolver();
        macroResolver.setMessages(Messages.get().getBundle(locale));
        return macroResolver.resolveMacros((String)this.getAdditionalInfo("USER_DESCRIPTION"));
    }

    public boolean getDisabled() {
        return !this.isEnabled();
    }

    public String getDisplayName(CmsObject cms, Locale locale) throws CmsException {
        if (OpenCms.getOrgUnitManager().getOrganizationalUnits(cms, "", true).size() > 0) {
            return org.opencms.security.Messages.get().getBundle(locale).key("GUI_PRINCIPAL_DISPLAY_NAME_2", this.getFullName(), OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, this.getOuFqn()).getDisplayName(locale));
        }
        return this.getFullName();
    }

    public String getEmail() {
        return this.m_email;
    }

    public String getFirstname() {
        return this.m_firstname;
    }

    public String getFullName() {
        String last;
        StringBuffer buf = new StringBuffer();
        String first = this.getFirstname();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(first)) {
            buf.append(first);
            buf.append(" ");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(last = this.getLastname())) {
            buf.append(last);
            buf.append(" ");
        }
        buf.append("(");
        buf.append(this.getSimpleName());
        buf.append(")");
        return buf.toString();
    }

    public long getLastlogin() {
        return this.m_lastlogin;
    }

    public String getLastname() {
        return this.m_lastname;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getZipcode() {
        return (String)this.getAdditionalInfo("USER_ZIPCODE");
    }

    public boolean isGroup() {
        return false;
    }

    public boolean isGuestUser() {
        return OpenCms.getDefaultUsers().isUserGuest(this.getName());
    }

    public boolean isManaged() {
        return (this.getFlags() & 2) == 2;
    }

    public boolean isTouched() {
        return this.m_isTouched;
    }

    public boolean isUser() {
        return true;
    }

    public boolean isWebuser() {
        return (this.getFlags() & 0x8000) == 32768;
    }

    public void setAdditionalInfo(Map additionalInfo) {
        this.m_additionalInfo = additionalInfo;
    }

    public void setAdditionalInfo(String key, Object value) {
        this.m_additionalInfo.put(key, value);
    }

    public void setAddress(String address) {
        this.setAdditionalInfo("USER_ADDRESS", address);
    }

    public void setCity(String city) {
        this.setAdditionalInfo("USER_TOWN", city);
    }

    public void setCountry(String country) {
        this.setAdditionalInfo("USER_COUNTRY", country);
    }

    public void setDescription(String description) {
        this.setAdditionalInfo("USER_DESCRIPTION", description);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }

    public void setEmail(String email) {
        CmsUser.checkEmail(email);
        if (email != null) {
            email = email.trim();
        }
        this.m_email = email;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setFirstname(String firstname) {
        OpenCms.getValidationHandler().checkFirstname(firstname);
        if (firstname != null) {
            firstname = firstname.trim();
        }
        this.m_firstname = firstname;
    }

    public void setLastlogin(long value) {
        this.m_isTouched = true;
        this.m_lastlogin = value;
    }

    public void setLastname(String lastname) {
        OpenCms.getValidationHandler().checkLastname(lastname);
        if (lastname != null) {
            lastname = lastname.trim();
        }
        this.m_lastname = lastname;
    }

    public void setManaged(boolean value) {
        if (this.isManaged() != value) {
            this.setFlags(this.getFlags() ^ 2);
        }
    }

    public void setPassword(String value) {
        try {
            OpenCms.getPasswordHandler().validatePassword(value);
        }
        catch (CmsSecurityException e) {
            throw new CmsIllegalArgumentException(e.getMessageContainer());
        }
        this.m_password = value;
    }

    public void setZipcode(String zipcode) {
        CmsUser.checkZipCode(zipcode);
        if (zipcode != null) {
            zipcode = zipcode.toUpperCase();
        }
        this.setAdditionalInfo("USER_ZIPCODE", zipcode);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[User]");
        result.append(" name:");
        result.append(this.getName());
        result.append(" id:");
        result.append(this.m_id);
        result.append(" flags:");
        result.append(this.getFlags());
        result.append(" description:");
        result.append(this.getDescription());
        return result.toString();
    }

    public void touch() {
        this.m_isTouched = true;
    }
}

