/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.PrintfFormat;
import org.opencms.workplace.CmsWorkplace;

public abstract class A_CmsResourceCollector
implements I_CmsResourceCollector {
    private static final String MACRO_NUMBER = "number";
    private static final PrintfFormat NUMBER_FORMAT = new PrintfFormat("%0.4d");
    protected int m_order;
    private String m_defaultCollectorName;
    private String m_defaultCollectorParam;
    private int m_hashcode = this.getClass().getName().hashCode();

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof I_CmsResourceCollector) {
            return this.getOrder() - ((I_CmsResourceCollector)obj).getOrder();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsResourceCollector) {
            return this.getClass().getName().equals(obj.getClass().getName());
        }
        return false;
    }

    public String getCreateLink(CmsObject cms) throws CmsException, CmsDataAccessException {
        this.checkParams();
        return this.getCreateLink(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    public String getCreateParam(CmsObject cms) throws CmsDataAccessException {
        this.checkParams();
        return this.getCreateParam(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    public String getDefaultCollectorName() {
        return this.m_defaultCollectorName;
    }

    public String getDefaultCollectorParam() {
        return this.m_defaultCollectorParam;
    }

    public int getOrder() {
        return this.m_order;
    }

    public List getResults(CmsObject cms) throws CmsDataAccessException, CmsException {
        this.checkParams();
        return this.getResults(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    public void setDefaultCollectorName(String collectorName) {
        this.m_defaultCollectorName = collectorName;
    }

    public void setDefaultCollectorParam(String param) {
        this.m_defaultCollectorParam = param;
    }

    public void setOrder(int order) {
        this.m_order = order;
    }

    protected void checkParams() {
        if (this.m_defaultCollectorName == null || this.m_defaultCollectorParam == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_DEFAULTS_INVALID_2", this.m_defaultCollectorName, this.m_defaultCollectorParam));
        }
    }

    protected String getCreateInFolder(CmsObject cms, CmsCollectorData data) throws CmsException {
        String checkTempFileName;
        String checkFileName;
        String foldername = CmsResource.getFolderPath(data.getFileName());
        List resources = cms.readResources(foldername, CmsResourceFilter.ALL, false);
        ArrayList<String> result = new ArrayList<String>(resources.size());
        for (int i = 0; i < resources.size(); ++i) {
            CmsResource resource = (CmsResource)resources.get(i);
            result.add(resource.getRootPath());
        }
        String fileName = cms.getRequestContext().addSiteRoot(data.getFileName());
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        int j = 0;
        do {
            String number = NUMBER_FORMAT.sprintf(++j);
            resolver.addMacro(MACRO_NUMBER, number);
            checkFileName = resolver.resolveMacros(fileName);
            checkTempFileName = CmsWorkplace.getTemporaryFileName(checkFileName);
        } while (result.contains(checkFileName) || result.contains(checkTempFileName));
        return cms.getRequestContext().removeSiteRoot(checkFileName);
    }

    protected String getCreateInFolder(CmsObject cms, String param) throws CmsException {
        return this.getCreateInFolder(cms, new CmsCollectorData(param));
    }

    protected List shrinkToFit(List result, int maxSize) {
        if (maxSize > 0 && result.size() > maxSize) {
            result = result.subList(0, maxSize);
        }
        return result;
    }
}

