/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;

public class CmsPriorityTitleResourceComparator
implements Serializable,
Comparator {
    private static final long serialVersionUID = -6815638350803584422L;
    private transient CmsObject m_cms;
    private Map m_keys;
    private int m_priority;
    private String m_title;

    public CmsPriorityTitleResourceComparator(CmsObject cms) {
        this.m_cms = cms;
        this.m_keys = new HashMap();
    }

    private static CmsPriorityTitleResourceComparator create(CmsResource resource, CmsObject cms) {
        CmsPriorityTitleResourceComparator result = new CmsPriorityTitleResourceComparator(null);
        result.init(resource, cms);
        return result;
    }

    public int compare(Object arg0, Object arg1) {
        if (arg0 == arg1 || !(arg0 instanceof CmsResource) || !(arg1 instanceof CmsResource)) {
            return 0;
        }
        CmsResource res0 = (CmsResource)arg0;
        CmsResource res1 = (CmsResource)arg1;
        CmsPriorityTitleResourceComparator key0 = (CmsPriorityTitleResourceComparator)this.m_keys.get(res0.getStructureId());
        CmsPriorityTitleResourceComparator key1 = (CmsPriorityTitleResourceComparator)this.m_keys.get(res1.getStructureId());
        if (key0 == null) {
            key0 = CmsPriorityTitleResourceComparator.create(res0, this.m_cms);
            this.m_keys.put(res0.getStructureId(), key0);
        }
        if (key1 == null) {
            key1 = CmsPriorityTitleResourceComparator.create(res1, this.m_cms);
            this.m_keys.put(res1.getStructureId(), key1);
        }
        if (key0.getPriority() > key1.getPriority()) {
            return -1;
        }
        if (key0.getPriority() < key1.getPriority()) {
            return 1;
        }
        Collator collator = Collator.getInstance(this.m_cms.getRequestContext().getLocale());
        return collator.compare(key0.getTitle(), key1.getTitle());
    }

    public int getPriority() {
        return this.m_priority;
    }

    public String getTitle() {
        return this.m_title;
    }

    private void init(CmsResource resource, CmsObject cms) {
        List properties;
        try {
            properties = cms.readPropertyObjects(resource, false);
        }
        catch (CmsException e) {
            this.m_priority = 0;
            this.m_title = "";
            return;
        }
        try {
            this.m_priority = Integer.parseInt(CmsProperty.get("collector.priority", properties).getValue());
        }
        catch (NumberFormatException e) {
            this.m_priority = 3;
        }
        this.m_title = CmsProperty.get("Title", properties).getValue();
        if (CmsStringUtil.isEmpty(this.m_title)) {
            this.m_title = "";
        }
    }
}

