/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.Messages;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsXmlContentLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsResourceTypeXmlContent
extends A_CmsResourceTypeLinkParseable {
    public static final String CONFIGURATION_SCHEMA = "schema";
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeXmlContent.class);
    private String m_schema;

    public static boolean isXmlContent(CmsResource resource) {
        boolean result = false;
        if (resource != null) {
            try {
                result = OpenCms.getResourceManager().getLoader(resource) instanceof CmsXmlContentLoader;
            }
            catch (CmsLoaderException cmsLoaderException) {
                // empty catch block
            }
        }
        return result;
    }

    public void addConfigurationParameter(String paramName, String paramValue) {
        super.addConfigurationParameter(paramName, paramValue);
        if (CONFIGURATION_SCHEMA.equalsIgnoreCase(paramName)) {
            this.m_schema = paramValue.trim();
        }
    }

    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List properties) throws CmsException {
        boolean hasModelUri = false;
        CmsXmlContent newContent = null;
        if (this.m_schema != null && (content == null || content.length == 0)) {
            CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, this.m_schema);
            Locale locale = (Locale)OpenCms.getLocaleManager().getDefaultLocales(cms, CmsResource.getParentFolder(resourcename)).get(0);
            String modelUri = (String)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_MODEL);
            CmsObject newCms = OpenCms.initCmsObject(cms);
            newCms.getRequestContext().setUri(CmsResource.getParentFolder(resourcename));
            if (modelUri != null) {
                newContent = CmsXmlContentFactory.createDocument(newCms, locale, modelUri);
                hasModelUri = true;
            } else {
                newContent = CmsXmlContentFactory.createDocument(newCms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
            }
            content = newContent.marshal();
        }
        CmsResource resource = super.createResource(cms, securityManager, resourcename, content, properties);
        if (hasModelUri) {
            CmsFile file = cms.readFile(resource);
            newContent = CmsXmlContentFactory.unmarshal(cms, file);
            resource = newContent.getContentDefinition().getContentHandler().prepareForWrite(cms, newContent, file);
        }
        return resource;
    }

    public String getCachePropertyDefault() {
        return "element;locale;";
    }

    public Map getConfiguration() {
        Map additional;
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (this.m_schema != null) {
            result.put(CONFIGURATION_SCHEMA, this.m_schema);
        }
        if ((additional = super.getConfiguration()) != null) {
            result.putAll(additional);
        }
        return result;
    }

    public int getLoaderId() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseLinks(CmsObject cms, CmsFile file) {
        CmsXmlContent xmlContent;
        if (file.getLength() == 0) {
            return Collections.EMPTY_LIST;
        }
        long requestTime = cms.getRequestContext().getRequestTime();
        try {
            cms.getRequestContext().setRequestTime(Long.MIN_VALUE);
            xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READ_RESOURCE_1", cms.getSitePath(file)), (Throwable)e);
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            cms.getRequestContext().setRequestTime(requestTime);
        }
        HashSet<CmsLink> links = new HashSet<CmsLink>();
        List locales = xmlContent.getLocales();
        Iterator i = locales.iterator();
        while (i.hasNext()) {
            Locale locale = (Locale)i.next();
            List values = xmlContent.getValues(locale);
            Iterator j = values.iterator();
            while (j.hasNext()) {
                CmsLink link;
                A_CmsXmlContentValue refValue;
                I_CmsXmlContentValue value = (I_CmsXmlContentValue)j.next();
                if (value instanceof CmsXmlHtmlValue) {
                    CmsXmlHtmlValue htmlValue = (CmsXmlHtmlValue)value;
                    CmsLinkTable linkTable = htmlValue.getLinkTable();
                    Iterator k = linkTable.iterator();
                    while (k.hasNext()) {
                        CmsLink link2 = (CmsLink)k.next();
                        if (!link2.isInternal()) continue;
                        link2.checkConsistency(cms);
                        links.add(link2);
                    }
                    continue;
                }
                if (value instanceof CmsXmlVfsFileValue) {
                    refValue = (CmsXmlVfsFileValue)value;
                    link = ((CmsXmlVfsFileValue)refValue).getLink(cms);
                    if (link == null) continue;
                    links.add(link);
                    continue;
                }
                if (!(value instanceof CmsXmlVarLinkValue) || (link = ((CmsXmlVarLinkValue)(refValue = (CmsXmlVarLinkValue)value)).getLink(cms)) == null || !link.isInternal()) continue;
                links.add(link);
            }
        }
        return new ArrayList(links);
    }

    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, resource, false);
        resource = xmlContent.getContentDefinition().getContentHandler().prepareForWrite(cms, xmlContent, resource);
        return super.writeFile(cms, securityManager, resource);
    }
}

