/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsResourceWrapperXmlPage
extends A_CmsResourceWrapper {
    private static final String EXTENSION_ELEMENT = "html";
    private static final String NAME_ELEMENT_CONTROLCODE = "controlcode.xml";
    private static final Hashtable TMP_FILE_TABLE = new Hashtable();

    public List addResourcesToFolder(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource xmlPage = this.findXmlPage(cms, resourcename);
        if (xmlPage != null) {
            String path = this.getSubPath(cms, xmlPage, resourcename);
            String rootPath = cms.getRequestContext().removeSiteRoot(xmlPage.getRootPath());
            ArrayList<CmsResource> ret = new ArrayList<CmsResource>();
            CmsFile file = cms.readFile(xmlPage);
            CmsXmlPage xml = CmsXmlPageFactory.unmarshal(cms, file);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) {
                if (file.getLength() == 0) {
                    return ret;
                }
                List locales = xml.getLocales();
                Iterator iter = locales.iterator();
                while (iter.hasNext()) {
                    Locale locale = (Locale)iter.next();
                    ret.add(this.getResourceForLocale(xmlPage, locale));
                }
                iter = this.getVirtualFiles().iterator();
                while (iter.hasNext()) {
                    String virtualFileName = (String)iter.next();
                    String virtualFilePath = rootPath + "/" + virtualFileName;
                    if (TMP_FILE_TABLE.containsKey(virtualFilePath) && TMP_FILE_TABLE.get(virtualFilePath).equals(new Integer(0)) || !virtualFileName.equals(NAME_ELEMENT_CONTROLCODE)) continue;
                    CmsWrappedResource wrap = new CmsWrappedResource(xmlPage);
                    wrap.setRootPath(xmlPage.getRootPath() + "/" + NAME_ELEMENT_CONTROLCODE);
                    wrap.setTypeId(CmsResourceTypePlain.getStaticTypeId());
                    CmsFile tmpFile = wrap.getFile();
                    tmpFile.setContents(file.getContents());
                    ret.add(tmpFile);
                }
            } else {
                Locale locale = new Locale(path);
                List names = xml.getNames(locale);
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    String content = xml.getStringValue(cms, name, locale);
                    String fullPath = xmlPage.getRootPath() + "/" + path + "/" + name + "." + EXTENSION_ELEMENT;
                    content = this.prepareContent(content, cms, xmlPage, fullPath);
                    int length = content.length();
                    try {
                        length = content.getBytes(CmsLocaleManager.getResourceEncoding(cms, xmlPage)).length;
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    ret.add(this.getResourceForElement(xmlPage, fullPath, length));
                }
            }
            return ret;
        }
        return null;
    }

    public boolean copyResource(CmsObject cms, String source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        CmsResource srcXmlPage = this.findXmlPage(cms, source);
        if (srcXmlPage != null) {
            String srcPath = this.getSubPath(cms, srcXmlPage, source);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(srcPath)) {
                cms.copyResource(source, destination, siblingMode);
                return true;
            }
            CmsResource destXmlPage = this.findXmlPage(cms, destination);
            if (srcXmlPage.equals(destXmlPage)) {
                String[] destTokens;
                String destPath = this.getSubPath(cms, destXmlPage, destination);
                String[] srcTokens = srcPath.split("/");
                if (srcTokens.length == (destTokens = destPath.split("/")).length) {
                    CmsFile srcFile = cms.readFile(srcXmlPage);
                    CmsXmlPage srcXml = CmsXmlPageFactory.unmarshal(cms, srcFile);
                    if (srcTokens.length == 1) {
                        if (!srcTokens[0].equals(NAME_ELEMENT_CONTROLCODE)) {
                            srcXml.copyLocale(new Locale(srcTokens[0]), new Locale(destTokens[0]));
                        }
                    } else if (srcTokens.length == 2) {
                        // empty if block
                    }
                    srcFile.setContents(srcXml.marshal());
                    cms.writeFile(srcFile);
                    return true;
                }
            }
        }
        return false;
    }

    public CmsResource createResource(CmsObject cms, String resourcename, int type, byte[] content, List properties) throws CmsException, CmsIllegalArgumentException {
        if (resourcename.endsWith("/")) {
            resourcename = resourcename.substring(0, resourcename.length() - 1);
        }
        if (type == CmsResourceTypeFolder.getStaticTypeId() && resourcename.endsWith(".html")) {
            Iterator iter = this.getVirtualFiles().iterator();
            while (iter.hasNext()) {
                TMP_FILE_TABLE.put(resourcename + "/" + (String)iter.next(), new Integer(0));
            }
            return cms.createResource(resourcename, CmsResourceTypeXmlPage.getStaticTypeId());
        }
        CmsResource xmlPage = this.findXmlPage(cms, resourcename);
        if (xmlPage != null) {
            String path = this.getSubPath(cms, xmlPage, resourcename);
            String rootPath = cms.getRequestContext().removeSiteRoot(xmlPage.getRootPath());
            CmsFile file = cms.readFile(xmlPage);
            CmsXmlPage xml = CmsXmlPageFactory.unmarshal(cms, file);
            if (this.getVirtualFiles().contains(path)) {
                TMP_FILE_TABLE.remove(resourcename);
                cms.lockResource(rootPath);
                return file;
            }
            String[] tokens = path.split("/");
            if (tokens.length == 1) {
                Locale locale = new Locale(tokens[0]);
                if (file.getLength() == 0) {
                    Iterator iter = xml.getLocales().iterator();
                    while (iter.hasNext()) {
                        xml.removeLocale((Locale)iter.next());
                    }
                }
                xml.addLocale(cms, locale);
                file.setContents(xml.marshal());
                cms.lockResource(rootPath);
                cms.writeFile(file);
            } else if (tokens.length == 2) {
                String name = tokens[1];
                if (name.endsWith(EXTENSION_ELEMENT)) {
                    name = name.substring(0, name.length() - EXTENSION_ELEMENT.length() - 1);
                }
                xml.addValue(name, new Locale(tokens[0]));
                xml.setStringValue(cms, name, new Locale(tokens[0]), this.getStringValue(cms, file, content));
                file.setContents(xml.marshal());
                cms.lockResource(rootPath);
                cms.writeFile(file);
            }
            return file;
        }
        return null;
    }

    public boolean deleteResource(CmsObject cms, String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        CmsResource xmlPage = this.findXmlPage(cms, resourcename);
        if (xmlPage != null) {
            String path;
            if (resourcename.endsWith("/")) {
                resourcename = resourcename.substring(0, resourcename.length() - 1);
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(path = this.getSubPath(cms, xmlPage, resourcename))) {
                cms.deleteResource(resourcename, siblingMode);
                Iterator iter = this.getVirtualFiles().iterator();
                while (iter.hasNext()) {
                    TMP_FILE_TABLE.remove(resourcename + "/" + (String)iter.next());
                }
                return true;
            }
            CmsFile file = cms.readFile(xmlPage);
            CmsXmlPage xml = CmsXmlPageFactory.unmarshal(cms, file);
            String[] tokens = path.split("/");
            if (tokens.length == 1) {
                if (this.getVirtualFiles().contains(tokens[0])) {
                    TMP_FILE_TABLE.put(resourcename, new Integer(0));
                } else {
                    xml.removeLocale(new Locale(tokens[0]));
                    file.setContents(xml.marshal());
                    cms.writeFile(file);
                }
            } else if (tokens.length == 2) {
                String name = tokens[1];
                if (name.endsWith(EXTENSION_ELEMENT)) {
                    name = name.substring(0, name.length() - EXTENSION_ELEMENT.length() - 1);
                }
                xml.removeValue(name, new Locale(tokens[0]));
                file.setContents(xml.marshal());
                cms.writeFile(file);
            }
            return true;
        }
        return false;
    }

    public CmsLock getLock(CmsObject cms, CmsResource resource) throws CmsException {
        I_CmsResourceType resType;
        CmsResource xmlPage = cms.readResource(resource.getStructureId());
        if (xmlPage != null && (resType = OpenCms.getResourceManager().getResourceType(xmlPage.getTypeId())) instanceof CmsResourceTypeXmlPage) {
            return cms.getLock(xmlPage);
        }
        return null;
    }

    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            if (resType instanceof CmsResourceTypeXmlPage) {
                return true;
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return false;
    }

    public boolean lockResource(CmsObject cms, String resourcename) throws CmsException {
        CmsResource res = this.findXmlPage(cms, resourcename);
        if (res != null) {
            cms.lockResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()));
            return true;
        }
        return false;
    }

    public boolean moveResource(CmsObject cms, String source, String destination) throws CmsException, CmsIllegalArgumentException {
        CmsResource srcXmlPage = this.findXmlPage(cms, source);
        if (srcXmlPage != null) {
            String srcPath = this.getSubPath(cms, srcXmlPage, source);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(srcPath)) {
                cms.moveResource(source, destination);
                return true;
            }
            CmsResource destXmlPage = this.findXmlPage(cms, destination);
            if (srcXmlPage.equals(destXmlPage)) {
                String[] destTokens;
                String destPath = this.getSubPath(cms, destXmlPage, destination);
                String[] srcTokens = srcPath.split("/");
                if (srcTokens.length == (destTokens = destPath.split("/")).length) {
                    CmsFile srcFile = cms.readFile(srcXmlPage);
                    CmsXmlPage srcXml = CmsXmlPageFactory.unmarshal(cms, srcFile);
                    if (srcTokens.length == 1) {
                        srcXml.moveLocale(new Locale(srcTokens[0]), new Locale(destTokens[0]));
                    } else if (srcTokens.length == 2) {
                        // empty if block
                    }
                    srcFile.setContents(srcXml.marshal());
                    cms.writeFile(srcFile);
                }
            }
            return true;
        }
        return false;
    }

    public CmsFile readFile(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource xmlPage = this.findXmlPage(cms, resourcename);
        if (xmlPage != null) {
            String path;
            String[] tokens;
            if (resourcename.endsWith("/")) {
                resourcename = resourcename.substring(0, resourcename.length() - 1);
            }
            if ((tokens = (path = this.getSubPath(cms, xmlPage, resourcename)).split("/")).length == 1) {
                CmsFile file = cms.readFile(xmlPage);
                if (TMP_FILE_TABLE.containsKey(resourcename) && TMP_FILE_TABLE.get(resourcename).equals(new Integer(0))) {
                    return null;
                }
                if (tokens[0].equals(NAME_ELEMENT_CONTROLCODE)) {
                    CmsWrappedResource wrap = new CmsWrappedResource(xmlPage);
                    wrap.setRootPath(xmlPage.getRootPath() + "/" + NAME_ELEMENT_CONTROLCODE);
                    CmsFile ret = wrap.getFile();
                    ret.setContents(file.getContents());
                    return ret;
                }
            } else if (tokens.length == 2) {
                CmsFile file = cms.readFile(xmlPage);
                CmsXmlPage xml = CmsXmlPageFactory.unmarshal(cms, file);
                String name = tokens[1];
                if (name.endsWith(".html")) {
                    name = name.substring(0, name.length() - 5);
                }
                if (xml.hasValue(name, new Locale(tokens[0]))) {
                    byte[] content;
                    String contentString = xml.getStringValue(cms, name, new Locale(tokens[0]));
                    String fullPath = xmlPage.getRootPath() + "/" + tokens[0] + "/" + name + "." + EXTENSION_ELEMENT;
                    contentString = this.prepareContent(contentString, cms, xmlPage, fullPath);
                    try {
                        content = contentString.getBytes(CmsLocaleManager.getResourceEncoding(cms, xmlPage));
                    }
                    catch (UnsupportedEncodingException e) {
                        content = contentString.getBytes();
                    }
                    CmsResource resElem = this.getResourceForElement(xmlPage, fullPath, content.length);
                    CmsFile fileElem = new CmsFile(resElem);
                    fileElem.setContents(content);
                    return fileElem;
                }
            }
        }
        return null;
    }

    public CmsResource readResource(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        try {
            CmsResource res = cms.readResource(resourcename, filter);
            if (CmsResourceTypeXmlPage.isXmlPage(res)) {
                return this.wrapResource(cms, res);
            }
            return null;
        }
        catch (CmsVfsResourceNotFoundException ex) {
            CmsResource xmlPage = this.findXmlPage(cms, resourcename);
            if (xmlPage != null) {
                if (resourcename.endsWith("/")) {
                    resourcename = resourcename.substring(0, resourcename.length() - 1);
                }
                String path = this.getSubPath(cms, xmlPage, resourcename);
                CmsFile file = cms.readFile(xmlPage);
                CmsXmlPage xml = CmsXmlPageFactory.unmarshal(cms, file);
                String[] tokens = path.split("/");
                if (tokens.length == 1) {
                    if (TMP_FILE_TABLE.containsKey(resourcename) && TMP_FILE_TABLE.get(resourcename).equals(new Integer(0))) {
                        return null;
                    }
                    if (tokens[0].equals(NAME_ELEMENT_CONTROLCODE)) {
                        CmsWrappedResource wrap = new CmsWrappedResource(xmlPage);
                        wrap.setRootPath(xmlPage.getRootPath() + "/" + NAME_ELEMENT_CONTROLCODE);
                        return wrap.getResource();
                    }
                    Locale locale = new Locale(tokens[0]);
                    if (xml.hasLocale(locale) && file.getLength() > 0) {
                        return this.getResourceForLocale(xmlPage, locale);
                    }
                } else if (tokens.length == 2) {
                    Locale locale;
                    String name = tokens[1];
                    if (name.endsWith(".html")) {
                        name = name.substring(0, name.length() - 5);
                    }
                    if (xml.hasValue(name, locale = new Locale(tokens[0]))) {
                        String content = xml.getStringValue(cms, name, locale);
                        String fullPath = xmlPage.getRootPath() + "/" + tokens[0] + "/" + name + "." + EXTENSION_ELEMENT;
                        content = this.prepareContent(content, cms, xmlPage, fullPath);
                        int length = content.length();
                        try {
                            length = content.getBytes(CmsLocaleManager.getResourceEncoding(cms, xmlPage)).length;
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        return this.getResourceForElement(xmlPage, fullPath, length);
                    }
                }
            }
            return null;
        }
    }

    public String restoreLink(CmsObject cms, String uri) {
        CmsResource res = this.findXmlPage(cms, uri);
        if (res != null) {
            return res.getRootPath();
        }
        return null;
    }

    public String rewriteLink(CmsObject cms, CmsResource res) {
        if (this.isWrappedResource(cms, res)) {
            String path = res.getRootPath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            return path + NAME_ELEMENT_CONTROLCODE;
        }
        return null;
    }

    public boolean unlockResource(CmsObject cms, String resourcename) throws CmsException {
        CmsResource res = this.findXmlPage(cms, resourcename);
        if (res != null) {
            cms.unlockResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()));
            return true;
        }
        return false;
    }

    public CmsResource wrapResource(CmsObject cms, CmsResource res) {
        CmsWrappedResource wrap = new CmsWrappedResource(res);
        wrap.setFolder(true);
        return wrap.getResource();
    }

    public CmsFile writeFile(CmsObject cms, CmsFile resource) throws CmsException {
        I_CmsResourceType resType;
        CmsResource xmlPage = cms.readResource(resource.getStructureId());
        if (xmlPage != null && (resType = OpenCms.getResourceManager().getResourceType(xmlPage.getTypeId())) instanceof CmsResourceTypeXmlPage) {
            String path = this.getSubPath(cms, xmlPage, cms.getRequestContext().removeSiteRoot(resource.getRootPath()));
            CmsFile file = cms.readFile(xmlPage);
            String[] tokens = path.split("/");
            if (tokens.length == 2) {
                CmsXmlPage xml = CmsXmlPageFactory.unmarshal(cms, file);
                String name = tokens[1];
                if (name.endsWith(".html")) {
                    name = name.substring(0, name.length() - 5);
                }
                String content = this.getStringValue(cms, file, resource.getContents());
                content = CmsStringUtil.extractHtmlBody(content).trim();
                xml.setStringValue(cms, name, new Locale(tokens[0]), content);
                file.setContents(xml.marshal());
                cms.writeFile(file);
            }
            return file;
        }
        return null;
    }

    protected String getUriStyleSheet(CmsObject cms, CmsResource res) {
        String result = "";
        try {
            String currentTemplate = this.getUriTemplate(cms, res);
            if (!"".equals(currentTemplate)) {
                result = cms.readPropertyObject(currentTemplate, "template", false).getValue("");
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        return result;
    }

    protected String getUriTemplate(CmsObject cms, CmsResource res) {
        String result = "";
        try {
            result = cms.readPropertyObject(cms.getRequestContext().removeSiteRoot(res.getRootPath()), "template", true).getValue("");
        }
        catch (CmsException e) {
            // empty catch block
        }
        return result;
    }

    protected String prepareContent(String content, CmsObject cms, CmsResource xmlPage, String path) {
        content = CmsStringUtil.extractHtmlBody(content);
        String stylesheet = this.getUriStyleSheet(cms, xmlPage);
        String encoding = CmsLocaleManager.getResourceEncoding(cms, xmlPage);
        String contentType = "text/html; charset=" + encoding;
        content = CmsEncoder.adjustHtmlEncoding(content, encoding);
        Object obj = cms.getRequestContext().getAttribute("org.opencms.file.wrapper.CmsObjectWrapper");
        if (obj != null) {
            CmsObjectWrapper wrapper = (CmsObjectWrapper)obj;
            stylesheet = wrapper.rewriteLink(stylesheet);
        }
        String base = OpenCms.getSystemInfo().getOpenCmsContext();
        StringBuffer result = new StringBuffer(content.length() + 1024);
        result.append("<html><head>");
        result.append("<meta http-equiv=\"content-type\" content=\"");
        result.append(contentType);
        result.append("\">");
        result.append("<title>");
        result.append(cms.getRequestContext().removeSiteRoot(path));
        result.append("</title>");
        if (!"".equals(stylesheet)) {
            result.append("<link href=\"");
            result.append(base);
            result.append(stylesheet);
            result.append("\" rel=\"stylesheet\" type=\"text/css\">");
        }
        result.append("</head><body>");
        result.append(content);
        result.append("</body></html>");
        content = result.toString();
        return content.trim();
    }

    private CmsResource findXmlPage(CmsObject cms, String resourcename) {
        String path = cms.getRequestContext().removeSiteRoot(resourcename);
        do {
            if (cms.existsResource(path)) {
                try {
                    CmsResource res = cms.readResource(path);
                    I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(res.getTypeId());
                    if (resType instanceof CmsResourceTypeXmlPage) {
                        return res;
                    }
                }
                catch (CmsException ex) {}
                break;
            }
            if (!(path = CmsResource.getParentFolder(path)).endsWith("/")) continue;
            path = path.substring(0, path.length() - 1);
        } while (!CmsStringUtil.isEmpty(path));
        return null;
    }

    private CmsResource getResourceForElement(CmsResource xmlPage, String path, int length) {
        CmsWrappedResource wrap = new CmsWrappedResource(xmlPage);
        wrap.setRootPath(path);
        wrap.setTypeId(CmsResourceTypePlain.getStaticTypeId());
        wrap.setFolder(false);
        wrap.setLength(length);
        return wrap.getResource();
    }

    private CmsResource getResourceForLocale(CmsResource xmlPage, Locale locale) {
        CmsWrappedResource wrap = new CmsWrappedResource(xmlPage);
        wrap.setRootPath(xmlPage.getRootPath() + "/" + locale.getLanguage() + "/");
        wrap.setTypeId(CmsResourceTypePlain.getStaticTypeId());
        wrap.setFolder(true);
        return wrap.getResource();
    }

    private String getStringValue(CmsObject cms, CmsResource resource, byte[] content) throws CmsException {
        CmsProperty prop = cms.readPropertyObject(resource, "content-encoding", true);
        String enc = prop.getValue();
        if (enc == null) {
            enc = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return CmsEncoder.createString(content, enc);
    }

    private String getSubPath(CmsObject cms, CmsResource xmlPage, String resourcename) {
        if (xmlPage != null) {
            String rootPath = cms.getRequestContext().addSiteRoot(resourcename);
            String path = rootPath.substring(xmlPage.getRootPath().length());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return null;
    }

    private List getVirtualFiles() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(NAME_ELEMENT_CONTROLCODE);
        return list;
    }
}

