/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexCacheEntry;
import org.opencms.flex.CmsFlexCacheException;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.flex.Messages;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsFlexRequestDispatcher
implements RequestDispatcher {
    private static final Log LOG = CmsLog.getLog(CmsFlexRequestDispatcher.class);
    private String m_extTarget;
    private RequestDispatcher m_rd;
    private String m_vfsTarget;

    public CmsFlexRequestDispatcher(RequestDispatcher rd, String vfs_target, String ext_target) {
        this.m_rd = rd;
        this.m_vfsTarget = vfs_target;
        this.m_extTarget = ext_target;
    }

    public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        CmsFlexController controller = CmsFlexController.getController(req);
        controller.setForwardMode(true);
        this.m_rd.forward(req, res);
    }

    public void include(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_INCLUDING_TARGET_2", this.m_vfsTarget, this.m_extTarget));
        }
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsResource resource = null;
        if (this.m_extTarget == null && controller != null) {
            try {
                resource = controller.getCmsObject().readResource(this.m_vfsTarget);
            }
            catch (CmsVfsResourceNotFoundException e) {
                this.m_extTarget = this.m_vfsTarget;
            }
            catch (CmsException e) {
                throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_VFS_ACCESS_EXCEPTION_0"), (Throwable)e);
            }
        }
        if (this.m_extTarget != null || controller == null) {
            this.includeExternal(req, res);
        } else if (controller.isForwardMode()) {
            this.includeInternalNoCache(req, res, controller, controller.getCmsObject(), resource);
        } else {
            this.includeInternalWithCache(req, res, controller, controller.getCmsObject(), resource);
        }
    }

    private void includeExternal(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_INCLUDING_EXTERNAL_TARGET_1", this.m_extTarget));
        }
        this.m_rd.include(req, res);
    }

    private void includeInternalNoCache(ServletRequest req, ServletResponse res, CmsFlexController controller, CmsObject cms, CmsResource resource) throws ServletException, IOException {
        I_CmsResourceLoader loader;
        try {
            if (resource == null) {
                resource = cms.readResource(this.m_vfsTarget);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_LOADING_RESOURCE_TYPE_1", new Integer(resource.getTypeId())));
            }
            loader = OpenCms.getResourceManager().getLoader(resource);
        }
        catch (CmsException e) {
            controller.setThrowable(e, this.m_vfsTarget);
            throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_ERROR_READING_RESOURCE_1", this.m_vfsTarget), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_INCLUDE_RESOURCE_1", this.m_vfsTarget));
        }
        try {
            loader.service(cms, resource, req, res);
        }
        catch (CmsException e) {
            controller.setThrowable(e, this.m_vfsTarget);
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeInternalWithCache(ServletRequest req, ServletResponse res, CmsFlexController controller, CmsObject cms, CmsResource resource) throws ServletException, IOException {
        CmsFlexCache cache = controller.getCmsCache();
        CmsFlexRequest f_req = controller.getCurrentRequest();
        CmsFlexResponse f_res = controller.getCurrentResponse();
        if (f_req.containsIncludeCall(this.m_vfsTarget)) {
            throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_INCLUSION_LOOP_1", this.m_vfsTarget));
        }
        f_req.addInlucdeCall(this.m_vfsTarget);
        if (f_res.isSuspended()) {
            f_res.setCmsIncludeMode(false);
            f_req.removeIncludeCall(this.m_vfsTarget);
            return;
        }
        f_res.setCmsIncludeMode(true);
        CmsFlexRequest w_req = new CmsFlexRequest((HttpServletRequest)req, controller, this.m_vfsTarget);
        CmsFlexResponse w_res = new CmsFlexResponse((HttpServletResponse)res, controller);
        controller.push(w_req, w_res);
        try {
            CmsFlexCacheEntry entry = null;
            if (f_req.isCacheable()) {
                entry = cache.get(w_req.getCmsCacheKey());
                if (entry != null) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_LOADING_RESOURCE_FROM_CACHE_1", this.m_vfsTarget));
                        }
                        controller.updateDates(entry.getDateLastModified(), entry.getDateExpires());
                        entry.service(w_req, w_res);
                    }
                    catch (CmsException e) {
                        Throwable t = e.getCause() != null ? e.getCause() : e;
                        t = controller.setThrowable(e, this.m_vfsTarget);
                        throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_ERROR_LOADING_RESOURCE_FROM_CACHE_1", this.m_vfsTarget), t);
                    }
                }
                CmsFlexCacheKey res_key = cache.getKey(CmsFlexCacheKey.getKeyName(this.m_vfsTarget, w_req.isOnline()));
                if (res_key != null) {
                    w_res.setCmsCacheKey(res_key);
                } else {
                    String cacheProperty = null;
                    try {
                        if (resource == null) {
                            resource = cms.readResource(this.m_vfsTarget);
                        }
                        if ((cacheProperty = cms.readPropertyObject(resource, "cache", true).getValue()) == null) {
                            cacheProperty = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getCachePropertyDefault();
                        }
                        cache.putKey(w_res.setCmsCacheKey(cms.getRequestContext().addSiteRoot(this.m_vfsTarget), cacheProperty, f_req.isOnline()));
                    }
                    catch (CmsFlexCacheException e) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_INVALID_CACHE_KEY_2", this.m_vfsTarget, cacheProperty));
                        }
                        cache.putKey(w_res.getCmsCacheKey());
                    }
                    catch (CmsException e) {
                        controller.setThrowable(e, this.m_vfsTarget);
                        throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_ERROR_LOADING_CACHE_PROPERTIES_1", this.m_vfsTarget), (Throwable)e);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_ADDING_CACHE_PROPERTIES_2", this.m_vfsTarget, cacheProperty));
                    }
                }
            }
            if (entry == null) {
                I_CmsResourceLoader loader = null;
                String variation = null;
                if (w_req.isCacheable()) {
                    variation = w_res.getCmsCacheKey().matchRequestKey(w_req.getCmsCacheKey());
                }
                w_res.setCmsCachingRequired(!controller.isForwardMode() && variation != null);
                try {
                    if (resource == null) {
                        resource = cms.readResource(this.m_vfsTarget);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_LOADING_RESOURCE_TYPE_1", new Integer(resource.getTypeId())));
                    }
                    loader = OpenCms.getResourceManager().getLoader(resource);
                }
                catch (ClassCastException e) {
                    controller.setThrowable(e, this.m_vfsTarget);
                    throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_CLASSCAST_EXCEPTION_1", this.m_vfsTarget), (Throwable)e);
                }
                catch (CmsException e) {
                    controller.setThrowable(e, this.m_vfsTarget);
                    throw new ServletException(Messages.get().getBundle().key("ERR_FLEXREQUESTDISPATCHER_ERROR_READING_RESOURCE_1", this.m_vfsTarget), (Throwable)e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_INCLUDE_RESOURCE_1", this.m_vfsTarget));
                }
                try {
                    loader.service(cms, resource, (ServletRequest)w_req, (ServletResponse)w_res);
                }
                catch (CmsException e) {
                    controller.setThrowable(e, this.m_vfsTarget);
                    throw new ServletException((Throwable)e);
                }
                entry = w_res.processCacheEntry();
                if (entry != null && variation != null && w_req.isCacheable()) {
                    if (w_res.getCmsCacheKey().getTimeout() > 0L) {
                        entry.setDateLastModifiedToPreviousTimeout(w_res.getCmsCacheKey().getTimeout());
                        entry.setDateExpiresToNextTimeout(w_res.getCmsCacheKey().getTimeout());
                        controller.updateDates(entry.getDateLastModified(), entry.getDateExpires());
                    } else {
                        entry.setDateLastModified(controller.getDateLastModified());
                        entry.setDateExpires(controller.getDateExpires());
                    }
                    cache.put(w_res.getCmsCacheKey(), entry, variation);
                } else {
                    controller.updateDates(-1L, controller.getDateExpires());
                }
            }
            if (f_res.hasIncludeList()) {
                Map headers = w_res.getHeaders();
                byte[] result = w_res.getWriterBytes();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTDISPATCHER_RESULT_1", new String(result)));
                }
                CmsFlexResponse.processHeaders(headers, (HttpServletResponse)f_res);
                f_res.addToIncludeResults(result);
                result = null;
            }
            Object var16_21 = null;
            f_res.setCmsIncludeMode(false);
            f_req.removeIncludeCall(this.m_vfsTarget);
            controller.pop();
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            f_res.setCmsIncludeMode(false);
            f_req.removeIncludeCall(this.m_vfsTarget);
            controller.pop();
            throw throwable;
        }
    }
}

