/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.Messages;
import org.opencms.main.CmsLog;

public class CmsFlexRequestKey {
    private static final Log LOG = CmsLog.getLog(CmsFlexRequestKey.class);
    private CmsRequestContext m_context;
    private HttpServletRequest m_request;
    private String m_resource;

    public CmsFlexRequestKey(HttpServletRequest req, String target, boolean online) {
        this.m_request = req;
        CmsObject cms = CmsFlexController.getCmsObject((ServletRequest)req);
        this.m_context = cms.getRequestContext();
        this.m_resource = CmsFlexCacheKey.getKeyName(this.m_context.addSiteRoot(target), online);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTKEY_CREATED_NEW_KEY_1", this.m_resource));
        }
    }

    public String getElement() {
        return this.m_request.getParameter("__element");
    }

    public String getEncoding() {
        return this.m_context.getEncoding();
    }

    public String getIp() {
        return this.m_context.getRemoteAddress();
    }

    public String getLocale() {
        return this.m_context.getLocale().toString();
    }

    public Map getParams() {
        Map params = this.m_request.getParameterMap();
        if (params.size() == 0) {
            return null;
        }
        return params;
    }

    public Integer getPort() {
        return new Integer(this.m_request.getServerPort());
    }

    public String getResource() {
        return this.m_resource;
    }

    public String getScheme() {
        return this.m_request.getScheme().toLowerCase();
    }

    public HttpSession getSession() {
        return this.m_request.getSession(false);
    }

    public String getSite() {
        return this.m_context.getSiteRoot();
    }

    public String getUri() {
        return this.m_context.addSiteRoot(this.m_context.getUri());
    }

    public String getUser() {
        return this.m_context.currentUser().getName();
    }
}

